/* 
 *  premiere_stubs.cpp 
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include "stdafx.h"
#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <crtdbg.h>
#include ".\Premiere\prTypes.h"
#include ".\Premiere\prCompile.h"
#include ".\Premiere\prWinEnv.h"
#include  ".\Premiere\premiere.h"
#include "debug.h"
#include "PremierePlugin.h"

extern CGlobalSettings g_formatSettings;

char *fnewPtr( long size )
{
	char *newptr/*, szTemp[260]*/;
	newptr = (char *)malloc( (size_t)size );
	//sprintf( szTemp, "newPtr. Size:%d Pointer:%p\n", size, newptr);
	//OutputDebugString(szTemp);
	return newptr;
}


//   PREMIERE STUBS


long fsetPtrSize ( char *ptr, long newsize )
{
	
	//MessageBox(NULL,"setPtrSize","Encoder",MB_OK);
  _RPT1(_CRT_WARN, "setPtrSize: %d bytes\n", newsize );
	return (LONG)realloc( ptr, newsize );
}

long fgetPtrSize ( char *ptr )
{
	//MessageBox(NULL,"getPtrSize","Encoder",MB_OK);
  _RPT0(_CRT_WARN, "getPtrSize\n");
	return _msize( ptr );
}

void fdisposePtr( char *ptr )
{
	printf( "disposePtr. Pointer:%p\n", ptr);
	free( ptr );
}

int fsetClassData ( long theClass, long info )
{
	MessageBox(NULL,"SetClassData","Encoder",MB_OK);
	return 0;
}

long fgetClassData ( long theClass )
{
	MessageBox(NULL,"GetClassData","Encoder",MB_OK);
	return 0;
}






int fgetFrameInfo ( long frame, compFrameInfoRec *frameInfo, long compileSeqID )
{
	MessageBox(NULL,"GetFrameInfo","Encoder",MB_OK);
	return 0;
}

compHistogramPtr fhistogramInit ( void )
{
	MessageBox(NULL,"HistogramInit","Encoder",MB_OK);
	return NULL;
}

void fhistogramFree ( compHistogramPtr histogram )
{
	MessageBox(NULL,"HistogramFree","Encoder",MB_OK);
	return;
}

int fhistogramProcessPixels ( compHistogramFrameInfoRec *histogramInfo, compHistogramPtr histogram )
{
	MessageBox(NULL,"HistogramProcessPixels","Encoder",MB_OK);
	return 0;
}

compPalette fhistogramToPalette ( compHistogramPtr histogram, char *lp16to8, int nColors )
{
	MessageBox(NULL,"HistogramToPalette","Encoder",MB_OK);
	return NULL;
}

void fhistogramDisposePalette ( compPalette palette )
{
	MessageBox(NULL,"HistogramDisposePalette","Encoder",MB_OK);
	return;
}

void fhistogramReducePixels( compPixelInfoRec *histogramPixelInfo, compPalette palette, char *lp16to8 )
{
	MessageBox(NULL,"HistogramReducePixels","Encoder",MB_OK);
	return;
}

void fstartDebug( long playID )
{
	printf( "StartDebug:%d\n", playID );
}

void fdebugStr( long playID, char *cstr )
{
	printf( "Debug:%s\n", cstr );
}

char** fnewHandle ( long size )
{
	MessageBox(NULL,"newHandle","Encoder",MB_OK);
	return NULL;
}

short fsetHandleSize ( char **Handle, long newsize )
{
	MessageBox(NULL,"setHandleSize","Encoder",MB_OK);
	return 0;
}

long fgetHandleSize ( char **Handle )
{
	MessageBox(NULL,"getHandleSize","Encoder",MB_OK);
	return 0;
}

void fdisposeHandle ( char **Handle )
{
	MessageBox(NULL,"disposeHandle","Encoder",MB_OK);
	return;
}

void f2setPtrSize ( char **ptr, long newsize )
{
	MessageBox(NULL,"2setPtrSize","Encoder",MB_OK);
	return;
}

void fupdateAllWindows (void)
{
	MessageBox(NULL,"updateAllWindows","Encoder",MB_OK);
	return;
}

long fgetMainWnd (void)
{
	//MessageBox(NULL,"getMainWnd","Encoder",MB_OK);
	return (long)NULL;
}

char* fppixGetPixels ( PPixHand pix )
{
	MessageBox(NULL,"ppixGetPixels","Encoder",MB_OK);
	return NULL;
}

void fppixGetBounds ( PPixHand pix, prRect* bounds )
{
	MessageBox(NULL,"ppixGetBounds","Encoder",MB_OK);
	return;
}

int fppixGetRowbytes ( PPixHand pix )
{
	MessageBox(NULL,"ppixGetRowbytes","Encoder",MB_OK);
	return 0;
}

long fgetInfoChunkSize( int chunkID )
{
	MessageBox(NULL,"getInfoChunkSize","Encoder",MB_OK);
	return 0;
}

void fgetInfoChunk( int chunkID, void *buffer )
{
	MessageBox(NULL,"getInfoChunk","Encoder",MB_OK);
	return;
}

void fsetProgressStr( char *ptr, long compileSeqID )
{
	char szTemp[260];
	sprintf( szTemp, "setProgressStrFunc. Name:%s ID:%d\n", ptr, compileSeqID );
//	MessageBox(NULL, szTemp ,"Encoder",MB_OK);
	return;
}

int fupdateProgress( long frame, long compileSeqID )
{
	char szTemp[260];
	sprintf( szTemp, "updateProgressFunc, frame %d", frame);
	MessageBox(NULL, szTemp ,"Encoder",MB_OK);
	return 0;
}


// PiSuites Utilities
long fgetSettings (long settingsSelector){
	return g_formatSettings.Get( settingsSelector );
} 

compStdParms      stdParms;
compInfoRec				infoRec;			            //Retrieves info from plugin
compFileInfoRec			fileInfoRec;		            //Retrieves supported formats
compAudioInfoRec        audioInfoRec;

//	callbacks
compCallbackFuncs   callbackFuncs;      //Callback functions from the plugin
ClassDataFuncs 	    classFuncs;
compAudioFuncs		  audioFuncs;
compVideoFuncs      videoFuncs;
compMemoryFuncs     memoryFuncs;
compProgressFuncs   progressFuncs;
compDebugFuncs      debugFuncs;
// piSuites and related callbacks
piSuites            SuitesFunctions;
PlugMemoryFuncs     PMMFunctions;
PlugWindowFuncs     PWIFunctions;
PlugppixFuncs       PPXFuncs;
PlugUtilFuncs       PUTFuncs;


//  Inits Premiere structures and Stubs
void InitPremiereCallbacks(void)
{
	//Premiere Memory functions

	//Class Functions
	classFuncs.setClassData = fsetClassData;
	classFuncs.getClassData = fgetClassData;

	//Audio Functions
	audioFuncs.getAudio=				fgetAudio;
	audioFuncs.getBlipMax=				fgetBlipMax;

	//Video Functions
	videoFuncs.getFrame=				  fgetFrame;
	videoFuncs.getFrameInfo=			fgetFrameInfo;
	videoFuncs.histogramInit=			fhistogramInit;
	videoFuncs.histogramFree=			fhistogramFree;
	videoFuncs.histogramProcessPixels=	fhistogramProcessPixels;
	videoFuncs.histogramToPalette=		fhistogramToPalette;
	videoFuncs.histogramDisposePalette=	fhistogramDisposePalette;
	videoFuncs.histogramReducePixels=	fhistogramReducePixels;

	//Memory Functions
	memoryFuncs.newPtr=					fnewPtr;
	memoryFuncs.setPtrSize=				fsetPtrSize;
	memoryFuncs.getPtrSize=				fgetPtrSize;
	memoryFuncs.disposePtr=				fdisposePtr;

	//Fucking Progress Functions (not docced)
	progressFuncs.setProgressStr=		fsetProgressStr;
	progressFuncs.updateProgress=		fupdateProgress;
  //progressFuncs.ProgressStats =   fprogressStats;

	// Debuggin
	debugFuncs.debugStr         =       fdebugStr;
	debugFuncs.startDebug       =       fstartDebug;

	SuitesFunctions.piInterfaceVer  =  COMPILEMOD_VERSION_1;

	PMMFunctions.newPtr         = fnewPtr;
	PMMFunctions.setPtrSize     = f2setPtrSize;
	PMMFunctions.getPtrSize     = fgetPtrSize;
	PMMFunctions.disposePtr     = fdisposePtr;
	PMMFunctions.newHandle      = fnewHandle;
	PMMFunctions.setHandleSize  = fsetHandleSize;
	PMMFunctions.getHandleSize  = fgetHandleSize;
	PMMFunctions.disposeHandle  = fdisposeHandle;
		SuitesFunctions.memFuncs   = &PMMFunctions;

	memset(&PWIFunctions,1,sizeof(PlugWindowFuncs));
	PWIFunctions.updateAllWindows = fupdateAllWindows;
	PWIFunctions.getMainWnd       = fgetMainWnd;
		SuitesFunctions.windFuncs  =  &PWIFunctions;

	memset(&PPXFuncs,2,sizeof(PlugppixFuncs));
		PPXFuncs.ppixGetPixels   = fppixGetPixels;
		PPXFuncs.ppixGetBounds   = fppixGetBounds;
		PPXFuncs.ppixGetRowbytes = fppixGetRowbytes;
		SuitesFunctions.ppixFuncs = &PPXFuncs;
	
	memset(&PUTFuncs, 3, sizeof(PlugUtilFuncs));
		PUTFuncs.getSettings = fgetSettings;
		SuitesFunctions.utilFuncs = &PUTFuncs;
	// Asignations
	callbackFuncs.classFuncs=&classFuncs;
	callbackFuncs.audioFuncs=&audioFuncs;
	callbackFuncs.videoFuncs=&videoFuncs;
	callbackFuncs.memoryFuncs=&memoryFuncs;
	callbackFuncs.progressFuncs=&progressFuncs;
	callbackFuncs.debugFuncs     =&debugFuncs;

  //StdParms
	stdParms.compInterfaceVer = 1;
	stdParms.funcs    =  &callbackFuncs;
	stdParms.piSuites =  &SuitesFunctions;
};

