//========================================================================================
//
// prExtension.h
//
// Part of the Adobe Premiere 5 Plug-In extensions v1.1.
//
// Defines the Premiere Plug-in Movie Compiler interface extensions.
//
// Note: update prCompile.h and prPlugUtil and add prExtension.h if the extensions are used
//             
// The extension enables FlasK to export YUV data through the Premiere interface
// 
// Extensions are proposed by Edwin van Eggelen (@15 June 2001) edwinvaneggelen@softhome.net
//                            
// 
//========================================================================================


// Usage:
//
// Notify that the extensions are supported by plug-in:
// ----------------------------------------------------
//
// When compStartup message is send to the plugin, it has to fill the compInfoRec.
// If the extensions are used, the plugin sends the supported video video format back.
//
// If the extensions are supported, set the classID to 'yuv@' (classID='yuv@') and
// the extension to 'true' (extension='true', so NOT extention=1, use ASCII chars) from the compInfoRec struct.
// This notifies FlasK that the extensions are supported.
// Secondly, the supported outputformat is filled in the suppOutputFormat.
// you can do this in the following way : suppOutputFormat=PrI_RGB32+PrI_RGB24+PrI_YUY2...... 
// (PrI_RGB32 PrI_YUV PrI_YV12 are defined in prExtensions.h"

// Detecting the output format:
// ----------------------------
//
// After the CompStartup function is called, the output format can be retrieved.
// First you need to check if the extensions are used. This can be done by 
// calling the utilFunction getSettings(kSettingsSubtype). If the return value is 'EXTD' in ASCII chars
// the extended interface is supported.
// Is you are sure that the extended interface is supported, the util function 
// getSettings(kSettingsVidFormat ) can be called to retrieve the selected output format.
// Note that this procedure works in the CompDoCompil and GetFilePrefs function.
// 
// VideoFormat==PrI_RGB32;
// if (stdParms->piSuites->utilFuncs->getSettings(kSettingsSubtype)=='EXTD')
//	  long VideoFormat=stdParms->piSuites->utilFuncs->getSettings(kSettingsVidFormat );
//
// If (VideoFormat==PrI_RGB32) VideoFormat=RGB32....
// if (VideoFormat==PrI_YUY2 ) VideoFormat=YUY2.....
// if (VideoFormat=.............

#define 	PrI_RGB32	64
#define		PrI_RGB24	128
#define		PrI_YUY2	256
#define		PrI_YV12	512
#define		PrI_YVYU	1024
#define		PrI_VYUY	2048
#define		PrI_UYVY	4096
#define		PrI_IYUV	8192
