// PremierePlugin.h: interface for the CPremierePlugin class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_PREMIEREPLUGIN_H__7D5FA2CF_6934_4E45_A549_07C91EEFB069__INCLUDED_)
#define AFX_PREMIEREPLUGIN_H__7D5FA2CF_6934_4E45_A549_07C91EEFB069__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000


#include <stdlib.h>
#include "..\include\floutapi.h"
#include ".\Premiere\prTypes.h"
#include ".\Premiere\prCompile.h"
#include ".\Premiere\prWinEnv.h"
#include  ".\Premiere\premiere.h"


// This class stores the current format settings
// There is one global instance of this class g_formatSettings
class CGlobalSettings
{
public:
  CGlobalSettings() {
    m_nWidth = 640;
    m_nHeight = 480;
    m_nIsStereo = 1;
    m_nIs16BitAudio = 1;
    m_nVidFormat = PrI_RGB32;
    m_nSubtype = 'EXTD';
  }
  long Get( int selector );
  void Set( int selector , long value );
private:
  int m_nWidth, m_nHeight;
  int m_nIsStereo, m_nIs16BitAudio;
  int m_nAudRate;
  int m_nVidFormat;
  int m_nSubtype;
};

class CPremierePlugin  
{
public:
	CPremierePlugin( char *filename );
	virtual ~CPremierePlugin();
  flreturn_t floutentry(flselector_t sel, ui32 par1, ui32 par2 );

	flreturn_t startup( startup_s *st );
  flreturn_t shutdown();
  flreturn_t configure();
  flreturn_t compile(compile_s *cs);
  flreturn_t getinfo(ui32 par1, ui32 par2);
  flreturn_t setinfo(ui32 par1, ui32 par2);

  flreturn_t DoCompile( videodef_s *vd, audiodef_s *ad, compile_s *cs );

  // callbacks
  int fgetFrame ( long frame, void **buffer, long *rowbytes, compGetFrameReturnRec *getFrameReturn, char getCompressed );
  int fgetAudio ( long frame, long *frameCount, long *size, long offset, BufferReturnType theBuffer );
  long fgetBlipMax ()  { return m_nAudSamplesPerFrame*m_nAudBlockAlign; }

private:
  char m_filename[1024];
  HINSTANCE m_hInstLibrary;
  CompileEntryFunc m_pPremEntry;

  long m_nCompilerID;
  long m_nFileType;
  char m_CompilerName[1024];
  long m_nSupportedVideoFormats;
  long m_nFloutSupported;
  long m_nAudSamplesPerFrame;
  long m_nAudBlockAlign;
  HANDLE m_hOutputFile;

  // Settings
  PBYTE m_pSettings;
  int   m_nSettingsSize;

  // flo info
  compile_s *m_cs;
  audiodef_s *m_ad;
  videodef_s *m_vd;

  getvideo_s        m_gv;
  getvideo_report_s m_gvr;
  getaudio_s        m_ga;
  getaudio_report_s m_gar;
};

#endif // !defined(AFX_PREMIEREPLUGIN_H__7D5FA2CF_6934_4E45_A549_07C91EEFB069__INCLUDED_)
