// PremiereOut.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "PremiereOut.h"
#include "PremierePlugin.h"
#include "debug.h"

static CPremiereOut g_PremiereOut;
CGlobalSettings g_formatSettings;

PREMIEREOUT_API flreturn_t floutentry_getids( flohandle_t **ids )
{
  int cnt;
  cnt = g_PremiereOut.LoadPlugins();
  if(cnt) 
    *ids = g_PremiereOut.GetHandles();
  else
    *ids = NULL;
  return (flreturn_t)cnt;
}

PREMIEREOUT_API flreturn_t floutentry( flohandle_t id, flselector_t sel, ui32 par1, ui32 par2 )
{
  return ((CPremierePlugin *)id)->floutentry( sel, par1, par2 );
}


extern void InitPremiereCallbacks(void);


// This is the constructor of a class that has been exported.
// see PremiereOut.h for the class definition
CPremiereOut::CPremiereOut()
{ 
  InitPremiereCallbacks();
  for( int i=0; i<256; i++ )
    m_pPlugins[i] = 0;

  int m_nCnt = 0;
	return; 
}

void CPremiereOut::DeletePlugins()
{
  for( int i=0; i<256; i++ )
  {
    if( m_pPlugins[i] )
    {
      delete m_pPlugins[i];
      m_pPlugins[i] = 0;
    }
  }
}

bool CPremiereOut::IsPremierePlugin( char *filename )
{
  HINSTANCE hInstLib;
  bool bSuccess = true;

	hInstLib = LoadLibrary(filename); 
	// If the handle is valid, try to get the function address.
	if (!hInstLib)
		bSuccess = false;
  
  if( bSuccess )
  {
  	CompileEntryFunc CompileEntry = (CompileEntryFunc) GetProcAddress(hInstLib, "xCompileEntry");
	  if(!CompileEntry)
      bSuccess = false;
	}		
  FreeLibrary(hInstLib);
  return bSuccess;
}

int CPremiereOut::LoadPlugins()
{
	WIN32_FIND_DATA find_data;
	char            directory[MAX_PATH];
	HANDLE          search_handle;
	int i;
	int loaded_ok=0;

  DeletePlugins();

  char program_directory[MAX_PATH], load_directory[MAX_PATH];
  char szTemp[MAX_PATH];
  GetModuleFileName(NULL, szTemp, MAX_PATH);

  // Copy just the path
  // We do that by replacing the last \ with end-of-string.
  char *p,*pbs = 0;
  for (p = szTemp; *p ; p++) if (*p == '\\') pbs = p;
  if (pbs) *pbs = '\0';
  strcpy(program_directory, szTemp);

	
	strcpy( load_directory, program_directory);	
	sprintf(directory, "%s\\*.cm.flask", load_directory);

	i=0;
	search_handle = FindFirstFile(directory, &find_data);
	if(search_handle==INVALID_HANDLE_VALUE){
		return loaded_ok;
	}
	else{
		if(IsPremierePlugin( find_data.cFileName ))
      m_pPlugins[loaded_ok++] = new CPremierePlugin( find_data.cFileName );


		while( FindNextFile(search_handle, &find_data ) ) {
			if(IsPremierePlugin( find_data.cFileName ))
        m_pPlugins[loaded_ok++] = new CPremierePlugin( find_data.cFileName );
		}
		FindClose(search_handle);
	}

  m_nCnt = loaded_ok;
	return loaded_ok;

}