/* 
 *  Vcdread.h  // routines to access .dat vcd data
 *
 *	Copyright (C) Alberto Vigata - December 2000  ultraflask@yahoo.com
 *    
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#ifndef VCDREAD_H
#define VCDREAD_H

#define CDXA_SECTOR_SIZE      2352
#define CDXA_SECTOR_DATASIZE  2324
#define CDXA_SECTOR_DATASTART 23    // offset
#define CDXA_SECTOR_DATAEND   2347  // offset

#include "..\include\flasktypes.h"

struct TrackData
{
  unsigned long nSectorCount;
  unsigned long nDataStart;
  FILE *pFile;


  unsigned long nSectorIdx;
  unsigned long nSectorPos;
  
  struct 
  {
    ui8 sync[12];
    ui8 header[4];
    ui8 subheader[8];
    ui8 data[2324];
    ui8 edc[4];
  } sSector;
};



// Finds out is the file is a valid CDXA RIFF track
bool VCDIsVAlidTrack(char *pFileName);

TrackData *VCDOpenStream(char *pFileName );

int VCDReadStream(TrackData *pTrackData, ui8 *buf, unsigned int nSize);

bool VCDCloseStream(TrackData *pTrackData);

int VCDSetStreamPos(TrackData *pTrackData, ui64 pos);

int VCDGetStreamPos(TrackData *pTrackData, ui64 *pos);

ui64 VCDGetStreamSize(TrackData *pTrackData);

#endif