
/*
 * TIME MAP TABLE
 *
 * Copyright (C) 1998,1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 */


#ifdef PARSER
#include <stdio.h>
#endif
#include <sys/types.h>
//#include <unistd.h>
#include "ifo.h"

#include "misc.h"
#include "decode.h"


#ifdef PARSER

/**
 *
 */

void ifoPrintTMT (ifo_t *ifo)
{
	u_int32_t *ptr = (u_int32_t *) ifo->data[ID_TMT];
	ifoq_hdr_t *hdr = (ifoq_hdr_t *) ifo->data[ID_TMT];
	int i;

	if (!ifo->data[ID_TMT])
		return;

	printf ("\nTIME MAP TABLE\n");
	printf ("---\n");
	printf ("number of maps: %d\n", hdr->num);	
	printf ("length of table: %d\n", hdr->len);	
	printf ("('*' specifies last entry in chapter)\n");

	ptr += IFOQ_HDR_LEN;

	for (i=0; i<hdr->num; i++)
		printf ("%d start 0x%x\n", i, *(ptr++));

	{
		ifoq_tmt_hdr_t *tmt_hdr = (ifoq_tmt_hdr_t *) ptr;

		printf ("time unit (in seconds): %d\n", tmt_hdr->tu);

		ptr += IFOQ_TMT_HDR_LEN;
	}

/*	while (ptr < (((u_char *) hdr) + hdr->len)) {
		printf ("0x%06x%c ", (*ptr)&0x7FFFFFFF,
				(*ptr)&0x80000000 ? '*' : ' ');
		ptr++;
	}
*/
//DENT print all maps (not only the first)
}	
#endif
