
/*
 * VIDEO TITLE SET CELL ADDRESS
 *
 * Copyright (C) 1998,1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 */

#include "IFOparser.h"
extern CIFOParser *IFOGlobal;

#include <stdio.h>
#include <malloc.h>

#include <sys/types.h>
//#include <unistd.h>
#include "ifo.h"

#include "misc.h"
#include "decode.h"

#define CADDR_HDR_LEN 8

typedef struct {
	u_short	num		: 16;	// Number of Video Objects
	u_short unknown		: 16;	// don't know
	u_int	len		: 32;	// length of table
} cell_addr_hdr_t;

static void _ifoPrint_cell_addr (u_char *ptr);


#ifdef PARSER
/**
 *
 */

void ifoPrint_vts_cell_addr (ifo_t *ifo)
{
	printf ("\nTITLE SET ");

	if (ifo->data[ID_TITLE_CELL_ADDR])
		_ifoPrint_cell_addr (ifo->data[ID_TITLE_CELL_ADDR]);
}


/**
 *
 */

void ifoPrint_vtsm_cell_addr (ifo_t *ifo)
{
	printf ("\nMENU ");

	if (ifo->data[ID_MENU_CELL_ADDR])
		_ifoPrint_cell_addr (ifo->data[ID_MENU_CELL_ADDR]);
}


/**
 *
 */

void _ifoPrint_cell_addr (u_char *ptr)
{
	cell_addr_hdr_t *cell_addr_hdr = (cell_addr_hdr_t *) ptr;
	ifo_cell_addr_t *cell_addr;
	int i;

	if (!ptr)
		return;

	printf ("CELL ADDRESS\n");
	printf ("---\n");
	printf ("number of VOBs: %d\n", bswap_16 (cell_addr_hdr->num));	
	printf ("???: 0x%x\n", bswap_32 (cell_addr_hdr->unknown));	
	printf ("len: 0x%x\n", bswap_32 (cell_addr_hdr->len));	

	ptr += CADDR_HDR_LEN;
	cell_addr = (ifo_cell_addr_t *) ptr;


	int vob_id  = -1;
	int cell_id = -1;
	int id_count = -1;

	for (i=0; i<bswap_32 (cell_addr_hdr->len)/sizeof (ifo_cell_addr_t); i++) {
		printf ("\tVOB ID: 0x%x Cell ID: 0x%x Start: 0x%x End: 0x%x\n",
			bswap_16 (cell_addr->vob_id), cell_addr->cell_id,
			bswap_32 (cell_addr->start), bswap_32 (cell_addr->end));

		if(vob_id  != bswap_16 (cell_addr->vob_id) ||
			cell_id != cell_addr->cell_id ){
			id_count++;
			IFOGlobal->cell_address.SetArraySize( id_count+1 );
			IFOGlobal->cell_address[id_count].pos.EmptyArray();
			vob_id  = bswap_16 (cell_addr->vob_id);
			cell_id = cell_addr->cell_id;
		}


		IFOGlobal->cell_address[id_count].vobid    = bswap_16 (cell_addr->vob_id);
		IFOGlobal->cell_address[id_count].cellid   = cell_addr->cell_id;
		TSpan sptemp;
		sptemp.start    = (__int64)bswap_32 (cell_addr->start)*2048;
		sptemp.end      = (__int64)bswap_32 (cell_addr->end  )*2048 + 2047;

		IFOGlobal->cell_address[id_count].pos.AddItem( &sptemp );

		cell_addr ++;
	}

	printf ("\n\n\n");
}	
#endif
