
/*
 * PART OF TITLE
 *
 * Copyright (C) 1998,1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 */



#include <stdio.h>

#include <stdlib.h>
//#include <unistd.h>
#include <sys/types.h>
#include "ifo.h"

#include "misc.h"
#include "decode.h"

#define PTT_LEN 4

typedef struct {
	u_short pgc		: 16;	// Program Chain number
	u_short	pg		: 16;	// Program number
} ptt_t;


/**
 *
 */

int ifoGetVMGPTT (ifo_hdr_t *hdr, char **ptr)
{
	*ptr = ((char *) hdr) + IFO_HDR_LEN;

	return 0;
}


/**
 *
 */

int ifoGetNumberOfTitles (ifo_t *ifo)
{
	ifo_hdr_t *hdr = (ifo_hdr_t *) ifo->data[ID_PTT];

	if (!ifo->data[ID_PTT])
		return -1;
	else
		return bswap_16 (hdr->num);
}


/**
 * DENT: change this
 */

int ifoGetNumberOfParts (ifo_t *ifo)
{
	ifo_hdr_t *hdr = (ifo_hdr_t *) ifo->data[ID_PTT];

	if (!ifo->data[ID_PTT])
		return -1;
	else
		return bswap_16 (hdr->num);
}


/**
 *
 */

ifo_ptt_t *ifo_get_ptt (ifo_t *ifo)
{
	u_char *ptr;
	ifo_hdr_t *hdr;
	ifo_ptt_t *ifo_ptt;
	ifo_ptt_sub_t *ifo_ptt_sub;
	ptt_t *ptt = (ptt_t *) ptr;
	int i, s;
	u_short prev_start = 0;
	u_int num;

	if (!ifo) {
		fprintf (stderr, "%s/%d:no ifo structure present\n", __FILE__, __LINE__);
		return NULL;
	}

	ptr = (u_char *) ifo->data[ID_PTT];
	hdr = (ifo_hdr_t *) ifo->data[ID_PTT];

	if (!ptr)
		return NULL;

	if (!(ifo_ptt = (ifo_ptt_t *) malloc (sizeof (ifo_ptt_t))))
		return NULL;

	ifo_ptt->num = bswap_16 (hdr->num);

	if (!(ifo_ptt_sub = (ifo_ptt_sub_t *) calloc (ifo_ptt->num, sizeof (ifo_ptt_sub_t))))
		return NULL;

	ifo_ptt->title = ifo_ptt_sub;

	ptr += IFO_HDR_LEN;

	prev_start = get4bytes (ptr);

	for (i=0; i< bswap_16 (hdr->num); i++) {
		if (i>0) {
			ifo_ptt_sub = ifo_ptt->title+i-1;

			num = (get4bytes (ptr) - prev_start)/4;

			ptt = (ptt_t *) ((u_char *) ifo->data[ID_PTT] + prev_start);

			if (!(ifo_ptt_sub->data = (ifo_ptt_data_t *) calloc (num, sizeof (ifo_ptt_data_t))))
				return NULL;

			ifo_ptt_sub->num = num;

			for (s=0; s<num; s++) {
				ifo_ptt_sub->data[s].pg = bswap_16 (ptt->pg);
				ifo_ptt_sub->data[s].pgc = bswap_16 (ptt->pgc);

				ptt++;
			}

			prev_start = get4bytes (ptr);
		}

		ptr+=4;
	}

	ifo_ptt_sub = ifo_ptt->title+i-1;
	num = (bswap_32 (hdr->len) - prev_start + 1)/4;

	ptt = (ptt_t *) ((u_char *) ifo->data[ID_PTT] + prev_start);

// TODO: delete allocated elements when failing here
	if (!(ifo_ptt_sub->data = (ifo_ptt_data_t *) calloc (num, sizeof (ifo_ptt_data_t))))
		return NULL;

	ifo_ptt_sub->num = num;

	for (s=0; s<num; s++) {
		ifo_ptt_sub->data[s].pg = bswap_16 (ptt->pg);
		ifo_ptt_sub->data[s].pgc = bswap_16 (ptt->pgc);

		ptt++;
	}



	return ifo_ptt;
}	
