
/*
 * VIDEO TITLE SET CELL ADDRESS
 *
 * Copyright (C) 1998,1999  Thomas Mirlacher
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 * The author may be reached as dent@cosy.sbg.ac.at, or
 * Thomas Mirlacher, Jakob-Haringerstr. 2, A-5020 Salzburg,
 * Austria
 *
 *------------------------------------------------------------
 *
 */


#ifdef PARSER
#include <stdio.h>
#endif
#include <sys/types.h>
//#include <unistd.h>
#include "ifo.h"

#include "misc.h"
#include "decode.h"

#define CADDR_HDR_LEN 8

typedef struct {
	u_short	num		: 16;	// Number of Video Objects
	u_short unknown		: 16;	// don't know
	u_int	len		: 32;	// length of table
} cell_addr_hdr_t;


/**
 *
 */

int ifoGetCellAddr (char *hdr, char **ptr)
{
	if (!hdr)
		return -1;

	*ptr = hdr + CADDR_HDR_LEN;

	return 0;
}


/**
 *
 */

int ifoGetCellAddrNum (char *_hdr)
{
	cell_addr_hdr_t *hdr = (cell_addr_hdr_t *) _hdr;

	if (!hdr)
		return -1;

	return bswap_32 (hdr->len)/sizeof (ifo_cell_addr_t);
//	return bswap_16 (hdr->num);
}
