/* 
 *  FlasKMPEG Out Module API 1.0
 *  
 *  This API defines a module to input mpeg streams to FlasKMPEG.
 *
 *	Copyright (C) Alberto Vigata - December 2000  devel@flaskmpeg.net
 *    
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

/*
   this is FlasKMPEG Out Module API 1.0
   This API exports only one function, flOutEntry( handle, selector, par1, par2 );
*/

#ifndef FLOUTAPI_H
#define FLOUTAPI_H

#include "flasktypes.h"

#define FLOUT_VER 0x0100

typedef ui32 flohandle_t;
typedef ui32 floparam_t;

typedef enum{
  flo_ok = 0,
  flo_error, /* generic error */
  flo_stop,
  flo_invalidpar,
  flo_internalerror,
  flo_endfirstpass  /* indicates the end of the first pass. */
} flreturn_t;

typedef enum{
  flo_startup = 0,
  flo_shutdown,
  flo_compile,
  flo_getinfo,
  flo_setinfo,
  flo_configure
} flselector_t;

typedef enum{
  getoutsize = 0
} getinfosel_t;

typedef enum{
  flo_video = 0,
  flo_audio
}streamtype_t;


/* Types description */
#define FLO_VIDEO_RGB32 1
#define FLO_VIDEO_YV12 2
#define FLO_VIDEO_YUY2 4

typedef struct{
  ui32 channels;
  ui32 frequency;
  ui32 depth;
}pcmaudioinfo_s;


/***************************************************************/
// callbacks
/***************************************************************/

/* The index in par1 directly defines the stream type. When you opened the conversion */
typedef struct
{
  ui32 cbsize;                /* [in] size of this structure */
  ui32 timestamp;             /* [out] timestamp of the first unit in ns from beginning */
  ui8  *buf;                  /* [out] pointer to raw data */
  ui32 bufsize;               /* [out] data count in bufsize */
} getstream_s;

/* The index in par1 directly defines the stream type. When you opened the conversion */
typedef struct
{
  ui32 cbsize;                /* [in] size of this structure */
} getstream_report_s;

#define flo_streamreport 0xFFFF2000 /* id for stream report */
typedef struct
{
  getstream_report_s gsr;
  /* return info */
  ui64 byteswritten;          /* [in] bytes written to the output */

} getstream_streamreport_s;


typedef struct
{
  getstream_s gs;
  /* additional info */
  ui32 flags;                  /* [out] additional frame flags */            

  /* return info */
  ui32 framenum;               /* [in] frame number for which the following info is valid */
} getvideo_s;

typedef struct
{
  getstream_report_s gsr;
  /* return info */
  ui32 framenum;               /* [in] frame number for which the following info is valid */
  ui32 type;                   /* [in] frame type. type = 1 key frame */
  ui32 bytes;                  /* [in] number of bytes that the output frame took */
  ui8  *recons;                /* [in] reconstructed frame. format matches that of the input. NULL for no recons */

} getvideo_report_s;




typedef struct
{
  getstream_s gs;
  /* additional info */
  ui32 samplecnt;              /* [in] number of samples of the input              */
} getaudio_s;

typedef struct
{
  getstream_report_s gsr;
  /* additional info */
  ui32 bytes;                  /* [in] number of bytes that the output frame took */
} getaudio_report_s;


typedef flreturn_t (*flout_getstream_ptr)( ui32 compileid, ui32 streamid, getstream_s *st );
typedef flreturn_t (*flout_getstream_report_ptr)( ui32 compileid, ui32 streamid, getstream_report_s *st );


/* Selector description */

/**************************************************************
/* startup - Initialize the module
/* 
/* handle = NULL
/* par1 - pointer to startup_s
/* par2 - 0 
/**************************************************************/
typedef struct
{
  char modulename[256];        /* [out] name of this module */
  ui32 moduleid;               /* [out] id for this module */
  ui32 doesaudio;              /* [out] the module can do audio */
  ui32 doesvideo;              /* [out] the module can do video */
  ui32 dualpass;               /* [out] the module can do video in dual pass mode */
} startup_s;

/**************************************************************
/* shutdown - shutdown the module
/* 
/* 
/* par1 - 0
/* par2 - 0 
/**************************************************************/



/**************************************************************
/* compile - does the conversion
/* 
/* if handle is NULL, this is just a query for a valid input format.
/* par1 - pointer to compile_s.
/* par2 - 0
/**************************************************************/
typedef struct{
  ui32 cbsize;     
  ui32 streamtype;
  ui32 streamid;     /* [in] indicates the id of this stream for calls to putstream. Has to be
                             equal or greater than 1. The plugin indicates the streamid when calling 
                             getstream */
} streamdef_s;

typedef struct{
  streamdef_s strdef;
  ui32 width;                  /* [in] width of the video */
  ui32 height;                 /* [in] height of the video */
  ui32 vidformat;              /* [in] format of the video coming in */
  ui32 framerate_num;
  ui32 framerate_den;          /* [in] the framerate is num/den */
  ui32 flags;
} videodef_s;

typedef struct{
  streamdef_s strdef;
  pcmaudioinfo_s fmt;          /* [in] format of the audio coming in */
} audiodef_s;



typedef struct
{
  ui32 compileid;              /* [in] unique id for this compilation. you have pass this on getstream */
  ui32 streamcnt;              /* [in] number of streams to open */
  streamdef_s **streams;      /* [in] array of streamdef structures pointers */

  /* general */
  ui32 bitrate;                /* [in] desired bitrate for the output stream for this conversion */
  ui32 length;                 /* [in] length of the compile in frames */
  ui32 isoutfile   ;           /* [in] the output will be to the file specified at name */
  ui32 istwopass;              /* [in] the compilation is being done in two passes */
  char filename[1024];         /* [in] path for filename

  /* callbacks */ 
  flout_getstream_ptr        getstream;
  flout_getstream_report_ptr getstream_report;

} compile_s;





/**************************************************************
/* close - closes the stream conversion
/* 
/* par1 - 0.
/* par2 - 0
/**************************************************************/



/**************************************************************
/* getinfo - gets info
/* 
/* par1 - info selector
/* par2 - depends on selector
/**************************************************************/
/* The index in par1 directly defines the stream type. When you opened the conversion */
typedef struct
{
  ui8  *buf;                  /* [out] pointer to raw data */
  ui32 bufsize;               /* [out] data count in bufsize */
} cfgblockinfo_s;

typedef struct
{
  ui32 supported_fmt;         /* [out] bitmask of supported current formats */
  char fmtname[256];          /* [out] description of current format name */
  ui32 istwopass;             /* [out] video is configured for two pass mode */
} videoinfo_s;

typedef struct
{
  char fmtname[256];          /* [out] description of current format name */
} audioinfo_s;

typedef struct
{
  char extension[4];        /* [out] recommended file extension for the configured type */
} fileinfo_s;

typedef enum{
  flo_getvideoinfo = 0,
  flo_getaudioinfo,
  flo_getblockinfo,
  flo_getfileinfo,
} getinfo_t;

/**************************************************************
/* setinfo - sets info
/* 
/* par1 - info selector
/* par2 - depends on selector
/**************************************************************/
typedef enum{
  flo_setblockinfo=0
} setinfo_t;


// The library must export this function
// void floutentry( flselector_t sel, ui32 par1, ui32 par2 );
typedef flreturn_t (*floutentry_ptr)( flohandle_t id, flselector_t sel, floparam_t par1, floparam_t par2 );

// or this other function. In this case, there this is a container for multiple floutentries
typedef flreturn_t (*floutentry_getids_ptr)( flohandle_t **ids );

#endif