/* 
 *  IDCT API - provides custom iDCT libraries for FlasKMPEG MPEG decoder.
 *
 *	Copyright (C) Alberto Vigata - December 2000  ultraflask@yahoo.com
 *                 
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#include "stdafx.h"
#include "..\include\idctapi.h"

#define IDCT_COUNT 3

extern void idct_mmx_32( short *blk );

extern void Initialize_Reference_IDCT(void);
extern void Reference_IDCT( short *block);

extern void Initialize_Fast_IDCT (void);
extern void Fast_IDCT (short *block);

extern void __fastcall MMX_IDCT(short *block);
extern void __fastcall SSEMMX_IDCT(short *block);

void MMX_IDCT_helper( short *block)
{
	MMX_IDCT(block);
}

void SSEMMX_IDCT_helper( short *block)
{
	SSEMMX_IDCT(block);
}

int    GetIdctCount()
{
  return IDCT_COUNT;
}

void   GetIdct(int idx, LPFMpegIdctInfo IdctInfo)
{
  switch( idx )
  { 
  case 0:
    IdctInfo->dwFlags       = SUPPORTS_MMX | IEEE1180_COMPLIANT | INTEGER;
    IdctInfo->dwSize        = sizeof( FMpegIdctInfo );
    IdctInfo->dwVersion     = FMPEG_IDCT_VERSION;
    strcpy( IdctInfo->sDescription, "IEEE-1180 32 bits integer precision using MMX" );
    strcpy( IdctInfo->sName       , "MMX iDCT" );
    IdctInfo->InitIdct      = NULL;
    IdctInfo->DeInitIdct    = NULL;
    IdctInfo->Idct          = idct_mmx_32;
    break;
  case 1:
    IdctInfo->dwFlags       = IEEE1180_COMPLIANT | FLOATING_POINT;
    IdctInfo->dwSize        = sizeof( FMpegIdctInfo );
    IdctInfo->dwVersion     = FMPEG_IDCT_VERSION;
    strcpy( IdctInfo->sDescription, "IEEE-1180 reference double precision floating point iDCT" );
    strcpy( IdctInfo->sName       , "Reference iDCT" );
    IdctInfo->InitIdct      = Initialize_Reference_IDCT;
    IdctInfo->DeInitIdct    = NULL;
    IdctInfo->Idct          = Reference_IDCT;
    break;
  case 2:
    IdctInfo->dwFlags       = IEEE1180_COMPLIANT | INTEGER;
    IdctInfo->dwSize        = sizeof( FMpegIdctInfo );
    IdctInfo->dwVersion     = FMPEG_IDCT_VERSION;
    strcpy( IdctInfo->sDescription, "IEEE-1180 32 bits fast integer fixed precission iDCT" );
    strcpy( IdctInfo->sName       , "Fast integer iDCT" );
    IdctInfo->InitIdct      = Initialize_Fast_IDCT;
    IdctInfo->DeInitIdct    = NULL;
    IdctInfo->Idct          = Fast_IDCT;
    break;
  case 3:
    IdctInfo->dwFlags       = SUPPORTS_MMX | /*IEEE1180_COMPLIANT |*/ FLOATING_POINT; 
    IdctInfo->dwSize        = sizeof( FMpegIdctInfo );
    IdctInfo->dwVersion     = FMPEG_IDCT_VERSION;
    strcpy( IdctInfo->sDescription, "MMX iDCT based on Intel AP-922" );
    strcpy( IdctInfo->sName       , "AP-922 MMX" );
    IdctInfo->InitIdct      = NULL;
    IdctInfo->DeInitIdct    = NULL;
    IdctInfo->Idct          = SSEMMX_IDCT_helper;//SSEMMX_IDCT
    break;
  case 4:
    IdctInfo->dwFlags       = SUPPORTS_MMX | /*IEEE1180_COMPLIANT |*/ FLOATING_POINT; 
    IdctInfo->dwSize        = sizeof( FMpegIdctInfo );
    IdctInfo->dwVersion     = FMPEG_IDCT_VERSION;
    strcpy( IdctInfo->sDescription, "SSE/MMX iDCT based on Intel AP-922" );
    strcpy( IdctInfo->sName       , "AP-922 SSEMMX" );
    IdctInfo->InitIdct      = NULL;
    IdctInfo->DeInitIdct    = NULL;
    IdctInfo->Idct          = MMX_IDCT_helper;
    break;
  default:
    break;
  }
}

__declspec(dllexport)  void fmGetPluginFunc(LPFMpegIdct_PluginFunc lpPluginFunc)
{
  lpPluginFunc->GetIdct      = GetIdct;
  lpPluginFunc->GetIdctCount = GetIdctCount;
}
