/* 
 *  IDCT API - provides custom iDCT libraries for FlasKMPEG MPEG decoder.
 *
 *	Copyright (C) Alberto Vigata - December 2000  ultraflask@yahoo.com
 *                 
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#include "stdafx.h"
#include "../include/idctapi.h"

#define IDCT_COUNT 2

void Initialize_Fast_IDCT(void);
void Fast_IDCT(short *block);

void Initialize_Reference_IDCT(void);
void Reference_IDCT(short *block);

int    GetIdctCount()
{
  return IDCT_COUNT;
}

void   GetIdct(int idx, LPFMpegIdctInfo IdctInfo)
{
  switch( idx )
  { 
  case 0: // fast idct
    IdctInfo->dwFlags       = IEEE1180_COMPLIANT | FLOATING_POINT;
    IdctInfo->dwSize        = sizeof( FMpegIdctInfo );
    IdctInfo->dwVersion     = FMPEG_IDCT_VERSION;
    strcpy( IdctInfo->sDescription, "Miha Peternel's Fast x87 double precision floating point iDCT" );
    strcpy( IdctInfo->sName       , "Miha x87 Fast iDCT" );
    IdctInfo->InitIdct      = Initialize_Fast_IDCT;
    IdctInfo->DeInitIdct    = NULL;
    IdctInfo->Idct          = Fast_IDCT;
    break;
  case 1: // ref idct
    IdctInfo->dwFlags       = IEEE1180_COMPLIANT | FLOATING_POINT;
    IdctInfo->dwSize        = sizeof( FMpegIdctInfo );
    IdctInfo->dwVersion     = FMPEG_IDCT_VERSION;
    strcpy( IdctInfo->sDescription, "Miha Peternel's Reference x87 double precision floating point iDCT" );
    strcpy( IdctInfo->sName       , "Miha x87 Reference iDCT" );
    IdctInfo->InitIdct      = Initialize_Reference_IDCT;
    IdctInfo->DeInitIdct    = NULL;
    IdctInfo->Idct          = Reference_IDCT;
    break;
  default:
    break;
  }
}

__declspec(dllexport)  void fmGetPluginFunc(LPFMpegIdct_PluginFunc lpPluginFunc)
{
  lpPluginFunc->GetIdct      = GetIdct;
  lpPluginFunc->GetIdctCount = GetIdctCount;
}
