
/*

    amd-mdct.c - AMD 3DNow! Optimized Fast Hybrid iDCT Decoder

    code by Sean Stanek and Alexander Goodrich
    based on the flaskmpeg mmx idct.c file using the Chen-Wang algorithm
    thanks to Miha Peternel for some help with fixing bugs, helping to
      optimize some of the code, and for pointing us to the Chen-Wang
      algorithm.

*/

#include <math.h>

#define aligned __declspec( align( 64 ))

#define pi 3.1415926535897932384626433832795028841971693993751
aligned static unsigned __int64 negation = 0x8000000080000000;
aligned static unsigned __int64 pointfive = 0x3f0000003f000000;
aligned static unsigned __int64 oneovereight = 0x3e0000003e000000;
aligned static unsigned __int64 twofiftysix = 0x4380000043800000;
aligned static float tmp[2];
aligned static float fblock[8*8*2];
aligned static float fblock2[8*8*2];
aligned static float S2[2],W1[2],W2[2],W3[2],W5[2],W6[2],W7[2],
	     W1mW7[2],W1pW7[2],W2mW6[2],W2pW6[2],W3mW5[2],W3pW5[2];

void idctrow(float * B, float * F);
void idctcol(float * F, short * B1, short * B2);

static short* block; // hack for 2 blocks call

/* hrm:
 * I've changed the parameters to single block argument as required by flask idct api.
 * To make it work, I added a simple hack that stores a pointer to the first block.
 * (see below)
 */
//void Reference_IDCT4(short * block, short * block2)
void Reference_IDCT4(short * block2)
{
  int i;

  // hack for 2 blocks call
  if (! block) {
	  block = block2;
	  return;
  }

  /*
int * b = (int*)block;
int * b2 = (int*)block2;

  if((b[0]==0 && (b[31]==0x10000 || b[30]==0)) &&
	 (b2[0]==0 && (b2[31]==0x10000 || b2[30]==0)))
	 if(b[1]|b[2]|b[3]|b[4]|b[5]|
		b[6]|b[7]|b[8]|b[9]|b[10]|
		b[11]|b[12]|b[13]|b[14]|b[15]|
		b[16]|b[17]|b[18]|b[19]|b[20]|
		b[21]|b[22]|b[23]|b[24]|b[25]|
		b[26]|b[27]|b[28]|b[29]|b[30]|

		b2[1]|b2[2]|b2[3]|b2[4]|b2[5]|
		b2[6]|b2[7]|b2[8]|b2[9]|b2[10]|
		b2[11]|b2[12]|b2[13]|b2[14]|b2[15]|
		b2[16]|b2[17]|b2[18]|b2[19]|b2[20]|
		b2[21]|b2[22]|b2[23]|b2[24]|b2[25]|
		b2[26]|b2[27]|b2[28]|b2[29]|b2[30])
	 {
		block[31] = block2[31] = 0;
		return;
	 }
*/

  // in order to use easy SIMD, we have to convert the two 64 short blocks
  // into a single SIMD ordered float block.

  //   1 2 3 4        5 6 7 8   ->   1.0 5.0 2.0 6.0 3.0 7.0 4.0 8.0

  // movd mm0,[ebx+(0*8+0)*2]       0 | 0 | 2 | 1
  // movd mm1,[esi+(0*8+0)*2]       0 | 0 | 6 | 5
  // punpcklwd mm0,mm1              6 | 2 | 5 | 1
  // movq mm1,mm0                   6 | 2 | 5 | 1
  // punpcklwd mm0,mm0              5 | 5 | 1 | 1
  // punpckhwd mm1,mm1              6 | 6 | 2 | 2
  // pi2fw mm0,mm0                   5.0  |  1.0
  // pi2fw mm1,mm1                   6.0  |  2.0
  // movq [edi+(0*8+0)*8], mm0
  // movq [edi+(0*8+1)*8], mm1  ->  1.0 5.0 2.0 6.0 .........

  //__asm int 3
  __asm {
    #include "amdset2.asm"          // convert 128 shorts to 128 SIMD floats
  }

  // fblock now has everything in row y, "a b a b a b a b" format.
  // use SIMD on first IDCT block and second IDCT block - simultaneously.

    for (i=0; i<8; i++)
      idctrow(fblock+2*8*i,fblock2+2*8*i);

    for (i=0; i<8; i++)
      idctcol(fblock2+2*i,block+i,block2+i);

  // hack for 2 blocks call
  block = 0;

  __asm femms
}

void idctrow(float * B, float * F)
{

  __asm {

    mov esi,B
    mov edi,F

    #define x0 [esi+8*0]
    #define x1 [esi+8*4]
    #define x2 [esi+8*6]
    #define x3 [esi+8*2]
    #define x4 [esi+8*1]
    #define x5 [esi+8*7]
    #define x6 [esi+8*5]
    #define x7 [esi+8*3]

    #define F0 [edi+8*0]
    #define F1 [edi+8*1]
    #define F2 [edi+8*2]
    #define F3 [edi+8*3]
    #define F4 [edi+8*4]
    #define F5 [edi+8*5]
    #define F6 [edi+8*6]
    #define F7 [edi+8*7]

#if 1
  mov eax,x1
  mov ecx,x1[4]
  or eax,x2
  or ecx,x2[4]
  or eax,x3
  or ecx,x3[4]
  or eax,x4
  or ecx,x4[4]
  or eax,x5
  or ecx,x5[4]
  or eax,x6
  or ecx,x6[4]
  or eax,x7
  or ecx,x7[4]
  or eax,ecx
  cmp eax,0
  jnz __do_iDCT

  movq mm0,x0
  movq F0,mm0
  movq F1,mm0
  movq F2,mm0
  movq F3,mm0
  movq F4,mm0
  movq F5,mm0
  movq F6,mm0
  movq F7,mm0
	pop	edi
	pop	esi
	pop	ebp
  ret 0

__do_iDCT:
#endif

//################################============================--------....

  //  tt = W7 * (x4 + x5);      //  x4 : tt : x5
  //  x4 = tt + W1mW7 * x4;     //  x4 : tt : x5
  //  x5 = tt - W1pW7 * x5;     //  x4 : x5 : --

    movq mm0,x4
    movq mm2,x5
    movq mm1,mm0
    pfadd mm1,mm2
    pfmul mm1,W7            //  x4 : tt : x5
    pfmul mm0,W1mW7
    pfmul mm2,W1pW7
    pfadd mm0,mm1           //  x4 : tt : x5
    pfsub mm1,mm2           //  x4 : x5 : --


//  tt = W3 * (x6 + x7);      //  x4 : x5 : x6 : tt : x7
//  x6 = tt - W3mW5 * x6;     //  x4 : x5 : x6 : tt : x7
//  x7 = tt - W3pW5 * x7;     //  x4 : x5 : x6 : x7 : --

    movq mm2,x6
    movq mm4,x7
    movq mm3,mm2
    pfadd mm3,mm4
    pfmul mm3,W3            //  x4 : x5 : x6 : tt : x7
    pfmul mm2,W3mW5
    pfmul mm4,W3pW5
    pxor mm2,negation
    pfadd mm2,mm3           //  x4 : x5 : x6 : tt : x7
    pfsub mm3,mm4           //  x4 : x5 : x6 : x7 : --

////x8 = x0 + x1;             //  x4 : x5 : x6 : x7 : x0 : --
//  x0 = x0 - x1;             //  x4 : x5 : x6 : x7 : x0 : --

    movq mm4,x0
    pfsub mm4,x1            //  x4 : x5 : x6 : x7 : x0 : --

//  x1 = x4 + x6;             //  x4 : x5 : x6 : x7 : x0 : -- : x1
//  x4 = x4 - x6;             //  x4 : x5 : x6 : x7 : x0 : -- : x1

    movq mm6,mm0
    pfsub mm0,mm2           //  x4 : x5 : x6 : x7 : x0 : -- : x1
    pfadd mm6,mm2           //  x4 : x5 : x6 : x7 : x0 : -- : x1

//  x6 = x5 + x7;             //  x4 : x5 : x6 : x7 : x0 : -- : x1
//  x5 = x5 - x7;             //  x4 : x5 : x6 : x7 : x0 : -- : x1
//                            //  x4 : x5 : x6 : -- : x0 : -- : x1

    movq mm2,mm1
    pfsub mm1,mm3           //  x4 : x5 : x6 : x7 : x0 : -- : x1
    pfadd mm2,mm3           //  x4 : x5 : x6 : x7 : x0 : -- : x1
                            //  x4 : x5 : x6 : -- : x0 : -- : x1

//  tt = W6 * (x3 + x2);      //  x4 : x5 : x6 : x2 : x0 : tt : x1 : x3
//  x3 = tt + W2mW6 * x3;     //  x4 : x5 : x6 : x2 : x0 : tt : x1 : x3
//  x2 = tt - W2pW6 * x2;     //  x4 : x5 : x6 : -- : x0 : x2 : x1 : x3

    movq mm3,x2
    movq mm7,x3
    movq mm5,mm3
    pfadd mm5,mm7
    pfmul mm5,W6            //  x4 : x5 : x6 : x2 : x0 : tt : x1 : x3

    pfmul mm7,W2mW6
    pfmul mm3,W2pW6
    pfadd mm7,mm5           //  x4 : x5 : x6 : x2 : x0 : tt : x1 : x3
    pfsub mm5,mm3           //  x4 : x5 : x6 : -- : x0 : x2 : x1 : x3

//                            //  load B0+B4+x3 -> x7
//  x7 = x8 + x3;             //  x4 : x5 : x6 : x7 : x0 : x2 : x1 : x3

    movq mm3,x0
    pfadd mm3,x1
    pfadd mm3,mm7           //  x4 : x5 : x6 : x7 : x0 : x2 : x1 : x3

//  fblk[0+0] = x7 + x1;      //  x4 : x5 : x6 : F0 : x0 : x2 : x1 : x3
//  fblk[0+7] = x7 - x1;      //  x4 : x5 : x6 : F7 : x0 : x2 : x1 : x3
//                            //  x4 : x5 : x6 : -- : x0 : x2 : -- : x3

    pfadd mm3,mm6
    pfadd mm6,mm6
    movq F0,mm3             //  x4 : x5 : x6 : F0 : x0 : x2 : x1 : x3
    pfsub mm3,mm6
    movq F7,mm3             //  x4 : x5 : x6 : F7 : x0 : x2 : x1 : x3
                            //  x4 : x5 : x6 : -- : x0 : x2 : -- : x3

//                            //  load B0+B4-x3 -> x8
//  x8 = x8 - x3;             //  x4 : x5 : x6 : x8 : x0 : x2 : -- : x3
//                            //  x4 : x5 : x6 : x8 : x0 : x2 : -- : --

    movq mm3,x0
    pfadd mm3,x1            //  x4 : x5 : x6 : x8 : x0 : x2 : -- : x3
    pfsub mm3,mm7           //  x4 : x5 : x6 : x8 : x0 : x2 : -- : --

//                            //  x8+x6, x8-x6
//  fblk[8*3] = x8 + x6;      //  x4 : x5 : x6 : x8 : x0 : x2 : F3 : --
//  fblk[8*4] = x8 - x6;      //  x4 : x5 : x6 : x8 : x0 : x2 : -- : --
//                            //  x4 : x5 : -- : -- : x0 : x2 : -- : --

    movq mm6,mm3
    pfadd mm3,mm2
    pfsub mm6,mm2           //  x4 : x5 : x6 : x8 : x0 : x2 : F3 : --
    movq F3,mm3             //  x4 : x5 : x6 : x8 : x0 : x2 : -- : --
    movq F4,mm6             //  x4 : x5 : -- : -- : x0 : x2 : -- : --

//  x3 = x0 + x2;             //  x4 : x5 : x3 : -- : x0 : x2 : -- : --
//  x0 = x0 - x2;             //  x4 : x5 : x3 : -- : x0 : x2 : -- : --

    movq mm2,mm4
    pfsub mm4,mm5
    pfadd mm2,mm5           //  x4 : x5 : x3 : -- : x0 : x2 : -- : --

//  x2 = S2 * (x4 + x5);      //  x4 : x5 : x3 : x2 : x0 : -- : -- : --
//  x4 = S2 * (x4 - x5);      //  x4 : x5 : x3 : x2 : x0 : -- : -- : --

    movq mm3,mm0
    pfsub mm0,mm1
    pfadd mm3,mm1
    pfmul mm0,S2
    pfmul mm3,S2            //  x4 : x5 : x3 : x2 : x0 : -- : -- : --

//  fblk[8*1] = x3 + x2;      //  x4 : F1 : x3 : x2 : x0 : -- : -- : --
//  fblk[8*6] = x3 - x2;      //  x4 : F1 : x3 : x2 : x0 : -- : -- : --
//  fblk[8*2] = x0 + x4;      //  x4 : -- : -- : -- : x0 : F2 : -- : --
//  fblk[8*5] = x0 - x4;      //  x4 : -- : -- : -- : x0 : F2 : -- : --

    movq mm1,mm2
    movq mm5,mm4
    pfsub mm2,mm3
    pfsub mm4,mm0
    pfadd mm1,mm3
    pfadd mm5,mm0           //  x4 : F1 : F6 : x2 : F5 : F2 : -- : --
    movq F6,mm2
    movq F5,mm4
    movq F1,mm1
    movq F2,mm5             //  -- : -- : -- : -- : -- : -- : -- : --

//################################============================--------....

    #undef x0
    #undef x1
    #undef x2
    #undef x3
    #undef x4
    #undef x5
    #undef x6
    #undef x7
  
    #undef F0
    #undef F1
    #undef F2
    #undef F3
    #undef F4
    #undef F5
    #undef F6
    #undef F7

  }
}

void idctcol(float * F, short * B1, short * B2)
{

  __asm {

    mov esi,F
    mov edi,B1
    mov ebx,B2

    mov ecx,255
    mov edx,-256

    #define x0 [esi+8*0*8]
    #define x1 [esi+8*4*8]
    #define x2 [esi+8*6*8]
    #define x3 [esi+8*2*8]
    #define x4 [esi+8*1*8]
    #define x5 [esi+8*7*8]
    #define x6 [esi+8*5*8]
    #define x7 [esi+8*3*8]

    #define B0_0 [edi+8*0*2]
    #define B0_1 [edi+8*1*2]
    #define B0_2 [edi+8*2*2]
    #define B0_3 [edi+8*3*2]
    #define B0_4 [edi+8*4*2]
    #define B0_5 [edi+8*5*2]
    #define B0_6 [edi+8*6*2]
    #define B0_7 [edi+8*7*2]

    #define B1_0 [ebx+8*0*2]
    #define B1_1 [ebx+8*1*2]
    #define B1_2 [ebx+8*2*2]
    #define B1_3 [ebx+8*3*2]
    #define B1_4 [ebx+8*4*2]
    #define B1_5 [ebx+8*5*2]
    #define B1_6 [ebx+8*6*2]
    #define B1_7 [ebx+8*7*2]

#if 0
  mov eax,x1
  mov ecx,x1+4
  or eax,x2
  or ecx,x2+4
  or eax,x3
  or ecx,x3+4
  or eax,x4
  or ecx,x4+4
  or eax,x5
  or ecx,x5+4
  or eax,x6
  or ecx,x6+4
  or eax,x7
  or ecx,x7+4
  or eax,ecx
  cmp eax,0
  jnz __do_iDCT

  movq mm0,x0
  pfadd mm0,pointfive
  pf2id mm0,mm0
  movd eax,mm0
  pextrw ecx,mm0,2
  movsx ecx,cx
  mov B0_0,ax
  mov B1_0,cx
  mov B0_1,ax
  mov B1_1,cx
  mov B0_2,ax
  mov B1_2,cx
  mov B0_3,ax
  mov B1_3,cx
  mov B0_4,ax
  mov B1_4,cx
  mov B0_5,ax
  mov B1_5,cx
  mov B0_6,ax
  mov B1_6,cx
  mov B0_7,ax
  mov B1_7,cx

	pop	edi
	pop	esi
  pop ebx
	pop	ebp
  ret 0

__do_iDCT:
#endif

	movq mm0,x0
	movq mm1,x1
	pfmul mm0,oneovereight
	pfmul mm1,oneovereight
	movq x0,mm0
	movq x1,mm1

//################################============================--------....

  //  tt = W7 * (x4 + x5);      //  x4 : tt : x5
  //  x4 = tt + W1mW7 * x4;     //  x4 : tt : x5
  //  x5 = tt - W1pW7 * x5;     //  x4 : x5 : --

    movq mm0,x4
		pfmul mm0,oneovereight
    movq mm2,x5
		pfmul mm2,oneovereight
    movq mm1,mm0
    pfadd mm1,mm2
    pfmul mm1,W7            //  x4 : tt : x5
    pfmul mm0,W1mW7
    pfmul mm2,W1pW7
    pfadd mm0,mm1           //  x4 : tt : x5
    pfsub mm1,mm2           //  x4 : x5 : --

//  tt = W3 * (x6 + x7);      //  x4 : x5 : x6 : tt : x7
//  x6 = tt - W3mW5 * x6;     //  x4 : x5 : x6 : tt : x7
//  x7 = tt - W3pW5 * x7;     //  x4 : x5 : x6 : x7 : --

    movq mm2,x6
		pfmul mm2,oneovereight
    movq mm4,x7
		pfmul mm4,oneovereight
    movq mm3,mm2
    pfadd mm3,mm4
    pfmul mm3,W3            //  x4 : x5 : x6 : tt : x7
    pfmul mm2,W3mW5
    pfmul mm4,W3pW5
    pxor mm2,negation
    pfadd mm2,mm3           //  x4 : x5 : x6 : tt : x7
    pfsub mm3,mm4           //  x4 : x5 : x6 : x7 : --

////x8 = x0 + x1;             //  x4 : x5 : x6 : x7 : x0 : --
//  x0 = x0 - x1;             //  x4 : x5 : x6 : x7 : x0 : --

    movq mm4,x0
    pfsub mm4,x1            //  x4 : x5 : x6 : x7 : x0 : --

//  x1 = x4 + x6;             //  x4 : x5 : x6 : x7 : x0 : -- : x1
//  x4 = x4 - x6;             //  x4 : x5 : x6 : x7 : x0 : -- : x1

    movq mm6,mm0
    pfsub mm0,mm2           //  x4 : x5 : x6 : x7 : x0 : -- : x1
    pfadd mm6,mm2           //  x4 : x5 : x6 : x7 : x0 : -- : x1

//  x6 = x5 + x7;             //  x4 : x5 : x6 : x7 : x0 : -- : x1
//  x5 = x5 - x7;             //  x4 : x5 : x6 : x7 : x0 : -- : x1
//                            //  x4 : x5 : x6 : -- : x0 : -- : x1

    movq mm2,mm1
    pfsub mm1,mm3           //  x4 : x5 : x6 : x7 : x0 : -- : x1
    pfadd mm2,mm3           //  x4 : x5 : x6 : x7 : x0 : -- : x1
                            //  x4 : x5 : x6 : -- : x0 : -- : x1

//  tt = W6 * (x3 + x2);      //  x4 : x5 : x6 : x2 : x0 : tt : x1 : x3
//  x3 = tt + W2mW6 * x3;     //  x4 : x5 : x6 : x2 : x0 : tt : x1 : x3
//  x2 = tt - W2pW6 * x2;     //  x4 : x5 : x6 : -- : x0 : x2 : x1 : x3

    movq mm3,x2
		pfmul mm3,oneovereight
    movq mm7,x3
		pfmul mm7,oneovereight
    movq mm5,mm3
    pfadd mm5,mm7
    pfmul mm5,W6            //  x4 : x5 : x6 : x2 : x0 : tt : x1 : x3

    pfmul mm7,W2mW6
    pfmul mm3,W2pW6
    pfadd mm7,mm5           //  x4 : x5 : x6 : x2 : x0 : tt : x1 : x3
    pfsub mm5,mm3           //  x4 : x5 : x6 : -- : x0 : x2 : x1 : x3

//                            //  load B0+B4+x3 -> x7
//  x7 = x8 + x3;             //  x4 : x5 : x6 : x7 : x0 : x2 : x1 : x3

    movq mm3,x0
    pfadd mm3,x1
    pfadd mm3,mm7           //  x4 : x5 : x6 : x7 : x0 : x2 : x1 : x3

//  fblk[0+0] = x7 + x1;      //  x4 : x5 : x6 : F0 : x0 : x2 : x1 : x3
//  fblk[0+7] = x7 - x1;      //  x4 : x5 : x6 : F7 : x0 : x2 : x1 : x3
//                            //  x4 : x5 : x6 : -- : x0 : x2 : -- : x3

    pfadd mm3,mm6
    pfadd mm6,mm6

//    movq F0,mm3             //  x4 : x5 : x6 : F0 : x0 : x2 : x1 : x3
    movq tmp,mm6
//    pf2id mm6,mm3
     movq mm6,mm3
     pfadd mm6,pointfive
     pf2id mm6,mm6
    movd eax,mm6
    cmp eax,ecx
    cmovg eax,ecx
    cmp eax,edx
    cmovl eax,edx
    mov B0_0,ax
    pextrw eax,mm6,2
    movsx eax,ax
    cmp eax,ecx
    cmovg eax,ecx
    cmp eax,edx
    cmovl eax,edx
    mov B1_0,ax

    pfsub mm3,tmp

//    movq F7,mm3             //  x4 : x5 : x6 : F7 : x0 : x2 : x1 : x3

    pfadd mm3,pointfive
    pf2id mm3,mm3
    movd eax,mm3
    cmp eax,ecx
    cmovg eax,ecx
    cmp eax,edx
    cmovl eax,edx
    mov B0_7,ax
    pextrw eax,mm3,2
    movsx eax,ax
    cmp eax,ecx
    cmovg eax,ecx
    cmp eax,edx
    cmovl eax,edx
    mov B1_7,ax
                            //  x4 : x5 : x6 : -- : x0 : x2 : -- : x3

//                            //  load B0+B4-x3 -> x8
//  x8 = x8 - x3;             //  x4 : x5 : x6 : x8 : x0 : x2 : -- : x3
//                            //  x4 : x5 : x6 : x8 : x0 : x2 : -- : --

    movq mm3,x0
    pfadd mm3,x1            //  x4 : x5 : x6 : x8 : x0 : x2 : -- : x3
    pfsub mm3,mm7           //  x4 : x5 : x6 : x8 : x0 : x2 : -- : --

//                            //  x8+x6, x8-x6
//  fblk[8*3] = x8 + x6;      //  x4 : x5 : x6 : x8 : x0 : x2 : F3 : --
//  fblk[8*4] = x8 - x6;      //  x4 : x5 : x6 : x8 : x0 : x2 : -- : --
//                            //  x4 : x5 : -- : -- : x0 : x2 : -- : --

    movq mm6,mm3
    pfadd mm3,mm2
    pfsub mm6,mm2           //  x4 : x5 : x6 : x8 : x0 : x2 : F3 : --

//    movq F3,mm3             //  x4 : x5 : x6 : x8 : x0 : x2 : -- : --
//    movq F4,mm6             //  x4 : x5 : -- : -- : x0 : x2 : -- : --

    pfadd mm3,pointfive
    pf2id mm3,mm3
    pfadd mm6,pointfive
    pf2id mm6,mm6

    movd eax,mm3
    cmp eax,ecx
    cmovg eax,ecx
    cmp eax,edx
    cmovl eax,edx
    mov B0_3,ax
    pextrw eax,mm3,2
    movsx eax,ax
    cmp eax,ecx
    cmovg eax,ecx
    cmp eax,edx
    cmovl eax,edx
    mov B1_3,ax

    movd eax,mm6
    cmp eax,ecx
    cmovg eax,ecx
    cmp eax,edx
    cmovl eax,edx
    mov B0_4,ax
    pextrw eax,mm6,2
    movsx eax,ax
    cmp eax,ecx
    cmovg eax,ecx
    cmp eax,edx
    cmovl eax,edx
    mov B1_4,ax


//  x3 = x0 + x2;             //  x4 : x5 : x3 : -- : x0 : x2 : -- : --
//  x0 = x0 - x2;             //  x4 : x5 : x3 : -- : x0 : x2 : -- : --

    movq mm2,mm4
    pfsub mm4,mm5
    pfadd mm2,mm5           //  x4 : x5 : x3 : -- : x0 : x2 : -- : --

//  x2 = S2 * (x4 + x5);      //  x4 : x5 : x3 : x2 : x0 : -- : -- : --
//  x4 = S2 * (x4 - x5);      //  x4 : x5 : x3 : x2 : x0 : -- : -- : --

    movq mm3,mm0
    pfsub mm0,mm1
    pfadd mm3,mm1
    pfmul mm0,S2
    pfmul mm3,S2            //  x4 : x5 : x3 : x2 : x0 : -- : -- : --

//  fblk[8*1] = x3 + x2;      //  x4 : F1 : x3 : x2 : x0 : -- : -- : --
//  fblk[8*6] = x3 - x2;      //  x4 : F1 : x3 : x2 : x0 : -- : -- : --
//  fblk[8*2] = x0 + x4;      //  x4 : -- : -- : -- : x0 : F2 : -- : --
//  fblk[8*5] = x0 - x4;      //  x4 : -- : -- : -- : x0 : F2 : -- : --

    movq mm1,mm2
    movq mm5,mm4
    pfsub mm2,mm3
    pfsub mm4,mm0
    pfadd mm1,mm3
    pfadd mm5,mm0           //  x4 : F1 : F6 : x2 : F5 : F2 : -- : --
//    movq F6,mm2
//    movq F5,mm4
//    movq F1,mm1
//    movq F2,mm5             //  -- : -- : -- : -- : -- : -- : -- : --

    pfadd mm2,pointfive
    pfadd mm4,pointfive
    pfadd mm1,pointfive
    pfadd mm5,pointfive
    pf2id mm2,mm2
    pf2id mm4,mm4
    pf2id mm1,mm1
    pf2id mm5,mm5

    movd eax,mm2
    cmp eax,ecx
    cmovg eax,ecx
    cmp eax,edx
    cmovl eax,edx
    mov B0_6,ax
    pextrw eax,mm2,2
    movsx eax,ax
    cmp eax,ecx
    cmovg eax,ecx
    cmp eax,edx
    cmovl eax,edx
    mov B1_6,ax

    movd eax,mm4
    cmp eax,ecx
    cmovg eax,ecx
    cmp eax,edx
    cmovl eax,edx
    mov B0_5,ax
    pextrw eax,mm4,2
    movsx eax,ax
    cmp eax,ecx
    cmovg eax,ecx
    cmp eax,edx
    cmovl eax,edx
    mov B1_5,ax

    movd eax,mm1
    cmp eax,ecx
    cmovg eax,ecx
    cmp eax,edx
    cmovl eax,edx
    mov B0_1,ax
    pextrw eax,mm1,2
    movsx eax,ax
    cmp eax,ecx
    cmovg eax,ecx
    cmp eax,edx
    cmovl eax,edx
    mov B1_1,ax

    movd eax,mm5
    cmp eax,ecx
    cmovg eax,ecx
    cmp eax,edx
    cmovl eax,edx
    mov B0_2,ax
    pextrw eax,mm5,2
    movsx eax,ax
    cmp eax,ecx
    cmovg eax,ecx
    cmp eax,edx
    cmovl eax,edx
    mov B1_2,ax
                            //  -- : -- : -- : -- : -- : -- : -- : --


//################################============================--------....

    #undef x0
    #undef x1
    #undef x2
    #undef x3
    #undef x4
    #undef x5
    #undef x6
    #undef x7
  
    #undef B0_0
    #undef B0_1
    #undef B0_2
    #undef B0_3
    #undef B0_4
    #undef B0_5
    #undef B0_6
    #undef B0_7
  
    #undef B1_0
    #undef B1_1
    #undef B1_2
    #undef B1_3
    #undef B1_4
    #undef B1_5
    #undef B1_6
    #undef B1_7

  }
}

#if 0

  x0 = blk[8*0]; x1 = blk[8*4]; x2 = blk[8*6]; x3 = blk[8*2];
  x4 = blk[8*1]; x5 = blk[8*7]; x6 = blk[8*5]; x7 = blk[8*3];

  tt = W7 * (x4 + x5);      //  x4 : tt : x5
  x4 = tt + W1mW7 * x4;     //  x4 : tt : x5
  x5 = tt - W1pW7 * x5;     //  x4 : x5 : --

  tt = W3 * (x6 + x7);      //  x4 : x5 : x6 : tt : x7
  x6 = tt - W3mW5 * x6;     //  x4 : x5 : x6 : tt : x7
  x7 = tt - W3pW5 * x7;     //  x4 : x5 : x6 : x7 : --

//x8 = x0 + x1;             //  x4 : x5 : x6 : x7 : x0 : --
  x0 = x0 - x1;             //  x4 : x5 : x6 : x7 : x0 : --

  x1 = x4 + x6;             //  x4 : x5 : x6 : x7 : x0 : -- : x1
  x4 = x4 - x6;             //  x4 : x5 : x6 : x7 : x0 : -- : x1

  x6 = x5 + x7;             //  x4 : x5 : x6 : x7 : x0 : -- : x1
  x5 = x5 - x7;             //  x4 : x5 : x6 : x7 : x0 : -- : x1
                            //  x4 : x5 : x6 : -- : x0 : -- : x1

  tt = W6 * (x3 + x2);      //  x4 : x5 : x6 : x2 : x0 : tt : x1 : x3
  x3 = tt + W2mW6 * x3;     //  x4 : x5 : x6 : x2 : x0 : tt : x1 : x3
  x2 = tt - W2pW6 * x2;     //  x4 : x5 : x6 : -- : x0 : x2 : x1 : x3

                            //  load B0+B4+x3 -> x7
  x7 = x8 + x3;             //  x4 : x5 : x6 : x7 : x0 : x2 : x1 : x3

  fblk[8*0] = x7 + x1;      //  x4 : x5 : x6 : F0 : x0 : x2 : x1 : x3
  fblk[8*7] = x7 - x1;      //  x4 : x5 : x6 : F7 : x0 : x2 : x1 : x3
                            //  x4 : x5 : x6 : -- : x0 : x2 : -- : x3

                            //  load B0+B4-x3 -> x8
  x8 = x8 - x3;             //  x4 : x5 : x6 : x8 : x0 : x2 : -- : x3
                            //  x4 : x5 : x6 : x8 : x0 : x2 : -- : --

                            //  x8+x6, x8-x6
  fblk[8*3] = x8 + x6;      //  x4 : x5 : x6 : x8 : x0 : x2 : F3 : --
  fblk[8*4] = x8 - x6;      //  x4 : x5 : x6 : x8 : x0 : x2 : -- : --
                            //  x4 : x5 : -- : -- : x0 : x2 : -- : --

  x3 = x0 + x2;             //  x4 : x5 : x3 : -- : x0 : x2 : -- : --
  x0 = x0 - x2;             //  x4 : x5 : x3 : -- : x0 : x2 : -- : --

  x2 = S2 * (x4 + x5);      //  x4 : x5 : x3 : x2 : x0 : -- : -- : --
  x4 = S2 * (x4 - x5);      //  x4 : x5 : x3 : x2 : x0 : -- : -- : --
                            //  x4 : -- : x3 : x2 : x0 : -- : -- : --

  fblk[8*1] = x3 + x2;      //  x4 : F1 : x3 : x2 : x0 : -- : -- : --
  fblk[8*6] = x3 - x2;      //  x4 : F1 : x3 : x2 : x0 : -- : -- : --
  fblk[8*2] = x0 + x4;      //  x4 : -- : -- : -- : x0 : F2 : -- : --
  fblk[8*5] = x0 - x4;      //  x4 : -- : -- : -- : x0 : F2 : -- : --
                            //  -- : -- : -- : -- : -- : -- : -- : --

#endif

void Initialize_Reference_IDCT4()
{

  S2[0] = S2[1] = (float)sqrt(0.5);

  W1[0] = W1[1] = (float)(sqrt(2)*cos(pi*1/16));
  W2[0] = W2[1] = (float)(sqrt(2)*cos(pi*2/16));
  W3[0] = W3[1] = (float)(sqrt(2)*cos(pi*3/16));
  W5[0] = W5[1] = (float)(sqrt(2)*cos(pi*5/16));
  W6[0] = W6[1] = (float)(sqrt(2)*cos(pi*6/16));
  W7[0] = W7[1] = (float)(sqrt(2)*cos(pi*7/16));

  // vectorize constant multiplies

  W1mW7[0] = W1mW7[1] = W1[0]-W7[0];
  W1pW7[0] = W1pW7[1] = W1[0]+W7[0];
  W2mW6[0] = W2mW6[1] = W2[0]-W6[0];
  W2pW6[0] = W2pW6[1] = W2[0]+W6[0];
  W3mW5[0] = W3mW5[1] = W3[0]-W5[0];
  W3pW5[0] = W3pW5[1] = W3[0]+W5[0];

  block = 0; // hack for two block call
}
