/* 
 *  Plugins.cpp
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include <windows.h>
#include <stdio.h>
#include "plugins.h"
#include "FormatDefs.h"
#include "auxiliary.h"


char load_directory[MAX_PATH];




int FlPluginWrapper::SetSettings( ui8 *settings, ui32 settings_size )
{
  cfgblockinfo_s cfg;
  
  // Store whatever settings you may have
  if( settings_size && settings )
  {
    cfg.buf = settings;
    cfg.bufsize = settings_size;
    
    floutentry( flo_setinfo, flo_setblockinfo, (ui32)&cfg );
  }
  return settings_size;
}

int FlPluginWrapper::GetSettings( ui8 **settings, ui32 *settings_size )
{
  cfgblockinfo_s cfg;
  // Get Whatever settings you may have
  floutentry( flo_getinfo, flo_getblockinfo, (ui32)&cfg );
  if( cfg.buf && cfg.bufsize) {
    *settings = cfg.buf;
    *settings_size = cfg.bufsize;
  }
  else {
    *settings_size = 0;
  }
  return cfg.bufsize;
}


int SaveSettings(PBYTE settings, int settings_size, char *name){
  char szTemp[1024];
  char validname[1024];
  FILE *file;
  
  strcpy( validname, name );
  validateFileName( validname );
  
  strcpy(szTemp, load_directory);
  strcat(szTemp,"\\Settings" );
  //Creating settings folder
  CreateDirectory(szTemp, NULL);
  
  sprintf(szTemp, "%s\\%s.settings.flask", szTemp,validname);
  if(!(file=fopen(szTemp, "wb"))){
    //Ooops
    return 0;
  }
  else
  {
    int version = FLOUT_VER;
    fwrite( &version, 1, sizeof(int), file);
    fwrite( &settings_size, 1, sizeof (int), file);
    fwrite( settings, settings_size, 1, file);
    fclose(file);
    return 1;
  }
}

int FlushPluginSettings( TPlugins *plugs ){
  int i;
  ui8 *settings;
  ui32 settings_size;

  for(i=0; i<plugs->OutPluginCount; i++)
  {
    FlPluginWrapper *pw = &plugs->outPlugs[i].plug;

    if( pw->GetSettings( &settings, &settings_size ) )
      SaveSettings(settings, settings_size, plugs->outPlugs[i].ID);
  }
  return 0;
}

static int RetrieveSettings( TPlugins *plugs )
{
	char szTemp[1024], validname[1024];
	FILE *file;
  int settings_size, version, i;
  ui8 *settings;

  for(i=0; i<plugs->OutPluginCount; i++)
  {
    FlPluginWrapper *pw = &plugs->outPlugs[i].plug;

    strcpy( validname, plugs->outPlugs[i].ID );
    validateFileName( validname );

	  sprintf(szTemp, "%s\\Settings\\%s.settings.flask", load_directory, validname );

    if( file = fopen(szTemp, "rb") ) {

      fread( &version, 1, sizeof (int), file);

      if( version!=FLOUT_VER )
        continue;

      fread( &settings_size, 1, sizeof (int), file );
		  settings = (unsigned char *)malloc(settings_size);
		  fread( settings, settings_size, 1, file);
		  fclose(file);
      
      pw->SetSettings( settings, settings_size );

      free( settings );
	  }
  }
	return 1;
}

static int PluginStartup( TPlugins *plugs, char *filename ){

		HINSTANCE			hinstLib; 
    int nCount;
		int current = plugs->OutPluginCount;
    int currentmod = plugs->OutModCount;
		floutentry_ptr floutentry;
    floutentry_getids_ptr floutentry_getids;



		hinstLib = LoadLibrary(filename); 
		// If the handle is valid, try to get the function address.
		if (!hinstLib)
			return 0;

		plugs->outmod[currentmod].hInstLib = hinstLib;

    // Get the get ids function
    floutentry_getids = (floutentry_getids_ptr) GetProcAddress(hinstLib, "floutentry_getids");
    if(!floutentry_getids) {
			FreeLibrary(hinstLib);
			plugs->outmod[currentmod].hInstLib = NULL;
			return 0;
		}

    // Get the entry
		floutentry = (floutentry_ptr) GetProcAddress(hinstLib, "floutentry");
		if(!floutentry){
			FreeLibrary(hinstLib);
			plugs->outmod[currentmod].hInstLib = NULL;
			return 0;
		}

    // Get number of plugins available in this library
    flohandle_t *pHandles;
    nCount = floutentry_getids( &pHandles );
    if(!nCount) {
			FreeLibrary(hinstLib);
			plugs->outmod[currentmod].hInstLib = NULL;
			return 0;
		}

    for( int i=0; i<nCount; i++ )
    {
      startup_s st;

      plugs->outPlugs[current].plug.Set( pHandles[i], floutentry );

      if( floutentry( pHandles[i], flo_startup, (ui32)&st, 0)!=flo_ok){
		       // Free the DLL module.
			  FreeLibrary(hinstLib);
			  plugs->outmod[currentmod].hInstLib = NULL;
			  return 0;
		  }

      plugs->outPlugs[current].plug.SetStartup( &st );
      plugs->outPlugs[current].fileType   = st.moduleid;
		  strcpy( plugs->outPlugs[current].ID , st.modulename );


      // Supported formats
      videoinfo_s vi;

      floutentry( pHandles[i], flo_getinfo, flo_getvideoinfo, (ui32)&vi );

      long nSupported=0;

      nSupported |= vi.supported_fmt & FLO_VIDEO_RGB32 ? FRAME_RGB32 : 0;
      nSupported |= vi.supported_fmt & FLO_VIDEO_YUY2  ? FRAME_YUY2  : 0;
      nSupported |= vi.supported_fmt & FLO_VIDEO_YV12  ? FRAME_YV12  : 0;

      plugs->outPlugs[current].nSupportedFormats = nSupported;

      plugs->OutPluginCount++;
      current++;
    }

    plugs->OutModCount++;

		return plugs->OutPluginCount;
}

int LoadPlugins( TPlugins *plugs, char *program_directory )
{
	WIN32_FIND_DATA find_data;
	char            directory[MAX_PATH];
	HANDLE          search_handle;
	int i;
	int loaded_ok=0;

    if(!program_directory)
        return 0;

  plugs->OutPluginCount = 0;
  plugs->OutModCount = 0;

	// StartUp stuff
	for(i=0; i<MAX_OUT_PLUGINS; i++)
	{
		plugs->outmod[i].hInstLib = NULL;
	}
	
	// try flaskmpegpeasopeich.dll for compatibility
	if(PluginStartup( plugs,  "flaskmpegpeasopeich.dll" ))
			loaded_ok++;

	strcpy( load_directory, program_directory);	
	sprintf(directory, "%s\\*.cm.flask", load_directory);

	i=0;
	search_handle = FindFirstFile(directory, &find_data);
	if(search_handle==INVALID_HANDLE_VALUE){
		return loaded_ok;
	}
	else{
		if(PluginStartup( plugs,  find_data.cFileName ))
			loaded_ok++;

		while( FindNextFile(search_handle, &find_data ) ){
			if(PluginStartup( plugs,  find_data.cFileName ))
				loaded_ok++;
		}
		FindClose(search_handle);
	}

  // Finally load the settings
  RetrieveSettings( plugs );
	return loaded_ok;
}

int ClosePlugins(TPlugins *plugs)
{
	int i;

  FlushPluginSettings(plugs);

  // ShutDown first
	for(i=0; i<plugs->OutPluginCount; i++)
    plugs->outPlugs[i].plug.floutentry(flo_shutdown ,0,0);


  for(i=0; i<plugs->OutModCount; i++)
	{
    if( plugs->outPlugs[i].hinstLib )
    {
		  FreeLibrary(plugs->outPlugs[i].hinstLib);
      plugs->outPlugs[i].hinstLib = 0;
    }
	}
	return 0;
}