/* 
 *  Player.h
 *
 *	Copyright (C) Alberto Vigata - July 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#include "flasktypes.h"
#include "thread.h"
#include ".\video\videowrapper.h"
#include "MasterClock.h"
#include "PostProcessing.h"
#include "flvideosink.h"


#ifndef PLAYERTHREAD_H
#define PLAYERTHREAD_H

// Create worker thread for the player
class CPlayerThread : public CFlThread
{
public:
    //Constructor
    CPlayerThread::CPlayerThread( VideoWrapper *pVideoDecoder, HANDLE hMainWnd, CMasterClock *pMasterClock,
                                  TPPost *ppinit, int idctindex,  bool reconsprogressive, FlVideoSink *pVidSink =NULL)
    {
      m_pMasterClock = pMasterClock;
      m_pVideoDecoder = pVideoDecoder;
      m_hMainWnd = hMainWnd;
      m_lPlayFrameCount = 0;
      m_pp = *ppinit;
      m_pVidSink = pVidSink;
      m_nIdctIndex = idctindex;
      m_bReconsProgressive = reconsprogressive;
      ScheduleCommand(seekBeginning);
    };

    void Seek(ui64 nSeekPos)
    {
      SendCommand(seek, nSeekPos);
    }

    void SeekKeyFrame(ui64 nSeekPos)
    {
      SignalCommand(seekKeyFrame, nSeekPos);
    }
    void SeekBeginning()
    {
      ScheduleCommand(seekBeginning);
    }
    void SeekEnd()
    {
      ScheduleCommand(seekEnd);
    }
    void NextFrame()
    {
      SignalCommand(nextFrame);
    }
    void PrevFrame()
    {
      SignalCommand(prevFrame);
    }
    void NextKeyFrame()
    {
      ScheduleCommand(nextKeyFrame);
    }
    void PrevKeyFrame()
    {
      ScheduleCommand(prevKeyFrame);
    }
    void FastForward()
    {
      ScheduleCommand(fastForward);
    }    
    void FastRewind()
    {
      ScheduleCommand(fastRewind);
    }    
    void Play()
    {
      ScheduleCommand(play);
    }    
    void PlayBack()
    {
      ScheduleCommand(playBack);
    }

    void Stop()
    {
      ScheduleCommand(stop);
    }

    ui64 GetFrameStartPos()
    {
      return SendCommand(getFrameStartPos);
    }

    enum playerStates 
    {
      stStopped, stPlaying, stPlayingBack, stNextFrame, stPrevFrame, stNextKeyFrame,
        stPrevKeyFrame, stFastForward, stFastRewind
    };
    
    playerStates GetState(){return m_nState;}
    LONG GetPlayFrameCount(){ return m_lPlayFrameCount; }

    void SetPPSettings( TPPost *pp )
    {
      SendCommand( ppChange, (ui64)pp );
    }

private: 

    enum playerCommands
    {
        seek = THREAD_COMMAND_COUNT, seekKeyFrame, seekBeginning, seekEnd, nextFrame,
        prevFrame, nextKeyFrame, prevKeyFrame, 
        fastForward, fastRewind, getFrameStartPos ,play, playBack, stop, ppChange
    };
    HANDLE m_hMainWnd;

    // Actual running thread
    DWORD ThreadProc();
    VideoWrapper  *m_pVideoDecoder;
    playerStates   m_nState;
    LONG           m_lPlayFrameCount;
    CMasterClock  *m_pMasterClock;
    TPPost         m_pp;
    ui32           m_nIdctIndex;
    bool           m_bReconsProgressive;

    FlVideoSink   *m_pVidSink;


};

#endif