/* 
 *  mism.cpp 
 *
 *	Copyright (C) Alberto Vigata - December 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#ifndef MISM_H
#define MISM_H

#include "mismapi.h"

#define MismIsAc3Track(streamId, subStreamId) ( (subStreamId>= 0x80 && subStreamId <= 0x87 && streamId==0xBD) )
#define MismIsMpegTrack(streamId, subStreamId ) ((streamId >= 0xC0) && (streamId <= 0xDF)) 

#define MismIsAudioTrack(streamId, subStreamId) ( MismIsAc3Track(streamId, subStreamId) || \
                                                  MismIsMpegTrack(streamId, subStreamId) )

typedef struct TExtraInfo_Tag
{
  unsigned char (* clut)[16][4];
}TExtraInfo;

typedef struct
{
  fmHandle      handle;     // Handle to the stream that we are working with
  LPFMMismInfo  pMismInfo;  // MismInfo structure that defines the Mism
} TWorkingMism, *LPTWorkingMism;

bool StartMism();
bool StopMism();

// Helpers
bool GetFirstVideoId( fmStreamIds *streamIds , fmStreamId *Id);
bool GetFirstAudioId( fmStreamIds *streamIds, fmStreamId *Id, int *nIdx);
bool GetFirstSubpicId( fmStreamIds *streamIds, fmStreamId *Id);
bool MismIsAudioId(fmStreamId *Id);

#endif