/* 
 *  mism.cpp 
 *
 *	Copyright (C) Alberto Vigata - December 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#include "RunState.h"
#include "mism.h"
extern TConfig   o;
extern TRunState rs;
extern HWND hMainWnd;
extern void EnableMenu();
extern void DisableMenu();

extern HINSTANCE hInst;
extern char          program_directory[MAX_PATH];

typedef CArr<char> myString;

static CArr<HINSTANCE>    vhModule;

char *GetString(int x)
{ 
  return GS(x); 
}


static HINSTANCE LoadMismModule( char *szTemp, LPFMMismInfo mismInfo )
{
  fmGetMismPtr          fmGetMism;
  HINSTANCE hModule;

  if( hModule = LoadLibrary( szTemp ) )
  { 
    if( fmGetMism = (fmGetMismPtr)GetProcAddress( hModule, "fmGetMism" ) )
    { 
          fmGetMism( mismInfo );
         
          if( mismInfo->dwVersion != FM_MISM_VERSION ) {
            FreeLibrary( hModule );
            return NULL;
          }
          // Initialize Mism
          FMMismStdParms params;
          params.GetString = GetString;
          params.hInst     = hInst;
          params.hWnd      = hMainWnd;
          params.lurkSize  = rs.conf.lurk_size;
          mismInfo->Init( &params );
          return hModule;
    }
  }
  return NULL;
}


bool StartMism()
{
  WIN32_FIND_DATA find_data;
  char     directory[MAX_PATH];
  myString strTemp;
  // initialize strTemp
  strTemp.SetArraySize( MAX_PATH );

  HINSTANCE hModule; 
  HANDLE   search_handle;
  int      i;
  FMMismInfo mismInfo;

  
  sprintf(directory, "%s\\*.mism.flask", program_directory );
  
  rs.AvalInputs.EmptyArray();

  vhModule.EmptyArray();

 
  i=0;
  search_handle = FindFirstFile(directory, &find_data);
  if(search_handle==INVALID_HANDLE_VALUE){
    rs.AvalInputs.EmptyArray();
  }
  else{
    sprintf(strTemp.GetData(),"%s\\%s", program_directory, find_data.cFileName );
    if( hModule = LoadMismModule( strTemp.GetData(), &mismInfo ) )
    {
      // Store module instance
      vhModule.AddItem( &hModule );
      // Store mism info
      rs.AvalInputs.AddItem( &mismInfo );
    }
    while( FindNextFile(search_handle, &find_data ) ){
      sprintf(strTemp.GetData(),"%s\\%s", program_directory, find_data.cFileName );
    if( hModule = LoadMismModule( strTemp.GetData(), &mismInfo ) )
    {
      // Store module instance
      vhModule.AddItem( &hModule );
      // Store mism info
      rs.AvalInputs.AddItem( &mismInfo );
    }
    }
    FindClose(search_handle);
  }
  return rs.AvalInputs.GetCount() > 0;
}

bool StopMism()
{
  // Deinitialize Misms
  for(int i=0; i<rs.AvalInputs.GetCount(); i++)
    rs.AvalInputs[i].DeInit();

  // Deinitialize Libraries
  for(i=0; i<vhModule.GetCount(); i++)
    FreeLibrary( vhModule[i] );

  return true;
}

// Helper functions
bool GetFirstVideoId( fmStreamIds *streamIds , fmStreamId *Id)
{
  for( int i=0; i<streamIds->idCount; i++ )
  {
    if(streamIds->vIds[i].streamId>= 0xE0 && streamIds->vIds[i].streamId <= 0xEF)
    {
      *Id = streamIds->vIds[i];
      return true;
    }
  }
  return false;
}

bool GetFirstAudioId( fmStreamIds *streamIds, fmStreamId *Id, int *nIdx)
{
  for( int i=0; i<streamIds->idCount; i++ )
  {
    if(streamIds->vIds[i].streamId>= 0xC0 && streamIds->vIds[i].streamId <= 0xDF)
    {
      *Id = streamIds->vIds[i];
      *nIdx  = i;
      return true;
    }
    if(streamIds->vIds[i].streamId== 0xBD)
    {
      if( streamIds->vIds[i].subStreamId >= 0x80 && streamIds->vIds[i].subStreamId  <= 0x87 )
      {
        *Id = streamIds->vIds[i];
        *nIdx  = i;
        return true;
      }
    }
  }
  return false;
}

bool GetFirstSubpicId( fmStreamIds *streamIds, fmStreamId *Id)
{
  for( int i=0; i<streamIds->idCount; i++ )
  {
    if(streamIds->vIds[i].streamId== 0xBD)
    {
      if( streamIds->vIds[i].subStreamId >= 0x20 && streamIds->vIds[i].subStreamId  <= 0x2F )
      {
        *Id = streamIds->vIds[i];
        return true;
      }
    }
  }
  return false;
}

bool MismIsAudioId(fmStreamId *Id)
{
  if(!Id)
    return false;
  return MismIsAudioTrack(Id->streamId, Id->subStreamId);
}

