/* 
 *  flletterboxpad.cpp
 *
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include "flletterboxpad.h"
#include "debug.h"
 

#define AREA_SIDE 20


FlLetterboxPad::FlLetterboxPad()
{
  m_clx = m_cly = 0;
  m_bLocked = false;
  m_nLockedType = 0;
}

bool FlLetterboxPad::SetConfig( int nWidth, int nHeight, TLetterboxConfig *cfg )
{
  m_nWidth = nWidth;
  m_nHeight = nHeight;
  m_cfg = *cfg;
  BuildAreas();
  return true;
}


bool FlLetterboxPad::OnDrag( int x, int y )
{
  bool res = false;
  
  if( m_bLocked )
    res = Notify( x, y, m_nLockedType );

  return res;
}

bool FlLetterboxPad::OnHover( int x, int y, LPCTSTR &mousetype)
{
  for( int i=0; i<4; i++ ) {
    if( m_vAreas[i].Poll( x, y ) ) {
      int type = m_bLocked ? m_nLockedType : m_vAreas[i].GetType();
      switch( type )
      {
        case top:
        case bottom:
          mousetype = IDC_SIZENS;
          break;
        case left:
        case right:
          mousetype = IDC_SIZEWE;
          break;
      }
      return true;
    }
  }
  return false;
}


bool FlLetterboxPad::BuildAreas()
{ 
  int w = m_nWidth;
  int h = m_nHeight;

  int b = m_cfg.bottom;
  int l = m_cfg.left;
  int r = m_cfg.right;
  int t = m_cfg.top;

  // left, right, top, bottom
  m_vAreas[0].Set( l, h/2, AREA_SIDE, h, left );
  m_vAreas[1].Set( w - r, h/2, AREA_SIDE, h, right );
  m_vAreas[2].Set( w/2, t, w, AREA_SIDE, top );
  m_vAreas[3].Set( w/2, h - b, w, AREA_SIDE, bottom );

  return true;
}

int FlLetterboxPad::SnapCoordinate( int c, int oldc )
{
  return c/2*2;
}

bool FlLetterboxPad::OnClick( int x, int y )
{
  bool bSuccess = false;
  m_clx = x;
  m_cly = y;
  for( int i=0; i<4; i++ ) {
    if( m_vAreas[i].Poll( x, y ) ) {
      m_bLocked = true;
      m_nLockedType = m_vAreas[i].GetType();
      bSuccess = true;
    }
  }
  return bSuccess;
}

bool FlLetterboxPad::OnRelease()
{
  m_bLocked = false;
  return true;
}

bool FlLetterboxPad::Notify( int x, int y, int nType )
{
  int w = m_nWidth;
  int h = m_nHeight;

  TLetterboxConfig cfg;

  // clip x, y first
  //x = x<0 ? 0 : x>w ? w : x;
  //y = y<0 ? 0 : y>h ? h : y;

  cfg = m_cfg;
  switch( nType )
  {
    case top:
      cfg.top = SnapCoordinate(y, cfg.top);
      break;
    case left:
      cfg.left = SnapCoordinate(x, cfg.left);
      break;
    case right:
      cfg.right = SnapCoordinate(w - x, cfg.right);
      break;
    case bottom:
      cfg.bottom = SnapCoordinate(h - y, cfg.bottom);
      break;
  }

  FlLetterbox oLetterbox;

  oLetterbox.Configure( &cfg, sizeof (TLetterboxConfig) );

  flfilter_conf fc;
  memset( &fc, 0, sizeof flfilter_conf );
  fc.iw = w;
  fc.ih = h;

  // Validate configuration
  if( oLetterbox.ValFilterConf(&fc) ) 
  {
    // if nothing to do
    if( memcmp(&cfg, &m_cfg, sizeof TLetterboxConfig)==0 )
      return false;

    m_cfg = cfg;
    BuildAreas();
    return true;
  }
  return false;
}