/* 
 *  flfiltersimple.h   
 *           
 *
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#ifndef FLFILTERSIMPLE_H
#define FLFILTERSIMPLE_H

#include "FlFilter.h"

class FlFilterSimple : public FlFilter
{
public:
  int Start();
  int Stop();
  int Process( CFrame *out );

  virtual int StartSimple() = 0;
  virtual int ProcessSimple(CFrame *in, CFrame *out) = 0;
  virtual int StopSimple() = 0;

  // The output is always provided for us
  bool GetFrame(CFrame **ppFrame){ return Process(*ppFrame)==flfil_ok; }

protected:
  CFrame *m_pIn;
  flfilter_conf m_fc;
  bool m_bConfigured;
};



#endif