/* 
 *  flfiltersimple.cpp 
 *                                     
 *
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#include "Debug.h"
#include "flfiltersimple.h"



int FlFilterSimple::Start()
{
  // if the input is not provided
  // and we are not an on-place filter we'll provide one
  // if we are an on-place filter
  // the output will be our provided input  
  if(!m_fc.iprovided && !m_fc.op )
  {
    m_pIn = new CFrame;
    m_pIn->Set( m_fc.iw, m_fc.ih, m_fc.iformat );
  }

  return StartSimple();
}

int FlFilterSimple::Process( CFrame *out )
{
  CFrame *pIn, *pOut = out;

  if(m_fc.iprovided)
  {
    m_fc.input->GetFrame( &pIn );

    // if on-place operation setup pointers
    if( m_fc.op )
    {
      pOut->SetFrame( pIn );
      pIn = pOut;
      pOut = NULL;
    }
  }
  else // !m_fc.iprovided
  {
    if( !m_fc.op )
    {
      m_fc.input->GetFrame( &m_pIn );
      pIn = m_pIn;      
    }
    else // m_fc.op
    {
      // We are on-place and we provide the input
      // use the provided source as input
      // and then write on it
      m_fc.input->GetFrame( &pOut );
      pIn = pOut;
      pOut = NULL;      
    }
  }

  if( pOut ) {
    pOut->SetDuration( pIn->GetDuration() );
    pOut->SetFlags( pIn->GetFlags() );
  }

  return ProcessSimple( pIn, pOut );
}

int FlFilterSimple::Stop()
{
  // if the input is not provided we'll have to provide one
  if(!m_fc.iprovided && !m_fc.op)
  {
    if( m_pIn )
      delete m_pIn;
    m_pIn = NULL;
  }
  return StopSimple();
}