/* 
 *  flfiltergraph.h   
 *                    
 *
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#ifndef FLFILTERCHAIN_H
#define FLFILTERCHAIN_H

#include "flfilter.h"

static const int nMaxFilters = 32;


typedef struct
{
  FlFilter *filters[nMaxFilters];
  int       filtercnt;
} TFilterChainCfg;

class FlFilterChain : public FlFilter
{
public:
  FlFilterChain();
  int Start();
  int Configure( void *conf, int confsize);
  int GetConf( flfilter_conf *fc );
  int Validate( flfilter_conf *fc );
  int Process(CFrame *in, CFrame *out);
  int Stop();

private:

  flfilter_conf m_fc;
  bool m_bConfigured;
  CFrame *m_fr[nMaxFilters];     // intermediare buffers allocated on Start
  FlFilter *m_fil[nMaxFilters];  // filters
  bool      m_bOnPlace[nMaxFilters];
  int m_frc;       // number of intermediary buffers
  int m_filc;       // number of filters in the graph
};

#endif