/* 
 *  fldatasource.h   
 *                    
 *
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#ifndef FLDATASOURCE_H
#define FLDATASOURCE_H


typedef struct
{
  CFrameSource *input; // [in] input frame source
  int iformat;     // [in]   input format
  int iw, ih;      // [in]   input  width and height
  int id;          // [in]  frame delay as input
  int icanmodify;  // [in] specifies if the input can be modified on place
  int iprovided;   // [in] the input buffer is provided if set
  
  int ow, oh;      // [out]  output width and height
  int od;          // [out]  output frame delay
  int ocanmodify;  // [out] the output can be modified on place
  int oprovided;   // [out] the output buffer is provided if set

  int olag;        // [out]  specifies the lag of frames for this filter
  int op;          // [out] this filter perfomrs on place processing  
  
}flfilter_conf;

typedef enum
{
  flfil_error =0,
  flfil_ok
};

// USAGE
//
// 1.- You call Configure() on the filter to set
//     any filter specific settings
//
// 2.- You call Query() to know how the output will
//     affected. The filter then stores input info
//
// 3.- You Start() - Process() - Stop()

class FlFilter : public CFrameSource
{
public:
  // Starts the filter
  virtual int Start() =0;
  // Configures the filter with given information. 
  // conf points to filter dependant structure
  virtual int Configure( void *conf, int confsize ) =0;
  // Gets the current filter configuration
  virtual int GetFilterConf( flfilter_conf *fc ) =0;
  // Validate output parameters from given input pars
  virtual int ValFilterConf( flfilter_conf *fc ) =0;
  // processes a frame
  virtual int Process(CFrame *out) =0;
  // stops the filter
  virtual int Stop() =0;
};

#endif