/* 
 *  flcroppad.h
 *
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

 
#ifndef FLCROPPAD_H
#define FLCROPPAD_H

#include "flarea.h"
#include "crop.h"

class FlCropPad
{
public:

  // area types
  enum {
    topleft, top, topright,
    left, center, right,
    bottomleft, bottom, bottomright
  };

  FlCropPad();
  bool SetConfig( int nWidth, int nHeight, TCropConfig *cfg );
  TCropConfig *GetConfig(){ return &m_cfg; }
  bool OnDrag( int x, int y );
  bool OnHover( int x, int y, LPCTSTR &mousetype);
  bool OnClick( int x, int y );
  bool OnRelease();

private:
  bool BuildAreas();
  bool Notify( int x, int y, int nType );
  int SnapCoordinate( int c, int oldc );

  bool m_bLocked; // area locked
  int m_nLockedType; // locked type
  int m_clx,m_cly; // clicked point
  FlArea m_vAreas[9];
  int m_nWidth, m_nHeight;
  TCropConfig m_cfg;
};


#endif