/* 
 *  flarea.h    -  Controls FlasKMPEG options
 *
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

 
#ifndef FLAREA_H
#define FLAREA_H

#include <windows.h>

// Class to control user mouse actions
class FlArea
{
public:
  /* Sets the area at point x,y with dimensions w, h */
  bool Set(int x, int y, int w, int h, int nType)
  {
    #define clip(x) ((x)<0 ? 0 : (x))
  
    w = clip(w);
    h = clip(h);

    m_area.left  = clip(x - (w>>1));
    m_area.right = clip(x + (w>>1));
    m_area.top   = clip(y - (h>>1));
    m_area.bottom = clip(y + (h>>1));
    m_nType = nType;
    return true;
  }

  bool Poll(int x, int y)
  {
    bool ret;

    ret = ( x>m_area.left && x<m_area.right &&
            y>m_area.top  && y<m_area.bottom );

    return ret;
  }

  int GetType(){ return m_nType; }
private:
  RECT m_area;
  int m_nType;
  int m_nState;
};





#endif