/* 
 *  error.cpp
 *
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include "windows.h"
#include "error.h"
#include "flaskmpeg.h"
#include "runstate.h"

extern TRunState rs;

int Critical(char * str)
{
  if (!str)
    MessageBox(NULL, "Unknow error. FlasKMPEG will be closed.", "FlasKMPEG Critical Error",MB_ICONEXCLAMATION);
  else
    MessageBox(NULL, str,"FlasKMPEG Critical Error",MB_ICONEXCLAMATION);
		
  exit(0);
  
  return 0;
  
}

int MyError(char * str)
{
  if (!str)
    MessageBox(NULL, "Unknow error.", "FlasKMPEG Error",MB_ICONINFORMATION);
  else
    MessageBox(NULL, str,"FlasKMPEG Error",MB_ICONINFORMATION);
  
  return 0;
		
}

void PrintError(int code,int par1,int par2){
	if(code <1000)
		MessageBox((HWND)par1, GS(code), GS(WARNING), MB_OK);

}

void DebugPrint(char *str, int level){
	OutputDebugString(str);
	return;
}
void DebugSetLevel(int level){
	return;
}