/* 
 *  Player.h
 *
 *	Copyright (C) Alberto Vigata - July 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#ifndef AUDIOPROPERTIES_H
#define AUDIOPROPERTIES_H

#include "FlasKMPEG.h"
#include "thread.h"
#include ".\audio\audio.h"
#include "MasterClock.h"


// Create worker thread for the player
class CAudioThread : public CFlThread
{
public:
  //Constructor
  CAudioThread::CAudioThread( CMasterClock *pMasterClock ){
    m_pMasterClock = pMasterClock;
    m_nMaxSample = 0;
    m_tkSensThreshold = 5000;
  };
  
  void Normalize()
  {
    SendCommand(normalize, 0);
  }
  void Seek(ui64 nSeekPos)
  {
    SendCommand(seek, nSeekPos);
  }
  void Play()
  {
    SendCommand(play, 0);
  }
  void TrackChange(TAudioTrack *pTrack)
  {
    SendCommand(trackChange, (ui64)pTrack);
  }
  void Stop()
  {
    SendCommand(stop, 0);
  }
  ui32 GetState(){ return m_nState; }
  ui32 GetNormalizeValue()
  {
    if( m_nMaxSample==0 )
      return 100;
    
    ui32 ret = (32767*100)/m_nMaxSample;
    // If we get a 100% of normalization value
    // we're finished
    if(ret<=100)
      SendCommand(stop, 0);
    return ret;
  }
  ui16 FindMax(i16 *data, int nDataSize)
  {
    i16 mono;
    ui32 nSamples = nDataSize>>2;
    ui16 max=0;
    for(int i=0; i<nSamples; i++)
    {
      mono = (data[2*i] + data[2*i+1])/2;
      if( ABS(mono) >= max )
        max = ABS(mono);
    }
    return max;
  }
  enum Commands { seek=THREAD_COMMAND_COUNT, play, stop, normalize, trackChange};
  enum State { stStopped=0, stPlaying, stNormalizing };
private:
  CMasterClock  *m_pMasterClock;
  ui16 m_nMaxSample;
  State m_nState;
  mmtick m_tkSensThreshold;

  // Actual running thread
  DWORD ThreadProc();
  
  
};

void ShowAudioPanel(CAudioThread *pAudioThread);
void CloseAudioPanel();

#endif