// VideoSource.h: interface for the CVideoSource class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_VIDEOSOURCE_H__31E17FD4_34FF_427F_B557_097F07BDAC72__INCLUDED_)
#define AFX_VIDEOSOURCE_H__31E17FD4_34FF_427F_B557_097F07BDAC72__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "thread.h"
#include "flasktypes.h"
#include "framesource.h"
#include "framebuffer.h"
#include "postprocessing.h"
#include <list>


using namespace std;




// Return values
#define FRAME_OK         0x01
#define FRAME_NOTPRESENT 0x10

class CVideoSource: public CFlThread
{
public:
  CVideoSource();

  virtual ~CVideoSource()
  { 
    Stop();
  }

  bool Start( CFrameSource *pSource, TPPost *pp );
  bool Stop();

  ui32 GetWidth(){ return m_nWidth; }
  ui32 GetHeight(){ return m_nHeight; }
  ui32 GetFrame(CFrame **ppFrame);


private:

  enum Commands
  {
      getFrame=THREAD_COMMAND_COUNT
  };
  enum States 
  {
      stStopped=0, stGetFrame
  };
  // Actual running thread
  DWORD ThreadProc();

  CListFrameBuffer   *m_pProcessedQueue;
  CQueueFrameBuffer  *m_pOutputQueue;

  States           m_nState;
  CFlEvent         m_evProcessedQueueSignal;
  
  CFrameSource *m_pFrameSource;

  CFlCritSec m_csCommand;
  CFlCritSec m_csObject;

  FlPostProcess m_pp; // post processing object

  ui32 m_nWidth, m_nHeight;

};


#endif // !defined(AFX_VIDEOSOURCE_H__31E17FD4_34FF_427F_B557_097F07BDAC72__INCLUDED_)
