/* 
 *  VideoRenderer.h 
 *
 *	Copyright (C) Alberto Vigata - July 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#if !defined(AFX_VIDEORENDERER_H__76B3ADF0_38CE_4243_890F_89B05B944B77__INCLUDED_)
#define AFX_VIDEORENDERER_H__76B3ADF0_38CE_4243_890F_89B05B944B77__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <windows.h>
#include "thread.h"
#include "framesource.h"


#include "ddraw.h"

#define SafeRelease(x) { (x)->Release(); (x)=NULL; }
#define MASKCOLOR			RGB(16, 0, 16) // Color for the overlay

#define VR_WAITFORLOCK 1

class CVideoRenderer  
{
public:
  CVideoRenderer(HWND hRenderWnd, bool bFixedFormat, 
                                  int nFixedFormat ); // bFixedFormat forces the 
                                                      //  renderer to render video always in the same format nFixedFormat

  virtual ~CVideoRenderer();
  void Draw(CFrame *pFrame, int flags = VR_WAITFORLOCK );
  void Update();
  void UpdateOverlay();
  ui32 GetFormat(){return m_nCurrentFormat;}
  void SetStaticFrame(CFrame *pFrame);
  void StartPlaying(){ m_nState = Playing; }
  void StopPlaying(){ m_nState = Stopped; }

  bool CVideoRenderer::SetOverlay(int nWidth, int nHeight, long StoreFormat);

  enum OverlayMode { YuvMode=0, RgbMode };
  enum RendererState { Stopped=0,  Playing };
private:
  // DirectDraw support
  // Try to open direct draw driver
  bool OpenDirectDraw();
  void CloseDirectDraw();

  bool GetInfoOverlay(DWORD * FccCodes, DDCAPS * Caps);

  bool OpenOverlay(long StoreFormat,int nWidth, int nHeight);

  void CloseOverlay();
  void PaintKey();

  DWORD DDColorMatch(LPDIRECTDRAWSURFACE pdds, COLORREF rgb);

  // 
  bool m_bDDrawPresent;
  bool m_bDDCanUseYuvOverlay;
  bool m_bDDCanUseRgbOverlay;

  // DirectDraw structures
  LPDIRECTDRAW        m_pDD;	
  LPDIRECTDRAW2		    m_pDD2;
  LPDIRECTDRAWSURFACE m_pDDSPrimary;  
  LPDIRECTDRAWSURFACE m_pDDSOverlay;  
  DDOVERLAYFX         m_OverlayFX;         
  DDCAPS              m_ddcaps;
  DDSURFACEDESC       m_ddsd;

  bool m_bOverlayFlag;
  bool m_bDirectDrawFlag;


  CFrame m_oStaticFrame;
  CFrame m_oRgbFrame;   // Used when color space conversion is needed
  HWND m_hRenderWnd;

  DWORD m_nWidth;
  DWORD m_nHeight;
  // Background
  double fTime;
  double fPhase1, fPhase2;

  RendererState m_nState;

  int m_nCurrentFormat;

  bool m_bFixedFormat;

  CFlCritSec m_csDirectDraw;
//  IID_IDirectDraw2 *pDD2;

};


#endif // !defined(AFX_VIDEORENDERER_H__76B3ADF0_38CE_4243_890F_89B05B944B77__INCLUDED_)
