/* 
 *  ProgressGraph.h
 *
 *	Copyright (C) Alberto Vigata - July 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#if !defined(AFX_PROGRESSGRAPH_H__CE1DE857_B8E5_42E0_9B32_73FF8714CD66__INCLUDED_)
#define AFX_PROGRESSGRAPH_H__CE1DE857_B8E5_42E0_9B32_73FF8714CD66__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "..\include\flasktypes.h"
#include "Canvas.h"
#include <deque>

using namespace std;

#define PROGRESSBAR_WIDTH 2


struct TProgressBar
{
  long nHeight;   //height in pixels of the bar
  bool bKeyFrame; // The bar represents a keyframe
};

struct TProgressFrame
{
  long nValue;    // size of the frame
  bool bKeyFrame; // The bar represents a keyframe
};

class CProgressGraph : public CCanvas  
{
public:
	CProgressGraph();
	virtual ~CProgressGraph();

  bool Initialize( HWND hWnd, long nWidth, long nHeight,  long nFrameDelay);

  void NewFrame( long size, bool bKeyframe );
  void StreamInfo( ui64 size );
  void Draw();

private:
  deque<TProgressBar>    m_vBars;
  deque<TProgressFrame> m_vFrames;

  long m_nBarCount;
  long m_nBarSize;
  long m_nFramedelay; // in 100ns units

  HWND m_hWnd;

  // Stats
  long m_nMinFramesize;
  long m_nMaxFramesize;
  __int64 m_nTotalFramesize;
  ui64 m_nTotalSize;
  long m_nFramecount;

  // Calculated stats
  long m_nAverageVideoBitrate; // in kilobits
  long m_nAverageBitrate;

};

#endif // !defined(AFX_PROGRESSGRAPH_H__CE1DE857_B8E5_42E0_9B32_73FF8714CD66__INCLUDED_)
