/* 
 *  ProgressDlg.h
 *
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#if !defined(AFX_PROGRESSDLG_H__F55B2A0F_D696_4C8F_91FE_BBB67B2E5A59__INCLUDED_)
#define AFX_PROGRESSDLG_H__F55B2A0F_D696_4C8F_91FE_BBB67B2E5A59__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "flasktypes.h"

// Priorities
#define IDLE_PRIO	 0
#define NORMAL_PRIO  1
#define HIGH_PRIO    2
#define HIGHEST_PRIO 3


#ifndef PURE
#define PURE =0
#endif 

// Class that supports progress tracking.
class CProgressTracking
{
public:
  virtual ui32 GetPresentFrame() PURE;
  virtual void Cancel() PURE;
  virtual void Pause() PURE;
  virtual void Resume() PURE;
  virtual bool Terminated() PURE;
  virtual bool IsPaused() PURE;
  virtual void DualPassInfo( bool &isDualPass, bool &IsFirstPass) PURE;
  virtual char *GetOutputFileName() PURE;
  virtual ui64 GetProcessed() PURE;
  virtual ui64 GetSize() PURE;
  virtual ui32 GetJobCount() PURE;
  virtual ui32 GetJobInProcess() PURE;
  virtual void SetProgressPriority(ui32 nPriority) PURE;
};

// Class that supports progress report
class CProgressReport
{
public:
  virtual ui32 NewFrameInfo(ui32 size, bool keyframe) PURE;
  virtual ui32 StreamInfo(ui64 sizewritten) PURE;
};



// Define an the report class for our dialog
// The class will send the WM_NEWFRAMEINFO message
// to the dialog every time there is new info about
// a frame
#define WM_NEWFRAMEINFO  WM_USER + 1
#define WM_STREAMINFO  WM_USER + 2


class CProgressReportDlg: public CProgressReport
{
  public:
    CProgressReportDlg()
    {
      m_hDlg = NULL;
    }

    ui32 NewFrameInfo(ui32 size, bool keyframe)
    {
      if(m_hDlg)
        PostMessage(m_hDlg, WM_NEWFRAMEINFO, (WPARAM)size, (LPARAM)keyframe);

      return 0;
    }
    ui32 StreamInfo(ui64 sizewritten)
    {
      if(m_hDlg)
        PostMessage(m_hDlg, WM_STREAMINFO, (WPARAM)sizewritten, (LPARAM)(sizewritten>>32) );
      return 0;
    }
    void SetDlg(HWND hDlg)
    {
      m_hDlg = hDlg;
    }

  private:
    HWND m_hDlg;

};

LRESULT CALLBACK ProgressDlg(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);

#endif // !defined(AFX_PROGRESSDLG_H__F55B2A0F_D696_4C8F_91FE_BBB67B2E5A59__INCLUDED_)
