/* 
 *  Profile.h 
 *
 *	Copyright (C) Alberto Vigata - July 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#if !defined(AFX_PROFILE_H__801551A0_7519_11D4_8C5F_604465C100D7__INCLUDED_)
#define AFX_PROFILE_H__801551A0_7519_11D4_8C5F_604465C100D7__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "./Misc/CArray.h"
#include "flaskmpeg.h"


class CProfile  
{
public:
	int Select(int profileIndex);
	TProfile * GetSelected();
    int GetSelectedIndex();
    TProfile * Get( int profileIndex);
	int GetCount();
	int DeleteProfile( int profileIndex);
  TProfile *GetDefault();
	int AddProfile(TProfile *profile_data);
	int Refresh();
  bool IsDefault();
  int  GetDefaultIndex();
  bool SetDefault(TProfile *prof);
  int CProfile::FindIndexWithName(char *profile_name);
  void SelectDefault();
  bool IsSameProfile(TProfile *prof); //Compares passed profile with current profile. True if equal.
  bool AddNSelect( TProfile *prof );
	CProfile(char *program_directory);
	virtual ~CProfile();

private:
    CArr<TProfile> profiles;
    int   n_selected;
	char  program_directory[MAX_PATH];
    //private functions
    int LoadProfileFromDisk(char *fileName);
    // Sort profiles
    void Sort();
    // Swap to items
    void Swap(int a, int b);
};

#endif // !defined(AFX_PROFILE_H__801551A0_7519_11D4_8C5F_604465C100D7__INCLUDED_)
