/* 
 *  PostProcessing.h
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#ifndef POST_PROCESSING_H
#define POST_PROCESSING_H

#include ".\profile.h"
#include ".\framesource.h"
#include "Crop.h"
#include "letterbox.h"
#include "flfilterchain.h"

struct TPPost
{
	// Original image
	int					nInWidth;
	int					nInHeight;
	// Resizing
  bool        bResize;
	bool				doAR;
	int					outAR;
	double				iDAR;
	int					filterMode;
	int					resWidth;
	int					resHeight;
	
	// Crop and letterboxing
	bool				crop;
	int					cropTopOffset;
	int					cropHeight;
	int					cropLeftOffset;
	int					cropWidth;

	bool				letterbox;
	int					letterboxTop;
	int					letterboxBottom;
	int					letterboxLeft;
	int					letterboxRight;

  // Video controls
  bool videocontrols;
  int  brightness;
  int  hue;
  int  contrast;

	// Deinterlacing
	bool                deinterlace;
	int                 threshold;
	int                 blend_fields;

  // Processing format
  int         nProcessingFormat;

	// Current time to be used in subtitles stamping
	i64                 myClock;

};

/*
#define  PPOST_WIDTH(x) (x.crop ? x.cropWidth : x.resWidth)
#define PPOST_HEIGHT(x) (x.crop ? x.cropHeight : x.resHeight)
*/

class FlPostProcess : public CFrameSource
{
public:
  FlPostProcess();
  bool Set(TPPost *pp);
  TPPost *Get(){ return &m_pp; }
  bool Start();
  int Process(CFrame *pSrc, CFrame *pDst);
  bool Stop();
  int GetWidth(){ return m_nWidth; }
  int GetHeight(){ return m_nHeight; }

private:
  int Validate();
  int BuildChain();
  int DestroyChain();
  bool GetFrame( CFrame **ppFrame );

  TPPost m_pp;

  FlFilter *m_fil[nMaxFilters];
  int  m_filc;
  int  m_nWidth, m_nHeight;

  CFrame *m_pIn;
};

void FromConfigToPPost(  TProfile *prof, TPPost *pp, int nSrcWidth=0, int nSrcHeight=0, double fDar=0, int nProcessingFormat=0 );
void FromPPostToConfig( TProfile *prof, TPPost *pp);

void FixPPostSettings( TPPost *pp );

int CheckVideoParameters(TPPost *pp);
#endif