/* 
 *  OutputPad.cpp    -  Controls FlasKMPEG options
 *
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

 
#ifndef OUTPUTPAD_H
#define OUTPUTPAD_H

#include <windows.h>
#include "PostProcessing.h"
#include "flvideosink.h"
#include "flppreceiver.h"
#include "thread.h"
#include "videorenderer.h"
#include "canvas.h"
#include "flcroppad.h"
#include "flletterboxpad.h"

LRESULT CALLBACK DlgProcHook(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);

class COutputPadDlg : public FlVideoSink
{
public:
  COutputPadDlg(HWND hParentWnd, HWND hMainControl, HINSTANCE hInst);
  ~COutputPadDlg(){};

  // Opens the dialog
  void SetWindows( HWND hParentWnd, HWND hMainControl );
  bool Show(TPPost *pPPost, FlPPReceiver *ppRec );
  bool Hide();
  int PutFrame( CFrame *fr );

private:

  void SetupTooltips();
  void PositionWindows(bool bExcludeOutputPad=false);
  void EnableCrop();
  void DisableCrop();
  void EnableLetterbox();
  void DisableLetterbox();
  void UpdatePadButtons();
  void Draw();
  
  friend LRESULT CALLBACK DlgProcHook(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
  friend LRESULT CALLBACK DisplayProcHook(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
  
  LRESULT CALLBACK DisplayProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
  LRESULT CALLBACK DlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);

  bool m_bSettingsChanged;
  HWND m_hDlg;
  HWND m_hParentWnd, m_hDisplay, m_hMainControl;
  HINSTANCE m_hInst;
  FlPPReceiver *m_pReceiver;
  int m_nFrameCount;

  TPPost pp, ppc;
  FlPostProcess m_pp; // the post processing object

  CFlCritSec m_csGlobal;
  CFrame frIn, frOut, frRgb;
  CCanvas m_cv;

  FlLetterboxPad m_lp; // The letterbox pad
  FlCropPad m_cp; // The crop pad

  CVideoRenderer *m_pVideoRenderer; // The video renderer
};


#endif