/* 
 *  OutputManager.h
 *
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#if !defined(AFX_OUTPUTMANAGER_H__4A6D4869_F64A_41A6_B12B_1B2A529DD8DF__INCLUDED_)
#define AFX_OUTPUTMANAGER_H__4A6D4869_F64A_41A6_B12B_1B2A529DD8DF__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "thread.h"
#include "videosource.h"
#include "progressdlg.h"
#include "batchlist.h"
#include "..\include\floutapi.h"
#include "postprocessing.h"
#include "profile.h"


typedef struct tagTOutputManagerRunInfo
{
  batchlist *pJobList;
  CProgressReport *pReport;
  TProfile prof;
}TOutputManagerRunInfo;

class COutputManager:public CProgressTracking, public CFlThread
{
public:
  void ConfigureOutput(long nIndex);

  CVideoSource *GetSource(){ return m_pVideoSource; }
	COutputManager();
	virtual ~COutputManager();

  // The Run function
  bool Run( TOutputManagerRunInfo *pRunInfo );

  // Progress Tracking stuff
  void SetProgressPriority(ui32 nPriority)
  { 
    CFlAutoLock lock( &m_csConv );
    if( m_bConvInProgress )
    {
      SetPriority(nPriority); 
      if(m_pVideoSource) m_pVideoSource->SetPriority(nPriority);      
    }
  }
  char *GetOutputFileName(){ return m_pOutputFileName; }
  ui64 GetProcessed(){ return m_nConversionProcessed+m_nPartialProcessed; }
  ui64 GetSize(){ return m_nConversionSize; }
  ui32 GetJobCount(){ return m_oJobList.size(); }
  ui32 GetJobInProcess(){ return m_nJobInProcess; }
  ui32 GetPresentFrame() {return m_nFrameCount; }
  void Cancel(){ m_evResumeCompile.Set(); m_evCancelCompile.Set(); m_evCompileCanceled.Wait(); }
  void Pause(){ m_evResumeCompile.Reset(); m_evPauseCompile.Set(); }
  void Resume(){ m_evResumeCompile.Set(); }
  void DualPassInfo( bool &isDualPass, bool &IsFirstPass)
  { IsFirstPass = m_bFirstPass; 
    isDualPass = m_bIsDualPass; }
  bool Terminated(){ return m_bTerminated; }
  bool IsPaused(){ return !m_bIsRunning; }

  flreturn_t getstream(ui32 streamid, getstream_s *st);
  flreturn_t getstream_report( ui32 streamid, getstream_report_s *st);

  flreturn_t getvideo(getvideo_s *gv);
  flreturn_t getaudio(getaudio_s *ga);

  flreturn_t getvideo_report(getvideo_report_s *gvr);

  enum {
    video=0,
    audio
  } streamid_t;



  // conversion variables
  i64 m_nMyClock;
  ui32 m_nFrameSpan;
  ui32 m_nAudPrevFrame;
  ui32 m_nAudSamplesPerFrame;
  bool m_bImageWaiting;
  bool m_bIsRunning;
  bool m_bTerminated;
  bool m_bConvInProgress;

  bool m_bFirstTime;

  // Some events
  CFlEvent m_evCompileCanceled;
  CFlEvent m_evCancelCompile;
  CFlEvent m_evPauseCompile;
  CFlEvent m_evResumeCompile;
  CFlEvent m_evCompileTerminated;
  
  ui32 m_nFrameCount;

  // Static
  CFrame *m_pFrameInProcess;
  
  CVideoSource *m_pVideoSource;

private:
  bool StartJob( int nJobIndex );
  void StopJob( int nJobIndex );

  bool StartInput( ui64 nStart, ui64 nStop );
  bool StopInput();

  ui32 Convert();
  // Actual running thread
  DWORD ThreadProc();  
  char *AddFileExtension(char *);
  

  // conversion variables
  bool m_bIsDualPass;
  bool m_bFirstPass;
  bool m_bInputStarted;
  ui64 m_nStartPos, m_nStopPos;    // start, stop position for the current job
  ui64 m_nConversionProcessed;
  ui64 m_nPartialProcessed;
  ui64 m_nConversionSize;
  ui32 m_nJobInProcess;
  ui32 m_nJobCount;

  // Postprocessing settings
  TPPost m_pps;
  TProfile m_prof;

  // Report of operations
  CProgressReport *m_pReport;
  TOutputManagerRunInfo m_sRunInfo;

  CListFrameBuffer *m_pDecodedFrameBuffer;
  char m_pOutputFileName[1024];

  // Destination Frame
  CFrame m_frDest;

  // Critical secion for conversion
  CFlCritSec m_csConv;

  // Job list
  batchlist m_oJobList;
};

#endif // !defined(AFX_OUTPUTMANAGER_H__4A6D4869_F64A_41A6_B12B_1B2A529DD8DF__INCLUDED_)
