/* 
 *  StatsStrings.h 
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#ifndef STATS_STRINGS_H
#define STATS_STRINGS_H


#define STRING_SIZE 1024

struct TInMediaStatsStrings
{
    char video_width[STRING_SIZE];
    char video_height[STRING_SIZE];
    char video_size[STRING_SIZE];
    char video_aspect_ratio_information[STRING_SIZE];
    char video_bit_rate[STRING_SIZE];
    char video_detected_frame_rate[STRING_SIZE];
    char video_frame_rate[STRING_SIZE];
    char video_format[STRING_SIZE];
    char video_structure[STRING_SIZE];

    char audio_sample_freq[STRING_SIZE];
    char audio_channels[STRING_SIZE];
    char audio_bit_rate[STRING_SIZE];
    char audio_format[STRING_SIZE];
};

struct TOutMediaStatsStrings
{
  char video_width[STRING_SIZE];
  char video_height[STRING_SIZE];
  char video_size[STRING_SIZE];
  char video_aspect_ratio_information[STRING_SIZE];
  char video_bit_rate[STRING_SIZE];

  char video_frame_rate[STRING_SIZE];
  char video_format[STRING_SIZE];
  char video_structure[STRING_SIZE];
  
  char audio_sample_freq[STRING_SIZE];
  char audio_channels[STRING_SIZE];
  char audio_bit_rate[STRING_SIZE];
  char audio_format[STRING_SIZE];
};


struct TStatsStrings
{
    TInMediaStatsStrings  InMedia;
    TOutMediaStatsStrings OutMedia;
};

void RenderInaudioStatsStrings( TStatsStrings *stats );
int RenderStatsStrings( TStatsStrings *stats );

#endif STATS_STRINGS_H