/* 
 *  SelectorDialog.h
 *
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#ifndef DIALOG_SELECTOR_H
#define DIALOG_SELECTOR_H

#include "..\Misc\CArray.h"

#define MAX_SECTIONS 8
#define MAX_STRING_SIZE 128
#define MAX_STRINGS_SEC 1024


#define MUST_SELECT     0x01
#define SINGLE_SELECT   0X02
#define MULTIPLE_SELECT 0X04
class TSelectorDialog
{
public:
	char *tittle;
	char *lateral_text;
	char *button_text;
	char *sections_titles[MAX_SECTIONS];
	int   section_count;

	CArr <char *> strings[MAX_SECTIONS];
	CArr <char *> helpstrings[MAX_SECTIONS];

	int   first_in_section[MAX_SECTIONS];
	int    last_in_section[MAX_SECTIONS];
	
	CArr <int> selected[MAX_SECTIONS];
	char   selected_count[MAX_SECTIONS];
	char   section_mode[MAX_SECTIONS];
};

// Setting up Selector Dialog
//
// Setting modes:
//   MUST_SELECT    at least one selection has to be done in the section
//   SINGLE_SELECT  only one selection can be done. The selection is stored in selected[][0]
//   MULTIPLE_SELECT The selection is stored in selected[section][] con selected_count[]
int  OpenSelectorDialog(HWND hWnd, HINSTANCE hInstance, TSelectorDialog *settings);
void ResetSelections(TSelectorDialog *settings);
int  GetFirstSelected( TSelectorDialog *set, int section );
#endif DIALOG_SELECTOR_H