/* 
 *  Graph.h
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#ifndef GRAPH_H
#define GRAPH_H

// Special AVIplug Handling
#define VXXtype	0x56585858L		// 'VXXX' type
#define ODMLtype 'ODML'

struct TAVIPlugGraphInfo
{
	int Video;
	int Audio;
};


struct TGraph{
	int  posw;
	int  last55[55];
	int  br_actual,br_max,br_min,br_fr;
	int  last55_input[55];
	int  posw_input;
	__int64 lastfpos,br_avr;
};


void GraphStart(TGraph *gr);
void DrawGraph(HWND hDlg, TGraph *gr);
void UpdateGraph(TGraph *gr, TAVIPlugGraphInfo *info);

#endif 