/* 
 *  CArray.h
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


// THIS IS A TEMPLATED CLASS. ALL CODE IS INCLUDED HERE
#ifndef CARRAY_H
#define CARRAY_H

#include <malloc.h>
#include <memory.h> 
template <class T> class CArr
{

	public:	
		CArr();
		~CArr();
		T  *GetData();
		int GetCount();
		int AddItem(T *item);
		int EmptyArray();
		int SetArraySize(int size);
		T& operator[](int index);
		CArr<T>& operator=(CArr<T>& right);
	private:
		int n_count;
		T   *data;
};




template <class T> CArr<T>::CArr()
{
	n_count = 0;
	data    = 0;
};

template <class T> CArr<T>::~CArr()
{
	if(data)
		delete []data;
	data = 0;
};


template <class T> int CArr<T>::AddItem(T *item)
{
	T *temp;
	int i;
	if(!item)
		return 0;
	// first allocate space for the current data plus one item
	temp = new T[n_count + 1];
	if(!temp)
		return 0;
	// Copy all contents
	//   Current contents first
	for(i=0; i<n_count; i++)
		 temp[i] = data[i];
	// copy item to add
	temp[n_count] = *item;

	// delete previous vector. delete will call the destructors if any?
	if(data)
		delete []data;
	data = temp;

	n_count++;
	return 1;
};

template <class T> T* CArr<T>::GetData()
{
	return data;
};

template <class T> int CArr<T>::EmptyArray()
{
	if(data)
		delete []data;
	data    = 0;
	n_count = 0;
	return 1;
};

template <class T> int CArr<T>::SetArraySize(int size)
{
	T *temp;
	int i;
	if(size<=0)
		return 0;

	// first allocate space for data
	temp = new T[size];
	if(!temp)
		return 0;
	// Copy all current contents
	for(i=0; i<(n_count > size ? size : n_count); i++)
		 temp[i] = data[i];
	

	// delete previous vector. delete will call the destructors if any?
	if(data)
	   delete []data;
	data = temp;
	if(!data)
		return 0;

	n_count = size;
	return 1;
};


template <class T> T& CArr<T>::operator[](int index)
{
	if(index>n_count-1)
		return data[n_count-1];
	if(index<0)
		return data[0];
	return data[index];
};

template <class T> CArr<T>& CArr<T>::operator=(CArr<T>& right)
{
	int i,count;
	//Copy right array
	EmptyArray();
	count = right.GetCount();
	SetArraySize( count );
	for(i=0; i<count; i++)
		data[i]=right[i];

	return *this;
};

template <class T> int CArr<T>::GetCount()
{
	return n_count;
};



#endif