/* 
 *  MasterClock.h
 *
 *	Copyright (C) Alberto Vigata - July 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */




#ifndef MASTERCLOCK_H
#define MASTERCLOCK_H

#include "FlaskTypes.h"
#include "Thread.h"

typedef ui64 tick;
typedef ui64 mmtick; // A mmtick is defined as 100ns time period

#define FROMCOUNT_TO_TICK( counterticks, freq ) ((mmtick)((counterticks * 10000) / freq))

typedef enum { ClkSystem =0, ClkSlave} ClkType;


class CMasterClock
{


public:
  CMasterClock(ClkType nMode);
  ~CMasterClock();
  // Initialize the master clock.
  // Must return true to be able to use all the other methods.
  bool Initialize();
  void Set(tick tkTime);

  // The mmticks elapsed from the
  // moment we set the time with
  // Set()
  mmtick GetTickCount();

  // Wait waits tkTime, and blocks the calling thread
  // during the period. tkWindowPeriod is the maximum
  // value to wait
  void Wait( mmtick tkTime, mmtick tkWindowPeriod );

  // Blocks the calling thread until the time of the
  // clock goes avobe the specified time.
  // The user has to be careful with this function
  // because if the specified time is way off the given
  // clock, the thread will be blocked. 
  void WaitUntil( mmtick tkTime );

private:
  ClkType m_nMode;
  tick   m_tiFrequency, m_tiStartTime;
  mmtick m_mmtkStartDelay, m_mmtkStartTime;

  mmtick m_tkTime; // when in slave mode, this is the current clock value
  
  CFlCritSec m_csGlobal; // Critical section to control reentrancy
 
};

#endif

