/*
 *  FormatDefs.h
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#ifndef FORMATDEFS_H
#define FORMATDEFS_H


// frame formats

#define FRAME_RGB32  1

#define FRAME_RGB24  2

#define FRAME_YUY2   4
#define FRAME_YV12   8
#define FRAME_YVYU   16
#define FRAME_VYUY   32
#define FRAME_UYVY   64
#define FRAME_IYUV   128


#define FRAME_YUV422 512  /* planar format. Y plane first, V,U planes next-> 4:2:2 */
#define FRAME_YUV444 1024 /* planar format. Y plane first, V,U planes next-> 4:4:4 */

#define FRAME_YUV444A 2048 /* planar format with additional alpha info. */
#define FRAME_YV12A   4096 /* planar format with additional alpha info */

typedef unsigned long	Pixel;
typedef unsigned long	Pixel32;
typedef unsigned char	Pixel8;

#endif
