/* 
 *  FlasKMPEG.h 
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#ifndef FLASKMPEG_H
#define FLASKMPEG_H

#include <windows.h>
#include <winbase.h>
#include <wingdi.h>
#include <CommCtrl.h> 
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>


#include "./FlasKTypes.h"
#include "FormatDefs.h"
#include "./Audio/Audio.h"

#include <io.h>


#define MAXFILENAME 1024
#define PROFILE_VERSION 3000

typedef struct{
  int scale;
  int sampleSize;
} timebase_s;

struct TProfile
{
  int         nProfileVersion;
  char        profile_name[MAXFILENAME];

	//Video options
  bool        bResize;
	int					InterpolatedWidth;
	int					InterpolatedHeight;
	timebase_s  timeBase;
	bool                recons_progressive;

	//Crop and letterboxing
	bool				crop;
	int					cropTopOffset;
	int					cropHeight;
	int					cropLeftOffset;
	int					cropWidth;

	bool				letterbox;
	int					letterboxTop;
	int					letterboxBottom;
	int					letterboxLeft;
	int					letterboxRight;

  // Video controls
  bool  videocontrols;
  int  brightness;
  int  hue;
  int  contrast;

	//Interlacing
	bool				deinterlace;
	int					threshold;
	int					blend;

	int					keepAspect;


	//Audio options
	int				audioMode; 
	int					  outSampleFrequency;
	bool				  sampleFreqSameAsInput;
  TAudioProperties sAudioProperties;

    //Interpolation filter options
	int					filter;

};

/* FlasK MPEG options */
typedef struct tagTConfig
{
  int         version;
  //Miscelaneous
  bool				firstTimeRunning;
  bool        showDetailsInProgress;
  
  int					outputFormat;       // Output plugin selected
  int         hOutputFile;
  int					priority;
  int         selected_language;
  int         selected_profile;
  
  bool				displayVideo;
  ui32    		presentFrame;

  bool        bDualPass;
  bool        compileWhole;
  int					displayTimeUnits; /* general diag box: 0 = seconds, 1 = frames */
  unsigned long		framesToCompile;
  int					selectedTab;

 	bool                warn_overwrite;
  bool                shutdown;
  int					lurk_size;

  bool			  idctAutoSelect;
  int         idctIndex;

  // Output Format
  bool        bProcessingFormatAuto;
  int         nProcessingFormat;
  
  //File options
  char				inputFile[MAXFILENAME];
  char					inputDir[MAXFILENAME];
  char                outputFile[MAXFILENAME];
  char					outputDir[MAXFILENAME];
  char                audioOutFile[MAXFILENAME];
  char					audioOutDir[MAXFILENAME];
  
  
  // Last opened files
	char		      lastFiles[4][MAXFILENAME];
} TConfig;


//audioTypes
#define AC3			0
#define MPEG		1
#define NO			2

// aspect ratio types (use: bool use_ar43 = profile.keepAspect & AR43;)
#define KEEP_AR		1
#define AR_BITS		254
#define AR_11		2
#define AR_43		4
#define AR_169		8

typedef struct
{
	ULONG        totalFileSize;
	ULONG		currentPosition;
} TFileProgress;


int LoadRegistryConfig( TConfig *Config );
void SaveRegistryConfig( TConfig *Config );
void ShowInConsole(char *buffer);


#define INPUT_NOEXIST			1
#define IS_TRANSPORTSTREAM      2
#define NOT_RECOGNIZED			3
#define NO_AUDIOVIDEO           4





#endif 