/* 
 *  FlasKMPEG.cpp 
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */




#include "FlasKMPEG.h"

#include "./Demux/Demux.h"
#include "./Video/VideoWrapper.h"
#include "./Audio/Audio.h"
#include "./plugins.h"
#include "./error.h"
#include "./RunState.h"
#include "./language.h"
#include "./Misc/Graph.h"
#include "./Misc/StatsStrings.h"
#include "./FileOpen.h"
#include "./AudioProperties.h"
#include "./Audio/ExportAudio.h"
#include "./Player.h"
#include "./AudioProperties.h"
#include "./ProgressDlg.h"
#include "./Mism.h"
#include "./Background.h"
#include "version.h"


#include <malloc.h>
#include <commdlg.h>
#include <CommCtrl.h> 
#include "resource.h"
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <fcntl.h>
#include <math.h>
#include <mbstring.h>


#include ".\Resizer\resizer.h"
#include ".\postprocessing.h"
#include "auxiliary.h"


#define MAX_LOADSTRING 100
#define TESTING_IFO_PARSER
//#define TESTING_AUDIO_OUTPUT
//#define TESTING_MULTIAUDIO
// Global Variables:
extern "C" BOOL FPU_enabled;

BOOL FPU_enabled;
HINSTANCE		    hInst;								// current instance
TCHAR				szTitle[MAX_LOADSTRING];								// The title bar text
TCHAR				szWindowClass[MAX_LOADSTRING];								// The title bar text
HANDLE				hThrd;
DWORD					IDThread, ENCIDThread; 
HANDLE				hEncodingThread;



unsigned char       *newblock;
char                program_directory[MAX_PATH];


TRunState rs;

CFrame frBackground(NULL);

HWND  				hMainWnd;
BITMAPINFOHEADER	DibHeader;
BITMAPINFO			DibInfo;
BOOL                playerStopped;
BOOL				 abortCompile;		//Use this to abort the compile
BOOL				 audioFinished;
BOOL				compileAborted;     //Use this to kill progress dialog
BOOL				decodingFinished;	//The decoding thread has finished
//framerate sync variables
i64 myClock;
static i64 frameSpan;
static double audioSamplesPerFrame;

bool   imageWaiting;
bool   firstTime;
bool   firstImageAlreadyDecoded=false;
presInfo pInfo;
// Compiling globals
int		audioPrevFrame;
bool    pauseCompile;
bool	compileIsPaused;

TFileProgress		FileProgress;

static CBackground *g_pBackground = NULL;


typedef enum{LOAD_LIBRARY,
	 ENCODE,
	UNLOAD_LIBRARY}		EncEnum;
EncEnum		sendEncodingThread;


// 
#ifdef TESTING_AUDIO_OUTPUT
	FILE	*test_sound_file;
#endif

// Foward declarations of functions included in this code module:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK    OutputOptionsDlg(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK	ProgressDlg(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);

               void SetTextMenu();

                
               
int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
 	// TODO: Place code here.
	MSG msg;
	HACCEL hAccelTable;

  // Create Basic FlasKMPEG objects
  char szTemp[MAX_PATH];
  GetModuleFileName(NULL, szTemp, MAX_PATH);
  // Copy just the path
  // We do that by replacing the last \ with end-of-string.
  char *p,*pbs = 0;
  for (p = szTemp; *p ; p++) if (*p == '\\') pbs = p;
  if (pbs) *pbs = '\0';
  strcpy(program_directory, szTemp);
  //_mbsnbcpy( (unsigned char *)program_directory, (unsigned char *)szTemp, strlen(szTemp) - strlen("FlasKMPEG.exe") -1 );

  rs.lng = new CLanguage(program_directory);
  if(rs.lng){
    rs.lng->Start();
  }

    rs.profiler = new CProfile(program_directory);

	// Initialize global strings
	strcpy( szTitle, GS(APPTITLE) );
  //	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_FLASKMPG2MPG1, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_FLASKMPG2MPG1);

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return msg.wParam;
}

// file=> file to get extension from
// ext => string to put extension
char *get_file_ext(char *file, char *ext){
    if(!file || !ext)
        return NULL;
    int len = strlen( file );

    ext[0] = file[len-3];
    ext[1] = file[len-2];
    ext[2] = file[len-1];
    ext[3] = 0;
    return ext;
}


//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    This function and its usage is only necessary if you want this code
//    to be compatible with Win32 systems prior to the 'RegisterClassEx'
//    function that was added to Windows 95. It is important to call this function
//    so that the application will get 'well formed' small icons associated
//    with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
  WNDCLASSEX wcex;
  
  wcex.cbSize = sizeof(WNDCLASSEX); 
  
  wcex.style			= CS_HREDRAW | CS_VREDRAW;
  wcex.lpfnWndProc	= (WNDPROC)WndProc;
  wcex.cbClsExtra		= 0;
  wcex.cbWndExtra		= 0;
  wcex.hInstance		= hInstance;
  wcex.hIcon			= (HICON)LoadImage(hInstance, (LPCTSTR)IDI_FLASKMPG2MPG1, IMAGE_ICON, 0,0,0);
  wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
  wcex.hbrBackground	= 0; /*(HBRUSH) CreateSolidBrush(MASKCOLOR)*/;
  wcex.lpszMenuName	= (LPCSTR)IDC_FLASKMPG2MPG1;
  wcex.lpszClassName	= szWindowClass;
  wcex.hIconSm		= NULL;//LoadIcon(wcex.hInstance, (LPCTSTR)IDI_FLASKMPG2MPG1);
  
  return RegisterClassEx(&wcex);
}

//
//   FUNCTION: InitInstance(HANDLE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.
//
// Mesage handler for about box.
LRESULT CALLBACK WelcomeDlg(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  char szTemp[256];

  switch (message)
  {
		case WM_INITDIALOG:
      // Change the title to current version
      sprintf( szTemp, "Welcome to FlasKMPEG %d.%d.%d", FLASK_VERSION>>24, 
                                                       (FLASK_VERSION>>16)&0xFF, 
                                                       (FLASK_VERSION>>8)&0xFF );
      DlgSetText( hDlg, IDC_TEXTO, szTemp );
      return TRUE;
      
    case WM_COMMAND:
      
      
      if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
      {
        EndDialog(hDlg, LOWORD(wParam));
        return TRUE;
      }
      break;
  }
  return FALSE;
}

// WorkOut how many last files there are
int LastFilesCount()
{
  int files=0;
  for( int i=0; i<4; i++ )
  {
    if( rs.conf.lastFiles[i][0]!='\0' )
      files++;
  }
  return files;
}


void InsertFileInLastFilesList( char *file )
{
  if(file)
  {
    // if the file is already there don't put it
    for(int j=0; j<4; j++)
      if( strcmp( rs.conf.lastFiles[j], file ) == 0 )
        return;

    for(int i=3; i>=1; i--)
    {
      strcpy( rs.conf.lastFiles[i], rs.conf.lastFiles[i-1] );
    }
    strcpy( rs.conf.lastFiles[0], file );
  }
}
// Rebuild the menu from all settings
void SetTextMenu(){
  HMENU menu;
  int i;

  MenuSetText(GetMenu(hMainWnd), 0, GS(MENU_FILE));
  MenuSetText(GetMenu(hMainWnd), 1, GS(MENU_PROFILES));
  MenuSetText(GetMenu(hMainWnd), 2, GS(MENU_OPTIONS));
  MenuSetText(GetMenu(hMainWnd), 3, GS(MENU_RUN));
  MenuSetText(GetMenu(hMainWnd), 4, GS(MENU_ABOUT));
  
  // File preferences
  menu = MenuGetPopup(GetMenu(hMainWnd), 0);
  MenuSetText( menu, 0, GS(MENU_OPEN));
    // LastFiles
    while(RemoveMenu(menu, 2, MF_BYPOSITION ));
    for(i=0; i<LastFilesCount(); i++)
    {
      MenuAddItem( menu, i+3, i+10500, rs.conf.lastFiles[i] );
    }
  MenuAddSeparator( menu, LastFilesCount() + 2 );
  MenuAddItem( menu, LastFilesCount() + 3, IDM_EXIT, GS(MENU_EXIT) );
  
  // Presets
  menu = MenuGetPopup(GetMenu(hMainWnd), 1);
  while(RemoveMenu(menu, 0, MF_BYPOSITION ));
  
  for(i=0; i<rs.profiler->GetCount(); i++){
    MenuAddItem( menu, i, i+10400, (rs.profiler->Get(i))->profile_name );
  }
  MenuCheck(hMainWnd, 10400+rs.profiler->GetSelectedIndex() );
  
  // Options preferences
  menu = MenuGetPopup(GetMenu(hMainWnd), 2);
  MenuSetText( menu, 0, GS(MENU_OUTPUTFORMAT));
  MenuSetText( menu, 1, GS(MENU_OUTOPTIONS));
  MenuSetText( menu, 3, GS(MENU_SELECTOUT));
  MenuSetText( menu, 5, GS(MENU_LANGUAGE));
  
  // Output plugins
  menu = MenuGetPopup(GetMenu(hMainWnd), 2);
  menu = MenuGetPopup(menu, 3);
  while(RemoveMenu(menu, 0, MF_BYPOSITION ));
  
  for(i=0; i<rs.plugs.OutPluginCount; i++){
    MenuAddItem( menu, i, i+10300, rs.plugs.outPlugs[i].ID );
  }
  MenuCheck(hMainWnd, 10300+rs.selected_out_plug);
  
  //Languages menus
		// Get languages popup
  menu = MenuGetPopup(GetMenu(hMainWnd), 2);
  menu = MenuGetPopup(menu, 5);
  
  while(RemoveMenu(menu, 0, MF_BYPOSITION ));
  
  
  int current_lang = rs.lng->GetLanguage();
  int n_lang = rs.lng->GetNumberLang();
  for(i=0; i<n_lang; i++){
    rs.lng->SetLanguage(i);
    MenuAddItem(menu, i, i+10000, rs.lng->GetLanguageID() );
  }
  
  rs.lng->SetLanguage(current_lang);
  
  //Run
  menu = MenuGetPopup(GetMenu(hMainWnd), 3);
  MenuSetText( menu, 0, GS(MENU_PLAYER));
  // TODO language stuff for extract wav and audioplayer
  MenuSetText( menu, 4, GS(MENU_STARTCONV));
  
  
  DrawMenuBar( hMainWnd );
}

void SetMenuMPEG(){
	MenuCheck(hMainWnd, IDM_MPEG);
	MenuUnCheck(hMainWnd, IDM_AVI);
	MenuEnable(hMainWnd,IDM_MPEG1OPTIONS);
}
void SetMenuAVI(){
	MenuCheck(hMainWnd, IDM_AVI);
	MenuUnCheck(hMainWnd, IDM_MPEG);
	//MenuDisable(hMainWnd,IDM_MPEG1OPTIONS);
	MenuEnable(hMainWnd,IDM_MPEG1OPTIONS);
}
void EnableMenu(){
  EnableMenuItem( GetMenu(hMainWnd), 1, MF_ENABLED|MF_BYPOSITION );
  EnableMenuItem( GetMenu(hMainWnd), 2, MF_ENABLED|MF_BYPOSITION );
  EnableMenuItem( GetMenu(hMainWnd), 3, MF_ENABLED|MF_BYPOSITION );
}
void DisableMenu(){
  EnableMenuItem( GetMenu(hMainWnd), 1, MF_GRAYED|MF_BYPOSITION );
  EnableMenuItem( GetMenu(hMainWnd), 2, MF_GRAYED|MF_BYPOSITION );
  EnableMenuItem( GetMenu(hMainWnd), 3, MF_GRAYED|MF_BYPOSITION );
}

// Disable/Enable AllMenu are called to 
// disable/enable menu options when compiling
void DisableAllMenu(){
	DisableMenu();
  EnableMenuItem( GetMenu(hMainWnd), 0, MF_GRAYED|MF_BYPOSITION );

  DragAcceptFiles(hMainWnd, FALSE);

}
void EnableAllMenu(){
	EnableMenu();
  EnableMenuItem( GetMenu(hMainWnd), 0, MF_ENABLED|MF_BYPOSITION );

    DragAcceptFiles(hMainWnd, TRUE);
}

void LoadDefaultProfile()
{


	rs.prof.crop			=	false;
	rs.prof.cropTopOffset =	0;
	rs.prof.cropHeight	=	288;
	rs.prof.cropLeftOffset=	0;
	rs.prof.cropWidth		=	352;


  rs.prof.videocontrols = false;
  rs.prof.brightness  = 128;
  rs.prof.contrast   = 128;
  rs.prof.hue  = 128;

	rs.prof.letterbox		=	false;
	rs.prof.letterboxTop	=	0;
	rs.prof.letterboxBottom=	0;
	rs.prof.letterboxLeft	=	0;
	rs.prof.letterboxRight=	0;

	rs.prof.deinterlace   =   0;
	rs.prof.blend         =   1;
	rs.prof.threshold     =  20;

	rs.prof.keepAspect                     = KEEP_AR | AR_11;
	rs.prof.recons_progressive             = true;

  rs.prof.bResize = false;
	rs.prof.InterpolatedWidth=352;
	rs.prof.InterpolatedHeight=288;

	rs.prof.filter                         = FILTER_TABLEBICUBIC;

	rs.prof.timeBase.scale                 = 25;
	rs.prof.timeBase.sampleSize            = 1;

  rs.prof.audioMode                      = DO_AUDIO;
	rs.prof.outSampleFrequency             = 44100;
	rs.prof.sampleFreqSameAsInput          = true;
  rs.prof.sAudioProperties.drc           = false;
  rs.prof.sAudioProperties.drc_value     = 3;
  rs.prof.sAudioProperties.multichannel_volume = false;
  rs.prof.sAudioProperties.center        = 0;
  rs.prof.sAudioProperties.rear          = 0;
  rs.prof.sAudioProperties.front         = 0;
  rs.prof.sAudioProperties.normalize     = false;
  rs.prof.sAudioProperties.normalize_value = 100;
  rs.prof.sAudioProperties.dolby_surround_downmix = true;


  strcpy(rs.prof.profile_name, "Default");

    return;
}
void LoadFirstTime(HINSTANCE hInstance, HWND hWnd){

  LoadDefaultProfile();

	rs.conf.version=FLASK_VERSION;
	rs.conf.showDetailsInProgress=true;

  rs.conf.idctAutoSelect = 1;

  rs.conf.idctIndex=  0;
  rs.conf.selectedTab=0;
  
  rs.conf.warn_overwrite=   true;
  rs.conf.shutdown      =   false;
  rs.conf.lurk_size     =   5000;
  rs.conf.compileWhole       = true;
  rs.conf.framesToCompile                = 3000;
  strcpy(rs.conf.audioOutFile, "C:\\flaskAudioOut");
  strcpy(rs.conf.outputFile, "C:\\flaskOut");
  
	rs.conf.priority      =   1;
	rs.conf.displayVideo                   = true;


	rs.conf.hOutputFile                    = NULL;
	rs.conf.presentFrame                   = 0;
	rs.conf.outputFormat                   = 0;
  rs.conf.bProcessingFormatAuto          = true;
  rs.conf.nProcessingFormat              = FRAME_YV12;
  rs.conf.bDualPass                      = false;

  // Try to select odml avi plugin as default
  for(int i=0; i<rs.plugs.OutPluginCount; i++)
    if(rs.plugs.outPlugs[i].fileType == ODMLtype)
    {
      rs.conf.outputFormat = i;
      break;
    }

  rs.conf.selected_profile               = 0;

	rs.conf.firstTimeRunning= true;

  // Set no files as default
  rs.conf.lastFiles[0][0] = '\0';
  rs.conf.lastFiles[1][0] = '\0';
  rs.conf.lastFiles[2][0] = '\0';
  rs.conf.lastFiles[3][0] = '\0';

	SaveRegistryConfig(&rs.conf);
	LoadRegistryConfig(&rs.conf);
	DialogBox(hInstance, MAKEINTRESOURCE(IDD_WELCOME), hWnd, (DLGPROC)WelcomeDlg);
}


BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   rs.hInst    = hInst    =  hInstance; // Store instance handle in our global variable
   rs.hMainWnd = hMainWnd =  hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPED|WS_SYSMENU|WS_MINIMIZEBOX ,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }

   DragAcceptFiles(hWnd, TRUE);
   InitCommonControls();

   // Check for MMX
   if ( CPUGetSupportedExtensions()&CPU_SUPPORTS_MMX == false ) {
      Critical("FlasKMPEG requires a processor with MMX to work\n");
      return FALSE;
   }


    //Load plugins
	if(!LoadPlugins(&rs.plugs, program_directory)){
		PrintError(ERROR_PLUGIN, (int)hMainWnd, 0);
		exit(0);
	}



   	//Starting options
	if(LoadRegistryConfig(&rs.conf)==0)	//This is the first time. Load defaults
	{
		LoadFirstTime(hInstance, hWnd);
	}
	else
	{
		//Key existed. Check version
		if(rs.conf.version!=FLASK_VERSION)
			LoadFirstTime(hInstance, hWnd);
		else
			rs.conf.firstTimeRunning=false;
	}

  // Loading Profiles
  if(!rs.profiler->Refresh() )
  {
    // Oops. No profiles were present
    LoadDefaultProfile();
    // Try to add the default profile
    rs.profiler->AddProfile( &rs.prof );
    if( !rs.profiler->Refresh() )
      return FALSE;
  }
  else
  {
    rs.profiler->Select( rs.conf.selected_profile );
    rs.prof = *rs.profiler->GetSelected();
  }
  // If the first time running, select the default profile
  if(rs.conf.firstTimeRunning)
  {
    rs.profiler->SelectDefault();
    rs.prof = *rs.profiler->GetSelected();
  }


  // Load Misms. Needs a profile to start with.
  if(!StartMism()){
    exit(0);
  }
	if(rs.plugs.OutPluginCount <= rs.conf.outputFormat)
		rs.conf.outputFormat = 0;

	rs.selected_out_plug = rs.conf.outputFormat;
    SetTextMenu();
	//Miscelaneous Inits
	WindowClientResize( hMainWnd, 352, 288);
  // Move window
  WindowMove( hWnd, 20, 20);
	compileAborted=true;
	playerStopped=true;
	rs.startFilePos=0;
	rs.audio = NULL;
	rs.video = NULL;
  rs.hPlayerWnd = NULL;

  // Initialize video renderer
  rs.pVideoRenderer = new CVideoRenderer(hWnd, false, 0);
  // Set the background logo
  HBITMAP hbm=        LoadBitmap( hInst, MAKEINTRESOURCE(IDB_FONDO));
  frBackground.GetFromBmp(hbm);
  // The frame makes its own copy of the bitmap, so you can close the
  // original now
  DeleteObject(hbm);
  // Set the bitmap as a background for the video renderer
  rs.pVideoRenderer->SetStaticFrame(&frBackground);


  // g_pBackground = new CBackground;
  // g_pBackground->Start( rs.pVideoRenderer, &frBackground );

	rs.lng->SetLanguage( rs.conf.selected_language );
	SetTextMenu();
	rs.working_mode      =  FILE_MODE;

  ShowWindow(hWnd, nCmdShow);

  InvalidateRect(hWnd, NULL, TRUE);

  DisableMenu();
   
   //hdd=DrawDibOpen();
   return TRUE;
}

//
//  FUNCTION: WndProc(HWND, unsigned, WORD, LONG)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;
	PAINTSTRUCT ps;
	HDC hdc;
	TCHAR szHello[MAX_LOADSTRING];
  HWND hDlg;

	LoadString(hInst, IDS_HELLO, szHello, MAX_LOADSTRING);


	switch (message) 
	{
		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam);

			// HANDLING CUSTOM MENUES
      // LastFiles list
			if(wmId >= 10500 && wmId <=10503)
      {
        rs.profiler->AddNSelect( HidePlayer() );
        DisableMenu();
				if(OpenFile( rs.conf.lastFiles[wmId-10500] ))
        {
          EnableMenu();
          // g_pBackground->Stop();
          rs.pVideoRenderer->StartPlaying();
         // clear jobs
          rs.vBatchList.clear(); 
          ShowPlayer(rs.profiler->GetSelected() );
        }
      }

			// Language
			if(wmId >= 10000 && wmId <10256){
				rs.lng->SetLanguage(wmId-10000);
				SetTextMenu();
			}
			// Plugins
			if(wmId >= 10300 && wmId <(10300+MAX_OUT_PLUGINS) ){
				rs.selected_out_plug = wmId - 10300;
				SetTextMenu();
			}
      // Profiles
			if(wmId >= 10400 && wmId <10499 ){
        rs.profiler->AddNSelect( HidePlayer() );

				rs.profiler->Select( wmId - 10400 );
				rs.prof = *rs.profiler->GetSelected();
				SetTextMenu();

				ShowPlayer(rs.profiler->GetSelected() );
      }

			// Parse the menu selections:
			switch (wmId)
			{

				case IDM_OPENFILE:
					if( OpenFileDialog(rs.openedFileName) )
          { 
            rs.profiler->AddNSelect( HidePlayer() );
            DisableMenu();
            if( OpenFile( rs.openedFileName ) ) 
            {
              EnableMenu();
              // g_pBackground->Stop();
              rs.pVideoRenderer->StartPlaying();
              //rs.video->BuildFrameDB();
              // clear jobs
              rs.vBatchList.clear();
              InsertFileInLastFilesList( rs.openedFileName );
              SetTextMenu();
              ShowPlayer(rs.profiler->GetSelected() );
            }
          }
					break;
				case IDM_MPEG1OPTIONS:
          rs.obOutputManager.ConfigureOutput(rs.selected_out_plug);
          FlushPluginSettings( &rs.plugs );
				  break;
				case IDM_START2:
          rs.profiler->AddNSelect( HidePlayer() );
          TOutputManagerRunInfo omri;

          omri.pJobList = &rs.vBatchList;
          omri.pReport  = &rs.obProgressReportDlg;
          omri.prof = *rs.profiler->GetSelected();

          if(rs.obOutputManager.Run(&omri))
          {
             DisableAllMenu();
             hDlg = CreateDialogParam( hInst, MAKEINTRESOURCE(IDD_PROGRESS), hWnd, 
                                         (DLGPROC)ProgressDlg, (LPARAM)&rs.obOutputManager); 
             // Set as progress report
             rs.obProgressReportDlg.SetDlg(hDlg);

             // Get post processing options from config
             
             TPPost pps;
             FlPostProcess pp;
             FromConfigToPPost( rs.profiler->GetSelected(), &pps, 
                                rs.video->GetWidth(), 
                                rs.video->GetHeight(),
                                rs.video->DAR,
                                FRAME_YV12 );           
             pp.Set( &pps );
             
             WindowClientResize( hMainWnd, pp.GetWidth() , pp.GetHeight() );

             ShowWindow( hDlg, SW_SHOW);
          }
          
					break;
				case IDM_PLAY:
          ShowPlayer(rs.profiler->GetSelected() );				
					break;
				case IDM_AUDIOPLAY:
					break;
				case IDM_OUTPUTCONFIG:
          if( DialogBoxParam(hInst, (LPCTSTR)IDD_OUTPUT_OPTIONS, hWnd, (DLGPROC)OutputOptionsDlg,
              (LPARAM)GetCurrentPlayerSettings() )!=IDCANCEL)
          {
            // Discard player settings here
            HidePlayer();
            SetTextMenu();
            ShowPlayer(rs.profiler->GetSelected() );
          }
					break;
        case IDM_EXTRACTAUDIO:
          rs.profiler->AddNSelect( HidePlayer() );
          ExportAudio();
          ShowPlayer(rs.profiler->GetSelected() );
          break;
				case IDM_ABOUT:
				   DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
				   break;
        case IDM_HOMEPAGE:
           ShellExecute(NULL, "open", "http://go.to/flaskmpeg", NULL, NULL, SW_SHOWNORMAL);
           break;
        case IDM_README:
          ShellExecute(NULL, "open", "./docs/readme.html", NULL, NULL, SW_SHOWNORMAL);
          break;          
				case IDM_EXIT:
           rs.profiler->AddNSelect( HidePlayer() );
				   DestroyWindow(hWnd);
				   break;
				default:
				   return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
		case WM_DROPFILES:
            rs.profiler->AddNSelect( HidePlayer() );
            DisableMenu();
            char dropFileName[MAXFILENAME];

            DragQueryFile( (HDROP)wParam, 0/*first file*/,dropFileName,MAXFILENAME); 


            if(OpenFile(dropFileName))
            {
              EnableMenu();
              // clear jobs
              rs.vBatchList.clear();
              InsertFileInLastFilesList( rs.openedFileName );
              SetTextMenu();
              ShowPlayer(rs.profiler->GetSelected() );            
            }


            break;
    case WM_MOVE:
      // Snap the player at the botton of the main window
      if(rs.hPlayerWnd)
      {
        RECT rcMain;
        GetWindowRect( hMainWnd, &rcMain );
        WindowMove( rs.hPlayerWnd, rcMain.left, rcMain.bottom );
      }
      if( rs.pVideoRenderer ) rs.pVideoRenderer->UpdateOverlay();

      break;
		case WM_PAINT:
			hdc = BeginPaint(hWnd, &ps);
      rs.pVideoRenderer->Update();
			EndPaint(hWnd, &ps);
			break;
		case WM_DESTROY:
      
      rs.profiler->AddNSelect( HidePlayer() );

      // g_pBackground->Stop();

      rs.conf.selected_profile  = rs.profiler->GetSelectedIndex();
			rs.conf.selected_language = rs.lng->GetLanguage();
			rs.conf.outputFormat      = rs.selected_out_plug;
      
      rs.profiler->AddProfile(&rs.prof);

			SaveRegistryConfig(&rs.conf);
			ClosePlugins(&rs.plugs);
      StopMism();

      if( rs.video )
        delete rs.video;
      if( rs.audio )
        delete rs.audio;
      if( rs.pVideoRenderer )
        delete rs.pVideoRenderer;

			PostQuitMessage(0);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
   }
   return 0;
}

// Mesage handler for about box.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
  char szTemp[256];
	switch (message)
	{
		case WM_INITDIALOG:
      // Change the title to current version
      sprintf( szTemp, "FlasKMPEG %d.%d.%d.%d", FLASK_VERSION>>24, 
        (FLASK_VERSION>>16)&0xFF, 
        (FLASK_VERSION>>8)&0xFF,
         FLASK_VERSION&0xFF);
      DlgSetText( hDlg, IDC_ABOUTVERSION, szTemp );
				SetText(hDlg, GS(ABOUT_TITLE) );
				DlgSetText( hDlg, R_ABOUT_GPL, GS(R_ABOUT_GPL) );
				DlgSetText( hDlg, R_ABOUT_TRANSLATOR, GS(R_ABOUT_TRANSLATOR) );
				DlgSetText( hDlg, R_ABOUT_DROPLINE, GS(R_ABOUT_DROPLINE) );
				DlgSetText( hDlg, R_ABOUT_ATHLON, GS(R_ABOUT_ATHLON) );

				return TRUE;

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
			{
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}





