/* 
 *  FlasKMPEG.cpp 
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#include "Filter.h"


static int cc_table[3][3] = { {179,  -151, -28}, {-79, 105, -28}, {-79, -151,  228}};
static int y_table[3] = { 79, 151, 28 };

#define CLAMP(x) (x<0 ? 0 : x>255 ? 255 : x)

void static inline MatrixTransform( int nResult[3], int matrix[3][3], int nInput[3] )
{
  int i,j;
  for( i=0; i<3; i++)
  {
    nResult[i] = 0;
    for(j=0; j<3; j++)
    {
      nResult[i] += matrix[i][j]*nInput[j];
    }
  }
  return;
}

void AdjustSaturation(CFrame *pSrc, CFrame *pDst, ui32 nValue)
{
  int nVal = nValue;

  if( !pDst || !pSrc )
    return;
  // Input Out must match
  ui32 nInFormat = pSrc->GetFormat();
  ui32 nOutFormat = pDst->GetFormat();

  if( nInFormat != nOutFormat )
    return;

  ui32 iw = pSrc->GetWidth();
  ui32 ih = pSrc->GetHeight();
  ui32 ow = pDst->GetWidth();
  ui32 oh = pDst->GetHeight();

  if( iw != ow  ||
      ih != oh )
      return;

  ui32 w = iw;
  ui32 h = ih;  

  //We only accepct RGB and 32bits data.
  if(nInFormat != FRAME_RGB32  && nOutFormat != FRAME_YV12 )
     return;

  switch( nInFormat )
  {
  case FRAME_RGB32:
    {
      ui32 *src = (ui32 *)pSrc->GetBuffer();
      ui32 *dst = (ui32 *)pDst->GetBuffer();
      
      ui32 tot = w * h;
      
      int nResult[3], nInput[3];
      int Y;
      
      
      do
      {
        nInput[0] = *src >> 16;
        nInput[1] = (*src >> 8)&0xFF;
        nInput[2] = *src++ &0xFF;
        
        MatrixTransform( nResult, cc_table, nInput );
        Y = 79*nInput[0] + 151*nInput[1] + 28*nInput[2];
        
        nResult[0] = ((nResult[0] * nVal)/256 + Y)/256;
        nResult[1] = ((nResult[1] * nVal)/256 + Y)/256;
        nResult[2] = ((nResult[2] * nVal)/256 + Y)/256;
        
        *dst++ = (CLAMP(nResult[0]) << 16) |
          (CLAMP(nResult[1]) << 8)  |
          (CLAMP(nResult[2]));
        
      }while(tot--);
      
      break;
      
    }
  case FRAME_YV12:
    {
      // Adjust the chroma planes by nVal (0..255)
      ui8 *src = pSrc->GetBuffer();
      ui8 *dst = pDst->GetBuffer();
      ui32 pitch = w;
      ui32 stride = w>>1;
      
      // Skip Y plane
      // in both, src and dest
      src += w * h;
      dst += w * h;
      
      for(int row=0; row<h; row++)
      {
        for(int col=0; col< stride; col++)
          *dst = ((ui32)*src * nVal)>>8;
        src += pitch;
        dst += pitch;
      }
      
      break;
      
    }
  }




  return;

}