// Canvas.h: interface for the CCanvas class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CANVAS_H__47924CE9_2278_4596_A2B8_EBABA8A5F390__INCLUDED_)
#define AFX_CANVAS_H__47924CE9_2278_4596_A2B8_EBABA8A5F390__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <windows.h>

//uses 32 RGBA format
typedef unsigned __int32 Color32;

typedef struct TRectTag
{
  int nLeft;
  int nTop;
  int nRight;
  int nBottom;
} TRect;



// Origin is defined at top left. Increases downwards and to the right
#define RectWidth(x) (x.nRight - x.nLeft)
#define RectHeight(x) (x.nBottom - x.nTop)
#define FromRECTtoTRect(x)(  *( (TRect *)(&(x))  )  )
#define FromTRectToRECT(x)(  *( (RECT  *)(&(x))  )  )
#define MakeRect(x, top, left, bottom, right){ (x).nTop = top; (x).nLeft = left;  \
                                               (x).nBottom = bottom; (x).nRight = right; }

typedef struct TRectangleTag
{
  TRect   sRect;   // Rect of the rectangle
  bool    bFilled; // Filled
  Color32 nColor;  // Filled color
  int     nBorder; // Border size
  Color32 nBorderColor; // Color of the border

} TRectangle;

typedef struct TPosTag
{
  int nX;
  int nY;
} TPos;

class CCanvas  
{
public:

	CCanvas();
  virtual ~CCanvas(){ Deinitialize();}

  bool Initialize(HWND hWnd, long nWidth, long nHeight);
  bool Deinitialize();

  void DrawCanvas(int nXOffset, int nYOffset);
  void SetCanvasSize(int nWidth, int nHeight)
  {
    m_nWidth = nWidth;
    m_nHeight = nHeight;
  }

  void SetBackground(Color32 nColor)
  {
    TRectangle sRectangle;
    sRectangle.bFilled = true;
    sRectangle.nColor = nColor;

    TRect sRect;
    sRect.nLeft = sRect.nTop = 0;
    sRect.nRight = m_nWidth;
    sRect.nBottom = m_nHeight;

    sRectangle.sRect = sRect;
    DrawFilledRectangle( &sRectangle );
  }

  void DrawRectangle(long nLeft, long nTop, long nRight, long nBottom,  Color32 nColor,
                     long nBorder =0, long nBorderColor =0, bool bFilled = false )
  {
    TRectangle sRectangle;
    sRectangle.bFilled = bFilled;
    sRectangle.nColor = nColor;
    sRectangle.sRect.nBottom = nBottom;
    sRectangle.sRect.nLeft  = nLeft;
    sRectangle.sRect.nRight = nRight;
    sRectangle.sRect.nTop = nTop;

    sRectangle.nBorder = nBorder;
    sRectangle.nBorderColor = nBorderColor;

    DrawRectangle(&sRectangle);
  }
  void DrawRectangle(TRectangle *pRectangle)
  {

      if(pRectangle->bFilled)
        DrawFilledRectangle(pRectangle);

      if(pRectangle->nBorder > 0)
      {
        // border
        TRect rect = pRectangle->sRect;
        TRectangle sRectangle;
        sRectangle.bFilled = true;
        sRectangle.nColor  = pRectangle->nBorderColor;
        sRectangle.nBorder = pRectangle->nBorder;

        // bottom
        sRectangle.sRect = rect;
        sRectangle.sRect.nTop = sRectangle.sRect.nBottom - sRectangle.nBorder;
        DrawFilledRectangle(&sRectangle);
        // top
        sRectangle.sRect = rect;
        sRectangle.sRect.nBottom = sRectangle.sRect.nTop + sRectangle.nBorder;
        DrawFilledRectangle(&sRectangle);
        // left
        sRectangle.sRect = rect;
        sRectangle.sRect.nRight = sRectangle.sRect.nLeft + sRectangle.nBorder;
        DrawFilledRectangle(&sRectangle);
        // right
        sRectangle.sRect = rect;
        sRectangle.sRect.nLeft = sRectangle.sRect.nRight - sRectangle.nBorder;
        DrawFilledRectangle(&sRectangle);
      }
  }
  
  bool DrawText( char *pText, long x, long y, Color32 nColor )
  {
    SetTextColor( m_hDC, nColor );
    
    
    HFONT hfnt, hOldFont; 
    
    hfnt = (HFONT)GetStockObject(ANSI_VAR_FONT); 
    if (hOldFont = (HFONT)SelectObject(m_hDC, hfnt)) 
    { 
      TextOut( m_hDC, x, y, pText, strlen(pText) );
      
      SelectObject(m_hDC, hOldFont); 
    }
    return true;
  }

  bool DrawLine( long x0, long y0, long x1, long y1, Color32 nColor)
  {
    HPEN hpen, hpenOld;
    
    // Create a  pen.
    hpen = CreatePen(PS_SOLID, 1, nColor);
    
    // Select the new pen and brush, and then draw.
    hpenOld = (HPEN )SelectObject(m_hDC, hpen);

    
    MoveToEx(m_hDC, x0, y0, NULL);
    LineTo( m_hDC, x1, y1 );
    
    
    // Do not forget to clean up.
    SelectObject(m_hDC, hpenOld);
    DeleteObject(hpen);
    return true;
  }

  bool DrawRGB32( PBYTE buf, int w, int h, int xoff, int yoff )
  {
    memset( &m_sBitmapInfo, 0, sizeof (BITMAPINFOHEADER) );
    m_sBitmapInfo.bmiHeader.biWidth  = w;
    m_sBitmapInfo.bmiHeader.biHeight = h;
    m_sBitmapInfo.bmiHeader.biCompression = BI_RGB;
    m_sBitmapInfo.bmiHeader.biSize = sizeof (BITMAPINFOHEADER);
    m_sBitmapInfo.bmiHeader.biPlanes = 1;
    m_sBitmapInfo.bmiHeader.biBitCount = (WORD)32;

    SetDIBitsToDevice(m_hDC, 0,0,w, h,0,0,0,h, buf,
      &m_sBitmapInfo, DIB_RGB_COLORS);

    return true;
  }

protected:
  bool m_bInitialized;
  int     m_nWidth, m_nHeight; // Canvas size
  HWND  m_hDrawWnd;  
private:

  // Internal Drawing of rectangle
  void DrawFilledRectangle(TRectangle *pRectangle)
  {
    HPEN hpen, hpenOld;
    HBRUSH hbrush, hbrushOld;
    
    // Create a  pen.
    hpen = CreatePen(PS_SOLID, 1, pRectangle->nColor);
    // Create a brush.
    hbrush = CreateSolidBrush(pRectangle->nColor);
    
    // Select the new pen and brush, and then draw.
    hpenOld = (HPEN )SelectObject(m_hDC, hpen);
    hbrushOld = (HBRUSH )SelectObject(m_hDC, hbrush);
    
    TRect sRect = pRectangle->sRect;
    
    Rectangle( m_hDC, sRect.nLeft, sRect.nTop, 
      sRect.nRight,
      sRect.nBottom );
    
    // Do not forget to clean up.
    SelectObject(m_hDC, hpenOld);
    DeleteObject(hpen);
    SelectObject(m_hDC, hbrushOld);
    DeleteObject(hbrush);
  }

  HDC m_hDC;
  HBITMAP m_hBitmap;
  HGDIOBJ m_hOld;
  BITMAPINFO m_sBitmapInfo;




};

#endif // !defined(AFX_CANVAS_H__47924CE9_2278_4596_A2B8_EBABA8A5F390__INCLUDED_)
