// Canvas.cpp: implementation of the CCanvas class.
//
//////////////////////////////////////////////////////////////////////


#include "Canvas.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

const int nMaxCanvasSize = 256;
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CCanvas::CCanvas()
{
  m_hDrawWnd = NULL;
  m_nHeight = m_nWidth = nMaxCanvasSize;
  m_bInitialized = false;
  m_hDC = NULL;
}

bool CCanvas::Initialize(HWND hWnd, long nWidth, long nHeight)
{  
  m_hDrawWnd = hWnd;
  m_nHeight = nHeight;
  m_nWidth = nWidth;

  if(m_bInitialized)
    Deinitialize();

  // Create a compatible device context
  HDC hDC = GetDC(m_hDrawWnd);
  
  m_hDC = CreateCompatibleDC( hDC );


  // Create our bitmap for the memory DC
  m_hBitmap = CreateCompatibleBitmap( hDC, nWidth, nHeight );
  if(!m_hBitmap)
    return false;

  ::ReleaseDC(m_hDrawWnd, hDC);

  if(!m_hDC)
    return false;



  // Select the bitmap in the device context
  m_hOld = SelectObject( m_hDC, m_hBitmap );

  // Set Defaults
  SetBkMode(m_hDC, TRANSPARENT);

  m_bInitialized = true;
  return true;
}

bool CCanvas::Deinitialize()
{
  SelectObject( m_hDC, m_hOld );
  DeleteObject( m_hBitmap );
  DeleteDC( m_hDC );  
  m_bInitialized = false;
  return true;
}

void CCanvas::DrawCanvas(int nXOffset, int nYOffset)
{
  if(!m_bInitialized)
    return;

  HDC hDC;
  hDC = GetDC(m_hDrawWnd);

  BitBlt( hDC, 0, 0, m_nWidth, m_nHeight, 
          m_hDC, 0, 0, SRCCOPY );

  ::ReleaseDC( m_hDrawWnd, hDC );
}