/* 
 *  Background.cpp 
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#include "Background.h"
#include "Filter.h"
#include <math.h>

#define M_PI 3.141592



void CBackground::Start( CVideoRenderer *pVideoRenderer, CFrame *pImage )
{
  if( !pVideoRenderer|| !pImage )
    return;

  m_pVideoRenderer = pVideoRenderer;
  m_frDest = m_frImage = *pImage;

  Create();
}

void CBackground::Stop()
{
  m_pVideoRenderer->StopPlaying();
  Exit();
}

DWORD CBackground::ThreadProc()
{

  ui64 nCommandResult=0;
  TCommand sCommand;
  ui8 nSaturation = 0;
  double nPhase = 0;

  // If no video renderer assigned
  // end thread
  if( !m_pVideoRenderer )
    return 0;

  m_pVideoRenderer->StartPlaying();
  

  // Adapt destination format to the one of the renderer
  int w = m_frDest.GetWidth();
  int h = m_frDest.GetHeight();
  int format = m_pVideoRenderer->GetFormat();
  //m_frDest.Set( w, h, format, format == FRAME_RGB ? 32 : 0, 0);
  //m_frDest.SetFrame( &m_frImage );


  while( 1 )
  {
    if(GetCommand(&sCommand))
    {
      switch( sCommand.nCommand )
      {
      case noCommand:
        break;
      case exit:
        ReplyCommand(&sCommand, nCommandResult);
        return 0;
        break;
      }
      ReplyCommand(&sCommand, nCommandResult);
    }
    
    nPhase += M_PI / 256.0;
    nSaturation = 200*((1 + cos(nPhase))/2.0);
    // Processing loop
    AdjustSaturation( &m_frImage, &m_frDest, nSaturation );
    
    if(nSaturation!=1)
      nSaturation -= 2;


    // Draw
    m_pVideoRenderer->Draw(&m_frDest);

    Sleep(20);
  }

  return 0;
}