/* 
 *  Auxiliary.cpp
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include <windows.h>
#include <commctrl.h>
#include "auxiliary.h"
#include "resource.h"
#include "stdio.h"
#include <math.h>



int GetOutputFileName(HWND hWnd, char* fileName,char* Dir, char* Title){
	OPENFILENAME oifn;
		// Initialize OPENFILENAME
		ZeroMemory(&oifn, sizeof(OPENFILENAME));
		oifn.lStructSize = sizeof(OPENFILENAME);
		oifn.hwndOwner = hWnd;
		oifn.lpstrFile = fileName;
		oifn.nMaxFile = 1024;
		oifn.lpstrFilter = "";
		oifn.nFilterIndex = 1;
		oifn.lpstrFileTitle = NULL;
		oifn.lpstrTitle = Title;
		oifn.nMaxFileTitle = 0;
		oifn.lpstrInitialDir = Dir;
		oifn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;
		if(!GetSaveFileName(&oifn))
			return 0;
		return 1;
}

HWND CreateNormalWindow(WNDPROC WndProc, HINSTANCE hInstance, HWND hParent){
		
   return CreateDialog(hInstance, MAKEINTRESOURCE(IDD_DISPLAY), hParent, (DLGPROC)WndProc);
	

}

void WindowShow(HWND hWnd){
	ShowWindow(hWnd, SW_SHOW);
}
void WindowHide(HWND hWnd){
	ShowWindow(hWnd, SW_HIDE);
}

void WindowResize(HWND window, int w, int h){
	RECT rc;
	GetWindowRect(window, &rc);
	MoveWindow(window, rc.left, rc.top, w, h , TRUE);
}

void WindowClientResize(HWND window, int w, int h){
	RECT rc;
	SetRect(&rc, 0, 0, w, h);
	AdjustWindowRectEx(&rc,GetWindowLong(window,GWL_STYLE), (int)GetMenu(window), GetWindowLong(window,GWL_EXSTYLE) );
	WindowResize(window, rc.right-rc.left, rc.bottom - rc.top);
	
}

void WindowMove(HWND window, int x, int y){
  SetWindowPos( window, NULL, x, y, 0, 0, SWP_NOACTIVATE|SWP_NOZORDER|SWP_NOSIZE);
}
void SetText(HWND hWnd, char *text){
	if(text==NULL)
		return;
	SendMessage(hWnd, WM_SETTEXT, 0, (LPARAM)text);
}
void MenuSetText(HMENU hMenu,int item ,char *text ){
	MENUITEMINFO item_info;

	if(text==NULL)
		return;

	item_info.cbSize = sizeof(item_info);
//	item_info.fMask  = MIIM_DATA|MIIM_ID|MIIM_STATE|MIIM_SUBMENU|MIIM_TYPE; 
//	GetMenuItemInfo( hMenu, item, TRUE, &item_info);

	item_info.fMask  = MIIM_TYPE; 
	item_info.fType         = MFT_STRING;
	item_info.dwTypeData    = text;
	SetMenuItemInfo( hMenu, item, TRUE, &item_info);

}

void MenuAddItem(HMENU hMenu,int item , int wID,char *text){
	MENUITEMINFO item_info;

	if(text==NULL)
		return;

	item_info.cbSize = sizeof(item_info);

	item_info.fMask  = MIIM_TYPE|MIIM_ID; 
	item_info.fType         = MFT_STRING;
	item_info.dwTypeData    = text;
	item_info.wID           = wID;
	InsertMenuItem( hMenu, item, TRUE, &item_info);
}

void MenuAddSeparator(HMENU hMenu,int item ){
	MENUITEMINFO item_info;

	item_info.cbSize = sizeof(item_info);

	item_info.fMask  = MIIM_TYPE; 
	item_info.fType         = MFT_SEPARATOR;

	InsertMenuItem( hMenu, item, TRUE, &item_info);
}

HMENU MenuGetPopup( HMENU hMenu, int item ){
	MENUITEMINFO item_info;

	item_info.cbSize = sizeof(item_info);
	item_info.fMask  = MIIM_SUBMENU; 
	GetMenuItemInfo( hMenu, item, TRUE, &item_info);
	return item_info.hSubMenu;

}
void MenuCheck(HWND hWnd, int item)
{
	CheckMenuItem(GetMenu(hWnd),item, MF_CHECKED);
}
void MenuUnCheck(HWND hWnd, int item)
{
	CheckMenuItem(GetMenu(hWnd),item, MF_UNCHECKED);
 
}
void MenuEnable(HWND hWnd, int item)
{
	EnableMenuItem(GetMenu(hWnd), item, MF_ENABLED);
}
void MenuDisable(HWND hWnd, int item)
{
	EnableMenuItem(GetMenu(hWnd), item, MF_GRAYED);
}
void MenuSetText(HWND hWnd, int item){

}
void TabSetText(HWND hTab, int item, char *text){
	TCITEM props;

	if(text==NULL)
		return;
	
	props.mask    = TCIF_TEXT;
	props.pszText = text;
	SendMessage( hTab, TCM_SETITEM, (WPARAM) item, (LPARAM)&props);

}
void DlgSetFocus(HWND hDlg, int control){
	SetFocus(GetDlgItem(hDlg, control));
}

void DlgAttachToolTip(HINSTANCE hInst, HWND hDlg, int nId, char *pTitle, char *pText)
{
  AttachTooltip( hInst, GetDlgItem(hDlg, nId ), pTitle, pText);
}
/* CREATE A TOOLTIP CONTROL OVER THE ENTIRE WINDOW AREA */
void AttachTooltip (HINSTANCE hInst, HWND hwnd, char *pTitle, char *pText)
{
  // struct specifying control classes to register
  INITCOMMONCONTROLSEX iccex; 
  HWND hwndTT;                 // handle to the ToolTip control
  // struct specifying info about tool in ToolTip control
  TOOLINFO ti;
  unsigned int uid = 0;       // for ti initialization

  LPTSTR lptstr = pText;
  RECT rect;                  // for client area coordinates
  
  /* INITIALIZE COMMON CONTROLS */
  iccex.dwICC = ICC_WIN95_CLASSES;
  iccex.dwSize = sizeof(INITCOMMONCONTROLSEX);
  InitCommonControlsEx(&iccex);
  
  /* CREATE A TOOLTIP WINDOW */
  hwndTT = CreateWindowEx(WS_EX_TOPMOST,
    TOOLTIPS_CLASS,
    NULL,
    WS_POPUP | TTS_NOPREFIX | TTS_BALLOON,		
    CW_USEDEFAULT,
    CW_USEDEFAULT,
    CW_USEDEFAULT,
    CW_USEDEFAULT,
    hwnd,
    NULL,
    hInst,
    NULL
    );
  
  SetWindowPos(hwndTT,
    HWND_TOPMOST,
    0,
    0,
    0,
    0,
    SWP_NOMOVE | SWP_NOSIZE | SWP_NOACTIVATE);
  
  /* GET COORDINATES OF THE MAIN CLIENT AREA */
  GetClientRect (hwnd, &rect);
  
  /* INITIALIZE MEMBERS OF THE TOOLINFO STRUCTURE */
  ti.cbSize = sizeof(TOOLINFO);
  ti.uFlags = TTF_SUBCLASS | TTF_IDISHWND ;
  ti.hwnd = hwnd;
  ti.hinst = hInst;
  ti.uId = (UINT_PTR)hwnd;
  ti.lpszText = pText;
  // ToolTip control will cover the whole window
  ti.rect = rect;    
  
  /* SEND AN ADDTOOL MESSAGE TO THE TOOLTIP CONTROL WINDOW */
  SendMessage(hwndTT, TTM_ADDTOOL, 0, (LPARAM) (LPTOOLINFO) &ti);
  SendMessage(hwndTT, TTM_SETTITLE, 1, (LPARAM) pTitle);
} 

void DlgCheck(HWND hDlg, int item, bool check)
{
  SendDlgItemMessage( hDlg, item, BM_SETCHECK, check ? BST_CHECKED:BST_UNCHECKED ,0);
}

void DlgCheck(HWND hDlg, int item){

	SendDlgItemMessage( hDlg, item, BM_SETCHECK, BST_CHECKED ,0);
}

void DlgUnCheck(HWND hDlg, int item){
	SendDlgItemMessage( hDlg, item, BM_SETCHECK, BST_UNCHECKED ,0);
}

bool DlgIsChecked(HWND hDlg, int item){
	return (SendDlgItemMessage( hDlg, item, BM_GETCHECK, 0, 0)==BST_CHECKED);
}

void DlgEnable(HWND hDlg, int item, bool enable)
{
	 EnableWindow( GetDlgItem(hDlg, item), enable); 
}

void DlgEnable(HWND hDlg, int item){
	 EnableWindow( GetDlgItem(hDlg, item), true); 
}
void DlgDisable(HWND hDlg, int item){
		 EnableWindow( GetDlgItem(hDlg, item), false); 
}


char *DlgGetText( HWND hDlg, int item, char* text){
	if(text==NULL)
		return NULL;

	GetDlgItemText( hDlg, item, text, 1024);
	return text;
}
int DlgGetText( HWND hDlg, int item){
	char szTemp[1024];
	GetDlgItemText( hDlg, item, szTemp, 1024);
	return atoi(szTemp);
}
void DlgSetText(HWND hDlg, int item, int number){

	char szTemp[1024];
	SetDlgItemText(hDlg, item, itoa(number, szTemp, 10));
}
void DlgSetDouble(HWND hDlg, int item, double number){
	char szTemp[1024];
	sprintf(szTemp, "%.2f", number);
	SetDlgItemText(hDlg, item, szTemp);
}

void DlgSetText(HWND hDlg, int item, char* text){
	if(text==NULL)
		return;

	SetDlgItemText(hDlg, item, text);
}

int DlgGetInt(HWND hDlg, int item){
	char szTemp[1024];
	GetDlgItemText( hDlg, item, szTemp, 1024);	
	return atoi(szTemp);
}

void DlgCheckBoxState(HWND hDlg, int item, int state)
{
	if(state)
		DlgCheck(hDlg, item);
	else
		DlgUnCheck(hDlg, item);
}
// LIST BOXES
void ListAddText(HWND list, char *text){
	SendMessage(list, CB_ADDSTRING, 0, (LPARAM) text);
}
void ListClean(HWND list)
{
    SendMessage(list, CB_RESETCONTENT, 0, 0);
    return;
}
int ListGetCur(HWND list){
	return  SendMessage(list, CB_GETCURSEL, 0,0);
}
void ListSetCur(HWND list, int cur){
	SendMessage(list, CB_SETCURSEL, cur, 0);
}
void MillisecondsToTime( char *str, DWORD time)
{

	//Me pasan el tiempo que tengo que formatear en milisegundos
	int segundos, minutos, horas;
	if(str==NULL) return;
	segundos= (int)floor(time/1000);
	segundos=segundos%60;
	minutos= (int)floor(time/60000);
	minutos= minutos%60;
	horas=   (int)floor((double)time/3600000);
	if (minutos <=9)
		if (segundos<=9)
			sprintf( str, "%d:0%d:0%d", horas, minutos, segundos);
		else
			sprintf( str, "%d:0%d:%d", horas, minutos, segundos);
	else
		if (segundos<=9)
			sprintf( str, "%d:%d:0%d", horas, minutos, segundos);
		else
			sprintf( str, "%d:%d:%d", horas, minutos, segundos);

	return;
}

// takes the local time, adds msec milliseconds to it and writes a
// string with the resulting time in hh:mm:ss format 
// Sorry ((former) colonies of the) Brittish, none of that am/pm nonsense,
// just good old 24hr format.
void LocalTimePlusMilliseconds(char *str, DWORD msec, bool show_seconds)
{
	SYSTEMTIME loctime;
	GetLocalTime(&loctime);
	int hr,min,sec;
	sec = loctime.wSecond + msec / 1000;
	min = loctime.wMinute + sec / 60;
	sec = sec % 60;
	hr = loctime.wHour + min / 60;
	min = min % 60;
	hr = hr % 24;
	if (show_seconds)
		sprintf(str, "%d:%02d:%02d", hr, min, sec);
	else
		sprintf(str, "%d:%02d", hr, min);
}

void StringFrameRate(int fr, char *sFrameRate)
{
		switch( fr )
    {
    case 23976://24000/1001
      strcpy(sFrameRate, "FILM at 23.976 fps");
      break;
    case 24:
      strcpy(sFrameRate, "FILM at 24 fps");
      break;
    case 25:
      strcpy(sFrameRate, "PAL at 25 fps");
      break;
    case 2997:
      strcpy(sFrameRate, "NTSC at 29.97 fps");
      break;
    case 30:
      strcpy(sFrameRate, "NTSC at 30 fps");
      break;
    default:
      strcpy(sFrameRate, "unknown");
    }
}

#define isvalidchar(c) (((c>=65 && c<=90) ||  (c>=97 && c<=122)  || (c>=48 && c<=57)))

// Make a file name, valid for the file system
bool validateFileName( char *filename )
{
  int len = strlen( filename );
  char *i, *o;
  
  i = o = filename;
  while(len--)
  {
    if( isvalidchar(*i) )
      *o++ = *i;
    *i++;
  }
  *o=0;

  return i==o;
}
