// Resampler.h: interface for the CResampler class.
/* 
 *  Resampler.h
 * 
 *  Original code from Julius O. Smith III< jos@ccrma.stanford.edu>
 *
 *	Copyright (C) Alberto Vigata - January 2000
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#if !defined(AFX_RESAMPLER_H__00FC5C61_A4AA_11D2_94DE_00000100CF13__INCLUDED_)
#define AFX_RESAMPLER_H__00FC5C61_A4AA_11D2_94DE_00000100CF13__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
/*
 * FILE: resample.h
 *
 * The configuration constants below govern
 * the number of bits in the input sample and filter coefficients, the 
 * number of bits to the right of the binary-point for fixed-point math, etc.
 *
 */

#include "stdefs.h"

#include "..\..\ASyncBuffer.h"

#define IBUFFSIZE 4096                         /* Input buffer size */
#include "smallfilter.h"
#include "largefilter.h"

/* Conversion constants */
#define Nhc       8
#define Na        7
#define Np       (Nhc+Na)
#define Npc      (1<<Nhc)
#define Amask    ((1<<Na)-1)
#define Pmask    ((1<<Np)-1)
#define Nh       16
#define Nb       16
#define Nhxn     14
#define Nhg      (Nh-Nhxn)
#define NLpScl   13

/* Description of constants:
 *
 * Npc - is the number of look-up values available for the lowpass filter
 *    between the beginning of its impulse response and the "cutoff time"
 *    of the filter.  The cutoff time is defined as the reciprocal of the
 *    lowpass-filter cut off frequence in Hz.  For example, if the
 *    lowpass filter were a sinc function, Npc would be the index of the
 *    impulse-response lookup-table corresponding to the first zero-
 *    crossing of the sinc function.  (The inverse first zero-crossing
 *    time of a sinc function equals its nominal cutoff frequency in Hz.)
 *    Npc must be a power of 2 due to the details of the current
 *    implementation. The default value of 512 is sufficiently high that
 *    using linear interpolation to fill in between the table entries
 *    gives approximately 16-bit accuracy in filter coefficients.
 *
 * Nhc - is log base 2 of Npc.
 *
 * Na - is the number of bits devoted to linear interpolation of the
 *    filter coefficients.
 *
 * Np - is Na + Nhc, the number of bits to the right of the binary point
 *    in the integer "time" variable. To the left of the point, it indexes
 *    the input array (X), and to the right, it is interpreted as a number
 *    between 0 and 1 sample of the input X.  Np must be less than 16 in
 *    this implementation.
 *
 * Nh - is the number of bits in the filter coefficients. The sum of Nh and
 *    the number of bits in the input data (typically 16) cannot exceed 32.
 *    Thus Nh should be 16.  The largest filter coefficient should nearly
 *    fill 16 bits (32767).
 *
 * Nb - is the number of bits in the input data. The sum of Nb and Nh cannot
 *    exceed 32.
 *
 * Nhxn - is the number of bits to right shift after multiplying each input
 *    sample times a filter coefficient. It can be as great as Nh and as
 *    small as 0. Nhxn = Nh-2 gives 2 guard bits in the multiply-add
 *    accumulation.  If Nhxn=0, the accumulation will soon overflow 32 bits.
 *
 * Nhg - is the number of guard bits in mpy-add accumulation (equal to Nh-Nhxn)
 *
 * NLpScl - is the number of bits allocated to the unity-gain normalization
 *    factor.  The output of the lowpass filter is multiplied by LpScl and
 *    then right-shifted NLpScl bits. To avoid overflow, we must have 
 *    Nb+Nhg+NLpScl < 32.
 */

class CResampler: public CDataSource
{
public:

	double factor;

	CResampler();
	CResampler(    double factor,		/* factor = Sndout/Sndin */
					int nChans,			    /* number of sound channels (1 or 2) */
					CAsyncBuffer *ABuffer	/* Buffer to read data from */  
	);
	void ResampleFastStart();
	void ResampleFastStop();
	int read(char *buffer);
	virtual ~CResampler();
int Resample(			/* number of output sample returned */
    BOOL interpFilt,		/* TRUE means interpolate filter coeffs */
    int fastMode,		/* 0 = highest quality, slowest speed */
    BOOL largeFilter		/* TRUE means use 65-tap FIR filter */
);

private:
	//RESAMPLE FAST
    URWORD Time, Time2;		/* Current time/pos in input sample */
    UHRWORD Xp, Ncreep, Xoff, Xread;
	int OBUFFSIZE;
    HRWORD X1[IBUFFSIZE]; /* I/O buffers */
    HRWORD X2[IBUFFSIZE]; /* I/O buffers */
	HRWORD *Y1;
	HRWORD *Y2;

    UHRWORD Nout, Nx;
    int i, Ycount, last;


	CAsyncBuffer *ABuffer;
	unsigned int framecount;
	int eosFlag;
	int nChans;
	int outCount;
	int inCount;

int ResampleWithFilter(  /* number of output samples returned */
    BOOL interpFilt,		/* TRUE means interpolate filter coeffs */
    HRWORD Imp[], HRWORD ImpD[],
    UHRWORD LpScl, UHRWORD Nmult, UHRWORD Nwing);
int ResampleFast( short *oData );

int err_ret(char *s);


int SrcUD(HRWORD X[], HRWORD Y[], double factor, URWORD *Time,
		 UHRWORD Nx, UHRWORD Nwing, UHRWORD LpScl,
		 HRWORD Imp[], HRWORD ImpD[], BOOL Interp);

int SrcUp(HRWORD X[], HRWORD Y[], double factor, URWORD *Time,
		 UHRWORD Nx, UHRWORD Nwing, UHRWORD LpScl,
		 HRWORD Imp[], HRWORD ImpD[], BOOL Interp);
int 
  SrcLinear(HRWORD X[], HRWORD Y[], double factor, URWORD *Time, UHRWORD Nx);

INLINE HRWORD RWORDToHRWORD(RWORD v, int scl);
int readData(
         HRWORD *outPtr1,      /* array receiving left chan samps */
         HRWORD *outPtr2,      /* array receiving right chan samps */
         int   dataArraySize, /* size of these arrays */
         int   Xoff) ;
RWORD FilterUD( HRWORD Imp[], HRWORD ImpD[],
		     UHRWORD Nwing, BOOL Interp,
		     HRWORD *Xp, HRWORD Ph, HRWORD Inc, UHRWORD dhb);
RWORD FilterUp(HRWORD Imp[], HRWORD ImpD[], 
					     UHRWORD Nwing, BOOL Interp,
					     HRWORD *Xp, HRWORD Ph, HRWORD Inc);
	void write(int samples,HRWORD *Y1, HRWORD *Y2);
	void write(int samples, HRWORD *Y1, HRWORD *Y2, short *oData);
};

#endif // !defined(AFX_RESAMPLER_H__00FC5C61_A4AA_11D2_94DE_00000100CF13__INCLUDED_)
