#include <crtdbg.h>
#include "AMPDecoder.h"

typedef unsigned char byte;

const byte hufftbl_1[][2]={
	0x02, 0x01, 0x00, 0x00, 0x02, 0x01, 0x00, 0x10, 0x02, 0x01, 0x00, 0x01, 0x00, 0x11, 
};

const byte hufftbl_2[][2]={
	0x02, 0x01, 0x00, 0x00, 0x04, 0x01, 0x02, 0x01, 0x00, 0x10, 0x00, 0x01, 0x02, 0x01, 0x00, 0x11, 0x04, 0x01, 0x02, 0x01, 0x00, 0x20, 0x00, 0x21, 
	0x02, 0x01, 0x00, 0x12, 0x02, 0x01, 0x00, 0x02, 0x00, 0x22, 
};

const byte hufftbl_3[][2]={
	0x04, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x01, 0x02, 0x01, 0x00, 0x11, 0x02, 0x01, 0x00, 0x10, 0x04, 0x01, 0x02, 0x01, 0x00, 0x20, 0x00, 0x21, 
	0x02, 0x01, 0x00, 0x12, 0x02, 0x01, 0x00, 0x02, 0x00, 0x22, 
};

const byte hufftbl_5[][2]={
	0x02, 0x01, 0x00, 0x00, 0x04, 0x01, 0x02, 0x01, 0x00, 0x10, 0x00, 0x01, 0x02, 0x01, 0x00, 0x11, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x20, 
	0x00, 0x02, 0x02, 0x01, 0x00, 0x21, 0x00, 0x12, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x22, 0x00, 0x30, 0x02, 0x01, 0x00, 0x03, 0x00, 0x13, 
	0x02, 0x01, 0x00, 0x31, 0x02, 0x01, 0x00, 0x32, 0x02, 0x01, 0x00, 0x23, 0x00, 0x33, 
};

const byte hufftbl_6[][2]={
	0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x10, 0x00, 0x11, 0x06, 0x01, 0x02, 0x01, 0x00, 0x01, 0x02, 0x01, 0x00, 0x20, 0x00, 0x21, 
	0x06, 0x01, 0x02, 0x01, 0x00, 0x12, 0x02, 0x01, 0x00, 0x02, 0x00, 0x22, 0x04, 0x01, 0x02, 0x01, 0x00, 0x31, 0x00, 0x13, 0x04, 0x01, 0x02, 0x01, 
	0x00, 0x30, 0x00, 0x32, 0x02, 0x01, 0x00, 0x23, 0x02, 0x01, 0x00, 0x03, 0x00, 0x33, 
};

const byte hufftbl_7[][2]={
	0x02, 0x01, 0x00, 0x00, 0x04, 0x01, 0x02, 0x01, 0x00, 0x10, 0x00, 0x01, 0x08, 0x01, 0x02, 0x01, 0x00, 0x11, 0x04, 0x01, 0x02, 0x01, 0x00, 0x20, 
	0x00, 0x02, 0x00, 0x21, 0x12, 0x01, 0x06, 0x01, 0x02, 0x01, 0x00, 0x12, 0x02, 0x01, 0x00, 0x22, 0x00, 0x30, 0x04, 0x01, 0x02, 0x01, 0x00, 0x31, 
	0x00, 0x13, 0x04, 0x01, 0x02, 0x01, 0x00, 0x03, 0x00, 0x32, 0x02, 0x01, 0x00, 0x23, 0x00, 0x04, 0x0a, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x40, 
	0x00, 0x41, 0x02, 0x01, 0x00, 0x14, 0x02, 0x01, 0x00, 0x42, 0x00, 0x24, 0x0c, 0x01, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x33, 0x00, 0x43, 
	0x00, 0x50, 0x04, 0x01, 0x02, 0x01, 0x00, 0x34, 0x00, 0x05, 0x00, 0x51, 0x06, 0x01, 0x02, 0x01, 0x00, 0x15, 0x02, 0x01, 0x00, 0x52, 0x00, 0x25, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0x44, 0x00, 0x35, 0x04, 0x01, 0x02, 0x01, 0x00, 0x53, 0x00, 0x54, 0x02, 0x01, 0x00, 0x45, 0x00, 0x55, 
};

const struct HuffQuad {
	signed char x, y;
	byte bits;
	byte _pad;
} hufftbl_1_fast[32]={	// maximum: 5 bits
	/* 00000 */ { +1, +1, 5 },
	/* 00001 */ { +1, -1, 5 },
	/* 00010 */ { -1, +1, 5 },
	/* 00011 */ { -1, -1, 5 },
	/* 0010x */ {  0, +1, 4 },	{ 0, +1, 4 },
	/* 0011x */ {  0, -1, 4 },	{ 0, -1, 4 },
	/* 010xx */ { +1,  0, 3 },	{ +1,  0, 3 },	{ +1,  0, 3 },	{ +1,  0, 3 },
	/* 011xx */ { -1,  0, 3 },	{ -1,  0, 3 },	{ -1,  0, 3 },	{ -1,  0, 3 },
	/* 1xxxx */ {  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },
				{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },
				{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },
				{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },
}, hufftbl_2_lo[28]={
	/* 00100 */	{ +1, +1, 5 },
	/* 00101 */	{ +1, -1, 5 },
	/* 00110 */	{ -1, +1, 5 },
	/* 00111 */	{ -1, -1, 5 },
	/* 0100x */ {  0, +1, 4 },	{  0, +1, 4 },
	/* 0101x */ {  0, -1, 4 },	{  0, -1, 4 },
	/* 0110x */ { +1,  0, 4 },	{ +1,  0, 4 },
	/* 0111x */ { -1,  0, 4 },	{ -1,  0, 4 },
	/* 1xxxx */	{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },
				{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },
				{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },
				{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },	{  0,  0, 1 },
}, hufftbl_2_3_hi[32]={
	/* 00000000 */ { +2, +2, 8 },
	/* 00000001 */ { +2, -2, 8 },
	/* 00000010 */ { -2, +2, 8 },
	/* 00000011 */ { -2, -2, 8 },
	/* 0000010x */ {  0, +2, 7 }, {  0, +2, 7 },
	/* 0000011x */ {  0, -2, 7 }, {  0, -2, 7 },
	/* 0000100x */ { +1, +2, 7 }, { +1, +2, 7 },
	/* 0000101x */ { +1, -2, 7 }, { +1, -2, 7 },
	/* 0000110x */ { -1, +2, 7 }, { -1, +2, 7 },
	/* 0000111x */ { -1, -2, 7 }, { -1, -2, 7 },
	/* 0001000x */ { +2, +1, 7 }, { +2, +1, 7 },
	/* 0001001x */ { +2, -1, 7 }, { +2, -1, 7 },
	/* 0001010x */ { -2, +1, 7 }, { -2, +1, 7 },
	/* 0001011x */ { -2, -1, 7 }, { -2, -1, 7 },
	/* 000110xx */ { +2,  0, 6 }, { +2,  0, 6 }, { +2,  0, 6 }, { +2,  0, 6 },
	/* 000111xx */ { -2,  0, 6 }, { -2,  0, 6 }, { -2,  0, 6 }, { -2,  0, 6 },
}, hufftbl_3_lo[28]={
	/* 0010x */ { +1,  0, 4 }, { +1,  0, 4 },
	/* 0011x */ { -1,  0, 4 }, { -1,  0, 4 },
	/* 0100x */	{ +1, +1, 4 }, { +1, +1, 4 },
	/* 0101x */	{ +1, -1, 4 }, { +1, -1, 4 },
	/* 0110x */	{ -1, +1, 4 }, { -1, +1, 4 },
	/* 0111x */	{ -1, -1, 4 }, { -1, -1, 4 },
	/* 100xx */ {  0, +1, 3 }, {  0, +1, 3 }, {  0, +1, 3 }, {  0, +1, 3 },
	/* 101xx */ {  0, -1, 3 }, {  0, -1, 3 }, {  0, -1, 3 }, {  0, -1, 3 },
	/* 11xxx */	{  0,  0, 2 }, {  0,  0, 2 }, {  0,  0, 2 }, {  0,  0, 2 },
				{  0,  0, 2 }, {  0,  0, 2 }, {  0,  0, 2 }, {  0,  0, 2 },
};

/////////////////////////////////////////////////////////////

const byte hufftbl_8[][2]={
	0x06, 0x01, 0x02, 0x01, 0x00, 0x00, 0x02, 0x01, 0x00, 0x10, 0x00, 0x01, 0x02, 0x01, 0x00, 0x11, 0x04, 0x01, 0x02, 0x01, 0x00, 0x21, 0x00, 0x12, 
	0x0e, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x20, 0x00, 0x02, 0x02, 0x01, 0x00, 0x22, 0x04, 0x01, 0x02, 0x01, 0x00, 0x30, 0x00, 0x03, 0x02, 0x01, 
	0x00, 0x31, 0x00, 0x13, 0x0e, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x32, 0x00, 0x23, 0x02, 0x01, 0x00, 0x40, 0x00, 0x04, 0x02, 0x01, 
	0x00, 0x41, 0x02, 0x01, 0x00, 0x14, 0x00, 0x42, 0x0c, 0x01, 0x06, 0x01, 0x02, 0x01, 0x00, 0x24, 0x02, 0x01, 0x00, 0x33, 0x00, 0x50, 0x04, 0x01, 
	0x02, 0x01, 0x00, 0x43, 0x00, 0x34, 0x00, 0x51, 0x06, 0x01, 0x02, 0x01, 0x00, 0x15, 0x02, 0x01, 0x00, 0x05, 0x00, 0x52, 0x06, 0x01, 0x02, 0x01, 
	0x00, 0x25, 0x02, 0x01, 0x00, 0x44, 0x00, 0x35, 0x02, 0x01, 0x00, 0x53, 0x02, 0x01, 0x00, 0x45, 0x02, 0x01, 0x00, 0x54, 0x00, 0x55, 
};

const byte hufftbl_9[][2]={
	0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x10, 0x02, 0x01, 0x00, 0x01, 0x00, 0x11, 0x0a, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x20, 
	0x00, 0x21, 0x02, 0x01, 0x00, 0x12, 0x02, 0x01, 0x00, 0x02, 0x00, 0x22, 0x0c, 0x01, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x30, 0x00, 0x03, 
	0x00, 0x31, 0x02, 0x01, 0x00, 0x13, 0x02, 0x01, 0x00, 0x32, 0x00, 0x23, 0x0c, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x41, 0x00, 0x14, 0x04, 0x01, 
	0x02, 0x01, 0x00, 0x40, 0x00, 0x33, 0x02, 0x01, 0x00, 0x42, 0x00, 0x24, 0x0a, 0x01, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x04, 0x00, 0x50, 
	0x00, 0x43, 0x02, 0x01, 0x00, 0x34, 0x00, 0x51, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x15, 0x00, 0x52, 0x02, 0x01, 0x00, 0x25, 0x00, 0x44, 
	0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x05, 0x00, 0x54, 0x00, 0x53, 0x02, 0x01, 0x00, 0x35, 0x02, 0x01, 0x00, 0x45, 0x00, 0x55, 
};

const byte hufftbl_10[][2]={
	0x02, 0x01, 0x00, 0x00, 0x04, 0x01, 0x02, 0x01, 0x00, 0x10, 0x00, 0x01, 0x0a, 0x01, 0x02, 0x01, 0x00, 0x11, 0x04, 0x01, 0x02, 0x01, 0x00, 0x20, 
	0x00, 0x02, 0x02, 0x01, 0x00, 0x21, 0x00, 0x12, 0x1c, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x22, 0x00, 0x30, 0x02, 0x01, 0x00, 0x31, 
	0x00, 0x13, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x03, 0x00, 0x32, 0x02, 0x01, 0x00, 0x23, 0x00, 0x40, 0x04, 0x01, 0x02, 0x01, 0x00, 0x41, 
	0x00, 0x14, 0x04, 0x01, 0x02, 0x01, 0x00, 0x04, 0x00, 0x33, 0x02, 0x01, 0x00, 0x42, 0x00, 0x24, 0x1c, 0x01, 0x0a, 0x01, 0x06, 0x01, 0x04, 0x01, 
	0x02, 0x01, 0x00, 0x50, 0x00, 0x05, 0x00, 0x60, 0x02, 0x01, 0x00, 0x61, 0x00, 0x16, 0x0c, 0x01, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x43, 
	0x00, 0x34, 0x00, 0x51, 0x02, 0x01, 0x00, 0x15, 0x02, 0x01, 0x00, 0x52, 0x00, 0x25, 0x04, 0x01, 0x02, 0x01, 0x00, 0x26, 0x00, 0x36, 0x00, 0x71, 
	0x14, 0x01, 0x08, 0x01, 0x02, 0x01, 0x00, 0x17, 0x04, 0x01, 0x02, 0x01, 0x00, 0x44, 0x00, 0x53, 0x00, 0x06, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 
	0x00, 0x35, 0x00, 0x45, 0x00, 0x62, 0x02, 0x01, 0x00, 0x70, 0x02, 0x01, 0x00, 0x07, 0x00, 0x64, 0x0e, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x72, 
	0x00, 0x27, 0x06, 0x01, 0x02, 0x01, 0x00, 0x63, 0x02, 0x01, 0x00, 0x54, 0x00, 0x55, 0x02, 0x01, 0x00, 0x46, 0x00, 0x73, 0x08, 0x01, 0x04, 0x01, 
	0x02, 0x01, 0x00, 0x37, 0x00, 0x65, 0x02, 0x01, 0x00, 0x56, 0x00, 0x74, 0x06, 0x01, 0x02, 0x01, 0x00, 0x47, 0x02, 0x01, 0x00, 0x66, 0x00, 0x75, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0x57, 0x00, 0x76, 0x02, 0x01, 0x00, 0x67, 0x00, 0x77, 
};

const byte hufftbl_11[][2]={
	0x06, 0x01, 0x02, 0x01, 0x00, 0x00, 0x02, 0x01, 0x00, 0x10, 0x00, 0x01, 0x08, 0x01, 0x02, 0x01, 0x00, 0x11, 0x04, 0x01, 0x02, 0x01, 0x00, 0x20, 
	0x00, 0x02, 0x00, 0x12, 0x18, 0x01, 0x08, 0x01, 0x02, 0x01, 0x00, 0x21, 0x02, 0x01, 0x00, 0x22, 0x02, 0x01, 0x00, 0x30, 0x00, 0x03, 0x04, 0x01, 
	0x02, 0x01, 0x00, 0x31, 0x00, 0x13, 0x04, 0x01, 0x02, 0x01, 0x00, 0x32, 0x00, 0x23, 0x04, 0x01, 0x02, 0x01, 0x00, 0x40, 0x00, 0x04, 0x02, 0x01, 
	0x00, 0x41, 0x00, 0x14, 0x1e, 0x01, 0x10, 0x01, 0x0a, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x42, 0x00, 0x24, 0x04, 0x01, 0x02, 0x01, 0x00, 0x33, 
	0x00, 0x43, 0x00, 0x50, 0x04, 0x01, 0x02, 0x01, 0x00, 0x34, 0x00, 0x51, 0x00, 0x61, 0x06, 0x01, 0x02, 0x01, 0x00, 0x16, 0x02, 0x01, 0x00, 0x06, 
	0x00, 0x26, 0x02, 0x01, 0x00, 0x62, 0x02, 0x01, 0x00, 0x15, 0x02, 0x01, 0x00, 0x05, 0x00, 0x52, 0x10, 0x01, 0x0a, 0x01, 0x06, 0x01, 0x04, 0x01, 
	0x02, 0x01, 0x00, 0x25, 0x00, 0x44, 0x00, 0x60, 0x02, 0x01, 0x00, 0x63, 0x00, 0x36, 0x04, 0x01, 0x02, 0x01, 0x00, 0x70, 0x00, 0x17, 0x00, 0x71, 
	0x10, 0x01, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x07, 0x00, 0x64, 0x00, 0x72, 0x02, 0x01, 0x00, 0x27, 0x04, 0x01, 0x02, 0x01, 0x00, 0x53, 
	0x00, 0x35, 0x02, 0x01, 0x00, 0x54, 0x00, 0x45, 0x0a, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x46, 0x00, 0x73, 0x02, 0x01, 0x00, 0x37, 0x02, 0x01, 
	0x00, 0x65, 0x00, 0x56, 0x0a, 0x01, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x55, 0x00, 0x57, 0x00, 0x74, 0x02, 0x01, 0x00, 0x47, 0x00, 0x66, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0x75, 0x00, 0x76, 0x02, 0x01, 0x00, 0x67, 0x00, 0x77, 
};

const byte hufftbl_12[][2]={
	0x0c, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x10, 0x00, 0x01, 0x02, 0x01, 0x00, 0x11, 0x02, 0x01, 0x00, 0x00, 0x02, 0x01, 0x00, 0x20, 0x00, 0x02, 
	0x10, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x21, 0x00, 0x12, 0x04, 0x01, 0x02, 0x01, 0x00, 0x22, 0x00, 0x31, 0x02, 0x01, 0x00, 0x13, 0x02, 0x01, 
	0x00, 0x30, 0x02, 0x01, 0x00, 0x03, 0x00, 0x40, 0x1a, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x32, 0x00, 0x23, 0x02, 0x01, 0x00, 0x41, 
	0x00, 0x33, 0x0a, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x14, 0x00, 0x42, 0x02, 0x01, 0x00, 0x24, 0x02, 0x01, 0x00, 0x04, 0x00, 0x50, 0x04, 0x01, 
	0x02, 0x01, 0x00, 0x43, 0x00, 0x34, 0x02, 0x01, 0x00, 0x51, 0x00, 0x15, 0x1c, 0x01, 0x0e, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x52, 
	0x00, 0x25, 0x02, 0x01, 0x00, 0x53, 0x00, 0x35, 0x04, 0x01, 0x02, 0x01, 0x00, 0x60, 0x00, 0x16, 0x00, 0x61, 0x04, 0x01, 0x02, 0x01, 0x00, 0x62, 
	0x00, 0x26, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x05, 0x00, 0x06, 0x00, 0x44, 0x02, 0x01, 0x00, 0x54, 0x00, 0x45, 0x12, 0x01, 0x0a, 0x01, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0x63, 0x00, 0x36, 0x04, 0x01, 0x02, 0x01, 0x00, 0x70, 0x00, 0x07, 0x00, 0x71, 0x04, 0x01, 0x02, 0x01, 0x00, 0x17, 
	0x00, 0x64, 0x02, 0x01, 0x00, 0x46, 0x00, 0x72, 0x0a, 0x01, 0x06, 0x01, 0x02, 0x01, 0x00, 0x27, 0x02, 0x01, 0x00, 0x55, 0x00, 0x73, 0x02, 0x01, 
	0x00, 0x37, 0x00, 0x56, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x65, 0x00, 0x74, 0x02, 0x01, 0x00, 0x47, 0x00, 0x66, 0x04, 0x01, 0x02, 0x01, 
	0x00, 0x75, 0x00, 0x57, 0x02, 0x01, 0x00, 0x76, 0x02, 0x01, 0x00, 0x67, 0x00, 0x77, 
};

const byte hufftbl_13[][2]={
	0x02, 0x01, 0x00, 0x00, 0x06, 0x01, 0x02, 0x01, 0x00, 0x10, 0x02, 0x01, 0x00, 0x01, 0x00, 0x11, 0x1c, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 
	0x00, 0x20, 0x00, 0x02, 0x02, 0x01, 0x00, 0x21, 0x00, 0x12, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x22, 0x00, 0x30, 0x02, 0x01, 0x00, 0x03, 
	0x00, 0x31, 0x06, 0x01, 0x02, 0x01, 0x00, 0x13, 0x02, 0x01, 0x00, 0x32, 0x00, 0x23, 0x04, 0x01, 0x02, 0x01, 0x00, 0x40, 0x00, 0x04, 0x00, 0x41, 
	0x46, 0x01, 0x1c, 0x01, 0x0e, 0x01, 0x06, 0x01, 0x02, 0x01, 0x00, 0x14, 0x02, 0x01, 0x00, 0x33, 0x00, 0x42, 0x04, 0x01, 0x02, 0x01, 0x00, 0x24, 
	0x00, 0x50, 0x02, 0x01, 0x00, 0x43, 0x00, 0x34, 0x04, 0x01, 0x02, 0x01, 0x00, 0x51, 0x00, 0x15, 0x04, 0x01, 0x02, 0x01, 0x00, 0x05, 0x00, 0x52, 
	0x02, 0x01, 0x00, 0x25, 0x02, 0x01, 0x00, 0x44, 0x00, 0x53, 0x0e, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x60, 0x00, 0x06, 0x02, 0x01, 
	0x00, 0x61, 0x00, 0x16, 0x04, 0x01, 0x02, 0x01, 0x00, 0x80, 0x00, 0x08, 0x00, 0x81, 0x10, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x35, 
	0x00, 0x62, 0x02, 0x01, 0x00, 0x26, 0x00, 0x54, 0x04, 0x01, 0x02, 0x01, 0x00, 0x45, 0x00, 0x63, 0x02, 0x01, 0x00, 0x36, 0x00, 0x70, 0x06, 0x01, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0x07, 0x00, 0x55, 0x00, 0x71, 0x02, 0x01, 0x00, 0x17, 0x02, 0x01, 0x00, 0x27, 0x00, 0x37, 0x48, 0x01, 0x18, 0x01, 
	0x0c, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x18, 0x00, 0x82, 0x02, 0x01, 0x00, 0x28, 0x04, 0x01, 0x02, 0x01, 0x00, 0x64, 0x00, 0x46, 0x00, 0x72, 
	0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x84, 0x00, 0x48, 0x02, 0x01, 0x00, 0x90, 0x00, 0x09, 0x02, 0x01, 0x00, 0x91, 0x00, 0x19, 0x18, 0x01, 
	0x0e, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x73, 0x00, 0x65, 0x02, 0x01, 0x00, 0x56, 0x00, 0x74, 0x04, 0x01, 0x02, 0x01, 0x00, 0x47, 
	0x00, 0x66, 0x00, 0x83, 0x06, 0x01, 0x02, 0x01, 0x00, 0x38, 0x02, 0x01, 0x00, 0x75, 0x00, 0x57, 0x02, 0x01, 0x00, 0x92, 0x00, 0x29, 0x0e, 0x01, 
	0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x67, 0x00, 0x85, 0x02, 0x01, 0x00, 0x58, 0x00, 0x39, 0x02, 0x01, 0x00, 0x93, 0x02, 0x01, 0x00, 0x49, 
	0x00, 0x86, 0x06, 0x01, 0x02, 0x01, 0x00, 0xa0, 0x02, 0x01, 0x00, 0x68, 0x00, 0x0a, 0x02, 0x01, 0x00, 0xa1, 0x00, 0x1a, 0x44, 0x01, 0x18, 0x01, 
	0x0c, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xa2, 0x00, 0x2a, 0x04, 0x01, 0x02, 0x01, 0x00, 0x95, 0x00, 0x59, 0x02, 0x01, 0x00, 0xa3, 0x00, 0x3a, 
	0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x4a, 0x00, 0x96, 0x02, 0x01, 0x00, 0xb0, 0x00, 0x0b, 0x02, 0x01, 0x00, 0xb1, 0x00, 0x1b, 0x14, 0x01, 
	0x08, 0x01, 0x02, 0x01, 0x00, 0xb2, 0x04, 0x01, 0x02, 0x01, 0x00, 0x76, 0x00, 0x77, 0x00, 0x94, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x87, 
	0x00, 0x78, 0x00, 0xa4, 0x04, 0x01, 0x02, 0x01, 0x00, 0x69, 0x00, 0xa5, 0x00, 0x2b, 0x0c, 0x01, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x5a, 
	0x00, 0x88, 0x00, 0xb3, 0x02, 0x01, 0x00, 0x3b, 0x02, 0x01, 0x00, 0x79, 0x00, 0xa6, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x6a, 0x00, 0xb4, 
	0x00, 0xc0, 0x04, 0x01, 0x02, 0x01, 0x00, 0x0c, 0x00, 0x98, 0x00, 0xc1, 0x3c, 0x01, 0x16, 0x01, 0x0a, 0x01, 0x06, 0x01, 0x02, 0x01, 0x00, 0x1c, 
	0x02, 0x01, 0x00, 0x89, 0x00, 0xb5, 0x02, 0x01, 0x00, 0x5b, 0x00, 0xc2, 0x04, 0x01, 0x02, 0x01, 0x00, 0x2c, 0x00, 0x3c, 0x04, 0x01, 0x02, 0x01, 
	0x00, 0xb6, 0x00, 0x6b, 0x02, 0x01, 0x00, 0xc4, 0x00, 0x4c, 0x10, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xa8, 0x00, 0x8a, 0x02, 0x01, 
	0x00, 0xd0, 0x00, 0x0d, 0x02, 0x01, 0x00, 0xd1, 0x02, 0x01, 0x00, 0x4b, 0x02, 0x01, 0x00, 0x97, 0x00, 0xa7, 0x0c, 0x01, 0x06, 0x01, 0x02, 0x01, 
	0x00, 0xc3, 0x02, 0x01, 0x00, 0x7a, 0x00, 0x99, 0x04, 0x01, 0x02, 0x01, 0x00, 0xc5, 0x00, 0x5c, 0x00, 0xb7, 0x04, 0x01, 0x02, 0x01, 0x00, 0x1d, 
	0x00, 0xd2, 0x02, 0x01, 0x00, 0x2d, 0x02, 0x01, 0x00, 0x7b, 0x00, 0xd3, 0x34, 0x01, 0x1c, 0x01, 0x0c, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x3d, 
	0x00, 0xc6, 0x04, 0x01, 0x02, 0x01, 0x00, 0x6c, 0x00, 0xa9, 0x02, 0x01, 0x00, 0x9a, 0x00, 0xd4, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xb8, 
	0x00, 0x8b, 0x02, 0x01, 0x00, 0x4d, 0x00, 0xc7, 0x04, 0x01, 0x02, 0x01, 0x00, 0x7c, 0x00, 0xd5, 0x02, 0x01, 0x00, 0x5d, 0x00, 0xe0, 0x0a, 0x01, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0xe1, 0x00, 0x1e, 0x04, 0x01, 0x02, 0x01, 0x00, 0x0e, 0x00, 0x2e, 0x00, 0xe2, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 
	0x00, 0xe3, 0x00, 0x6d, 0x02, 0x01, 0x00, 0x8c, 0x00, 0xe4, 0x04, 0x01, 0x02, 0x01, 0x00, 0xe5, 0x00, 0xba, 0x00, 0xf0, 0x26, 0x01, 0x10, 0x01, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0xf1, 0x00, 0x1f, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xaa, 0x00, 0x9b, 0x00, 0xb9, 0x02, 0x01, 0x00, 0x3e, 
	0x02, 0x01, 0x00, 0xd6, 0x00, 0xc8, 0x0c, 0x01, 0x06, 0x01, 0x02, 0x01, 0x00, 0x4e, 0x02, 0x01, 0x00, 0xd7, 0x00, 0x7d, 0x02, 0x01, 0x00, 0xab, 
	0x02, 0x01, 0x00, 0x5e, 0x00, 0xc9, 0x06, 0x01, 0x02, 0x01, 0x00, 0x0f, 0x02, 0x01, 0x00, 0x9c, 0x00, 0x6e, 0x02, 0x01, 0x00, 0xf2, 0x00, 0x2f, 
	0x20, 0x01, 0x10, 0x01, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xd8, 0x00, 0x8d, 0x00, 0x3f, 0x06, 0x01, 0x02, 0x01, 0x00, 0xf3, 0x02, 0x01, 
	0x00, 0xe6, 0x00, 0xca, 0x02, 0x01, 0x00, 0xf4, 0x00, 0x4f, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xbb, 0x00, 0xac, 0x02, 0x01, 0x00, 0xe7, 
	0x00, 0xf5, 0x04, 0x01, 0x02, 0x01, 0x00, 0xd9, 0x00, 0x9d, 0x02, 0x01, 0x00, 0x5f, 0x00, 0xe8, 0x1e, 0x01, 0x0c, 0x01, 0x06, 0x01, 0x02, 0x01, 
	0x00, 0x6f, 0x02, 0x01, 0x00, 0xf6, 0x00, 0xcb, 0x04, 0x01, 0x02, 0x01, 0x00, 0xbc, 0x00, 0xad, 0x00, 0xda, 0x08, 0x01, 0x02, 0x01, 0x00, 0xf7, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0x7e, 0x00, 0x7f, 0x00, 0x8e, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x9e, 0x00, 0xae, 0x00, 0xcc, 0x02, 0x01, 
	0x00, 0xf8, 0x00, 0x8f, 0x12, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xdb, 0x00, 0xbd, 0x02, 0x01, 0x00, 0xea, 0x00, 0xf9, 0x04, 0x01, 
	0x02, 0x01, 0x00, 0x9f, 0x00, 0xeb, 0x02, 0x01, 0x00, 0xbe, 0x02, 0x01, 0x00, 0xcd, 0x00, 0xfa, 0x0e, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xdd, 
	0x00, 0xec, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xe9, 0x00, 0xaf, 0x00, 0xdc, 0x02, 0x01, 0x00, 0xce, 0x00, 0xfb, 0x08, 0x01, 0x04, 0x01, 
	0x02, 0x01, 0x00, 0xbf, 0x00, 0xde, 0x02, 0x01, 0x00, 0xcf, 0x00, 0xee, 0x04, 0x01, 0x02, 0x01, 0x00, 0xdf, 0x00, 0xef, 0x02, 0x01, 0x00, 0xff, 
	0x02, 0x01, 0x00, 0xed, 0x02, 0x01, 0x00, 0xfd, 0x02, 0x01, 0x00, 0xfc, 0x00, 0xfe, 
};

const byte hufftbl_15[][2]={
	0x10, 0x01, 0x06, 0x01, 0x02, 0x01, 0x00, 0x00, 0x02, 0x01, 0x00, 0x10, 0x00, 0x01, 0x02, 0x01, 0x00, 0x11, 0x04, 0x01, 0x02, 0x01, 0x00, 0x20, 
	0x00, 0x02, 0x02, 0x01, 0x00, 0x21, 0x00, 0x12, 0x32, 0x01, 0x10, 0x01, 0x06, 0x01, 0x02, 0x01, 0x00, 0x22, 0x02, 0x01, 0x00, 0x30, 0x00, 0x31, 
	0x06, 0x01, 0x02, 0x01, 0x00, 0x13, 0x02, 0x01, 0x00, 0x03, 0x00, 0x40, 0x02, 0x01, 0x00, 0x32, 0x00, 0x23, 0x0e, 0x01, 0x06, 0x01, 0x04, 0x01, 
	0x02, 0x01, 0x00, 0x04, 0x00, 0x14, 0x00, 0x41, 0x04, 0x01, 0x02, 0x01, 0x00, 0x33, 0x00, 0x42, 0x02, 0x01, 0x00, 0x24, 0x00, 0x43, 0x0a, 0x01, 
	0x06, 0x01, 0x02, 0x01, 0x00, 0x34, 0x02, 0x01, 0x00, 0x50, 0x00, 0x05, 0x02, 0x01, 0x00, 0x51, 0x00, 0x15, 0x04, 0x01, 0x02, 0x01, 0x00, 0x52, 
	0x00, 0x25, 0x04, 0x01, 0x02, 0x01, 0x00, 0x44, 0x00, 0x53, 0x00, 0x61, 0x5a, 0x01, 0x24, 0x01, 0x12, 0x01, 0x0a, 0x01, 0x06, 0x01, 0x02, 0x01, 
	0x00, 0x35, 0x02, 0x01, 0x00, 0x60, 0x00, 0x06, 0x02, 0x01, 0x00, 0x16, 0x00, 0x62, 0x04, 0x01, 0x02, 0x01, 0x00, 0x26, 0x00, 0x54, 0x02, 0x01, 
	0x00, 0x45, 0x00, 0x63, 0x0a, 0x01, 0x06, 0x01, 0x02, 0x01, 0x00, 0x36, 0x02, 0x01, 0x00, 0x70, 0x00, 0x07, 0x02, 0x01, 0x00, 0x71, 0x00, 0x55, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0x17, 0x00, 0x64, 0x02, 0x01, 0x00, 0x72, 0x00, 0x27, 0x18, 0x01, 0x10, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 
	0x00, 0x46, 0x00, 0x73, 0x02, 0x01, 0x00, 0x37, 0x00, 0x65, 0x04, 0x01, 0x02, 0x01, 0x00, 0x56, 0x00, 0x80, 0x02, 0x01, 0x00, 0x08, 0x00, 0x74, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0x81, 0x00, 0x18, 0x02, 0x01, 0x00, 0x82, 0x00, 0x28, 0x10, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x47, 
	0x00, 0x66, 0x02, 0x01, 0x00, 0x83, 0x00, 0x38, 0x04, 0x01, 0x02, 0x01, 0x00, 0x75, 0x00, 0x57, 0x02, 0x01, 0x00, 0x84, 0x00, 0x48, 0x06, 0x01, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0x90, 0x00, 0x19, 0x00, 0x91, 0x04, 0x01, 0x02, 0x01, 0x00, 0x92, 0x00, 0x76, 0x02, 0x01, 0x00, 0x67, 0x00, 0x29, 
	0x5c, 0x01, 0x24, 0x01, 0x12, 0x01, 0x0a, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x85, 0x00, 0x58, 0x04, 0x01, 0x02, 0x01, 0x00, 0x09, 0x00, 0x77, 
	0x00, 0x93, 0x04, 0x01, 0x02, 0x01, 0x00, 0x39, 0x00, 0x94, 0x02, 0x01, 0x00, 0x49, 0x00, 0x86, 0x0a, 0x01, 0x06, 0x01, 0x02, 0x01, 0x00, 0x68, 
	0x02, 0x01, 0x00, 0xa0, 0x00, 0x0a, 0x02, 0x01, 0x00, 0xa1, 0x00, 0x1a, 0x04, 0x01, 0x02, 0x01, 0x00, 0xa2, 0x00, 0x2a, 0x02, 0x01, 0x00, 0x95, 
	0x00, 0x59, 0x1a, 0x01, 0x0e, 0x01, 0x06, 0x01, 0x02, 0x01, 0x00, 0xa3, 0x02, 0x01, 0x00, 0x3a, 0x00, 0x87, 0x04, 0x01, 0x02, 0x01, 0x00, 0x78, 
	0x00, 0xa4, 0x02, 0x01, 0x00, 0x4a, 0x00, 0x96, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x69, 0x00, 0xb0, 0x00, 0xb1, 0x04, 0x01, 0x02, 0x01, 
	0x00, 0x1b, 0x00, 0xa5, 0x00, 0xb2, 0x0e, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x5a, 0x00, 0x2b, 0x02, 0x01, 0x00, 0x88, 0x00, 0x97, 
	0x02, 0x01, 0x00, 0xb3, 0x02, 0x01, 0x00, 0x79, 0x00, 0x3b, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x6a, 0x00, 0xb4, 0x02, 0x01, 0x00, 0x4b, 
	0x00, 0xc1, 0x04, 0x01, 0x02, 0x01, 0x00, 0x98, 0x00, 0x89, 0x02, 0x01, 0x00, 0x1c, 0x00, 0xb5, 0x50, 0x01, 0x22, 0x01, 0x10, 0x01, 0x06, 0x01, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0x5b, 0x00, 0x2c, 0x00, 0xc2, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x0b, 0x00, 0xc0, 0x00, 0xa6, 0x02, 0x01, 
	0x00, 0xa7, 0x00, 0x7a, 0x0a, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xc3, 0x00, 0x3c, 0x04, 0x01, 0x02, 0x01, 0x00, 0x0c, 0x00, 0x99, 0x00, 0xb6, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0x6b, 0x00, 0xc4, 0x02, 0x01, 0x00, 0x4c, 0x00, 0xa8, 0x14, 0x01, 0x0a, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x8a, 
	0x00, 0xc5, 0x04, 0x01, 0x02, 0x01, 0x00, 0xd0, 0x00, 0x5c, 0x00, 0xd1, 0x04, 0x01, 0x02, 0x01, 0x00, 0xb7, 0x00, 0x7b, 0x02, 0x01, 0x00, 0x1d, 
	0x02, 0x01, 0x00, 0x0d, 0x00, 0x2d, 0x0c, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xd2, 0x00, 0xd3, 0x04, 0x01, 0x02, 0x01, 0x00, 0x3d, 0x00, 0xc6, 
	0x02, 0x01, 0x00, 0x6c, 0x00, 0xa9, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x9a, 0x00, 0xb8, 0x00, 0xd4, 0x04, 0x01, 0x02, 0x01, 0x00, 0x8b, 
	0x00, 0x4d, 0x02, 0x01, 0x00, 0xc7, 0x00, 0x7c, 0x44, 0x01, 0x22, 0x01, 0x12, 0x01, 0x0a, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xd5, 0x00, 0x5d, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0xe0, 0x00, 0x0e, 0x00, 0xe1, 0x04, 0x01, 0x02, 0x01, 0x00, 0x1e, 0x00, 0xe2, 0x02, 0x01, 0x00, 0xaa, 0x00, 0x2e, 
	0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xb9, 0x00, 0x9b, 0x02, 0x01, 0x00, 0xe3, 0x00, 0xd6, 0x04, 0x01, 0x02, 0x01, 0x00, 0x6d, 0x00, 0x3e, 
	0x02, 0x01, 0x00, 0xc8, 0x00, 0x8c, 0x10, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xe4, 0x00, 0x4e, 0x02, 0x01, 0x00, 0xd7, 0x00, 0x7d, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0xe5, 0x00, 0xba, 0x02, 0x01, 0x00, 0xab, 0x00, 0x5e, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xc9, 0x00, 0x9c, 
	0x02, 0x01, 0x00, 0xf1, 0x00, 0x1f, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xf0, 0x00, 0x6e, 0x00, 0xf2, 0x02, 0x01, 0x00, 0x2f, 0x00, 0xe6, 
	0x26, 0x01, 0x12, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xd8, 0x00, 0xf3, 0x02, 0x01, 0x00, 0x3f, 0x00, 0xf4, 0x06, 0x01, 0x02, 0x01, 
	0x00, 0x4f, 0x02, 0x01, 0x00, 0x8d, 0x00, 0xd9, 0x02, 0x01, 0x00, 0xbb, 0x00, 0xca, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xac, 0x00, 0xe7, 
	0x02, 0x01, 0x00, 0x7e, 0x00, 0xf5, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x9d, 0x00, 0x5f, 0x02, 0x01, 0x00, 0xe8, 0x00, 0x8e, 0x02, 0x01, 
	0x00, 0xf6, 0x00, 0xcb, 0x22, 0x01, 0x12, 0x01, 0x0a, 0x01, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x0f, 0x00, 0xae, 0x00, 0x6f, 0x02, 0x01, 
	0x00, 0xbc, 0x00, 0xda, 0x04, 0x01, 0x02, 0x01, 0x00, 0xad, 0x00, 0xf7, 0x02, 0x01, 0x00, 0x7f, 0x00, 0xe9, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 
	0x00, 0x9e, 0x00, 0xcc, 0x02, 0x01, 0x00, 0xf8, 0x00, 0x8f, 0x04, 0x01, 0x02, 0x01, 0x00, 0xdb, 0x00, 0xbd, 0x02, 0x01, 0x00, 0xea, 0x00, 0xf9, 
	0x10, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x9f, 0x00, 0xdc, 0x02, 0x01, 0x00, 0xcd, 0x00, 0xeb, 0x04, 0x01, 0x02, 0x01, 0x00, 0xbe, 
	0x00, 0xfa, 0x02, 0x01, 0x00, 0xaf, 0x00, 0xdd, 0x0e, 0x01, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xec, 0x00, 0xce, 0x00, 0xfb, 0x04, 0x01, 
	0x02, 0x01, 0x00, 0xbf, 0x00, 0xed, 0x02, 0x01, 0x00, 0xde, 0x00, 0xfc, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xcf, 0x00, 0xfd, 0x00, 0xee, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0xdf, 0x00, 0xfe, 0x02, 0x01, 0x00, 0xef, 0x00, 0xff, 
};

const byte hufftbl_16[][2]={
	0x02, 0x01, 0x00, 0x00, 0x06, 0x01, 0x02, 0x01, 0x00, 0x10, 0x02, 0x01, 0x00, 0x01, 0x00, 0x11, 0x2a, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 
	0x00, 0x20, 0x00, 0x02, 0x02, 0x01, 0x00, 0x21, 0x00, 0x12, 0x0a, 0x01, 0x06, 0x01, 0x02, 0x01, 0x00, 0x22, 0x02, 0x01, 0x00, 0x30, 0x00, 0x03, 
	0x02, 0x01, 0x00, 0x31, 0x00, 0x13, 0x0a, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x32, 0x00, 0x23, 0x04, 0x01, 0x02, 0x01, 0x00, 0x40, 0x00, 0x04, 
	0x00, 0x41, 0x06, 0x01, 0x02, 0x01, 0x00, 0x14, 0x02, 0x01, 0x00, 0x33, 0x00, 0x42, 0x04, 0x01, 0x02, 0x01, 0x00, 0x24, 0x00, 0x50, 0x02, 0x01, 
	0x00, 0x43, 0x00, 0x34, 0x8a, 0x01, 0x28, 0x01, 0x10, 0x01, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x05, 0x00, 0x15, 0x00, 0x51, 0x04, 0x01, 
	0x02, 0x01, 0x00, 0x52, 0x00, 0x25, 0x04, 0x01, 0x02, 0x01, 0x00, 0x44, 0x00, 0x35, 0x00, 0x53, 0x0a, 0x01, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 
	0x00, 0x60, 0x00, 0x06, 0x00, 0x61, 0x02, 0x01, 0x00, 0x16, 0x00, 0x62, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x26, 0x00, 0x54, 0x02, 0x01, 
	0x00, 0x45, 0x00, 0x63, 0x04, 0x01, 0x02, 0x01, 0x00, 0x36, 0x00, 0x70, 0x00, 0x71, 0x28, 0x01, 0x12, 0x01, 0x08, 0x01, 0x02, 0x01, 0x00, 0x17, 
	0x02, 0x01, 0x00, 0x07, 0x02, 0x01, 0x00, 0x55, 0x00, 0x64, 0x04, 0x01, 0x02, 0x01, 0x00, 0x72, 0x00, 0x27, 0x04, 0x01, 0x02, 0x01, 0x00, 0x46, 
	0x00, 0x65, 0x00, 0x73, 0x0a, 0x01, 0x06, 0x01, 0x02, 0x01, 0x00, 0x37, 0x02, 0x01, 0x00, 0x56, 0x00, 0x08, 0x02, 0x01, 0x00, 0x80, 0x00, 0x81, 
	0x06, 0x01, 0x02, 0x01, 0x00, 0x18, 0x02, 0x01, 0x00, 0x74, 0x00, 0x47, 0x02, 0x01, 0x00, 0x82, 0x02, 0x01, 0x00, 0x28, 0x00, 0x66, 0x18, 0x01, 
	0x0e, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x83, 0x00, 0x38, 0x02, 0x01, 0x00, 0x75, 0x00, 0x84, 0x04, 0x01, 0x02, 0x01, 0x00, 0x48, 
	0x00, 0x90, 0x00, 0x91, 0x06, 0x01, 0x02, 0x01, 0x00, 0x19, 0x02, 0x01, 0x00, 0x09, 0x00, 0x76, 0x02, 0x01, 0x00, 0x92, 0x00, 0x29, 0x0e, 0x01, 
	0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x85, 0x00, 0x58, 0x02, 0x01, 0x00, 0x93, 0x00, 0x39, 0x04, 0x01, 0x02, 0x01, 0x00, 0xa0, 0x00, 0x0a, 
	0x00, 0x1a, 0x08, 0x01, 0x02, 0x01, 0x00, 0xa2, 0x02, 0x01, 0x00, 0x67, 0x02, 0x01, 0x00, 0x57, 0x00, 0x49, 0x06, 0x01, 0x02, 0x01, 0x00, 0x94, 
	0x02, 0x01, 0x00, 0x77, 0x00, 0x86, 0x02, 0x01, 0x00, 0xa1, 0x02, 0x01, 0x00, 0x68, 0x00, 0x95, 0xdc, 0x01, 0x7e, 0x01, 0x32, 0x01, 0x1a, 0x01, 
	0x0c, 0x01, 0x06, 0x01, 0x02, 0x01, 0x00, 0x2a, 0x02, 0x01, 0x00, 0x59, 0x00, 0x3a, 0x02, 0x01, 0x00, 0xa3, 0x02, 0x01, 0x00, 0x87, 0x00, 0x78, 
	0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xa4, 0x00, 0x4a, 0x02, 0x01, 0x00, 0x96, 0x00, 0x69, 0x04, 0x01, 0x02, 0x01, 0x00, 0xb0, 0x00, 0x0b, 
	0x00, 0xb1, 0x0a, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x1b, 0x00, 0xb2, 0x02, 0x01, 0x00, 0x2b, 0x02, 0x01, 0x00, 0xa5, 0x00, 0x5a, 0x06, 0x01, 
	0x02, 0x01, 0x00, 0xb3, 0x02, 0x01, 0x00, 0xa6, 0x00, 0x6a, 0x04, 0x01, 0x02, 0x01, 0x00, 0xb4, 0x00, 0x4b, 0x02, 0x01, 0x00, 0x0c, 0x00, 0xc1, 
	0x1e, 0x01, 0x0e, 0x01, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xb5, 0x00, 0xc2, 0x00, 0x2c, 0x04, 0x01, 0x02, 0x01, 0x00, 0xa7, 0x00, 0xc3, 
	0x02, 0x01, 0x00, 0x6b, 0x00, 0xc4, 0x08, 0x01, 0x02, 0x01, 0x00, 0x1d, 0x04, 0x01, 0x02, 0x01, 0x00, 0x88, 0x00, 0x97, 0x00, 0x3b, 0x04, 0x01, 
	0x02, 0x01, 0x00, 0xd1, 0x00, 0xd2, 0x02, 0x01, 0x00, 0x2d, 0x00, 0xd3, 0x12, 0x01, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x1e, 0x00, 0x2e, 
	0x00, 0xe2, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x79, 0x00, 0x98, 0x00, 0xc0, 0x02, 0x01, 0x00, 0x1c, 0x02, 0x01, 0x00, 0x89, 0x00, 0x5b, 
	0x0e, 0x01, 0x06, 0x01, 0x02, 0x01, 0x00, 0x3c, 0x02, 0x01, 0x00, 0x7a, 0x00, 0xb6, 0x04, 0x01, 0x02, 0x01, 0x00, 0x4c, 0x00, 0x99, 0x02, 0x01, 
	0x00, 0xa8, 0x00, 0x8a, 0x06, 0x01, 0x02, 0x01, 0x00, 0x0d, 0x02, 0x01, 0x00, 0xc5, 0x00, 0x5c, 0x04, 0x01, 0x02, 0x01, 0x00, 0x3d, 0x00, 0xc6, 
	0x02, 0x01, 0x00, 0x6c, 0x00, 0x9a, 0x58, 0x01, 0x56, 0x01, 0x24, 0x01, 0x10, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x8b, 0x00, 0x4d, 
	0x02, 0x01, 0x00, 0xc7, 0x00, 0x7c, 0x04, 0x01, 0x02, 0x01, 0x00, 0xd5, 0x00, 0x5d, 0x02, 0x01, 0x00, 0xe0, 0x00, 0x0e, 0x08, 0x01, 0x02, 0x01, 
	0x00, 0xe3, 0x04, 0x01, 0x02, 0x01, 0x00, 0xd0, 0x00, 0xb7, 0x00, 0x7b, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xa9, 0x00, 0xb8, 0x00, 0xd4, 
	0x02, 0x01, 0x00, 0xe1, 0x02, 0x01, 0x00, 0xaa, 0x00, 0xb9, 0x18, 0x01, 0x0a, 0x01, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x9b, 0x00, 0xd6, 
	0x00, 0x6d, 0x02, 0x01, 0x00, 0x3e, 0x00, 0xc8, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x8c, 0x00, 0xe4, 0x00, 0x4e, 0x04, 0x01, 0x02, 0x01, 
	0x00, 0xd7, 0x00, 0xe5, 0x02, 0x01, 0x00, 0xba, 0x00, 0xab, 0x0c, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x9c, 0x00, 0xe6, 0x04, 0x01, 0x02, 0x01, 
	0x00, 0x6e, 0x00, 0xd8, 0x02, 0x01, 0x00, 0x8d, 0x00, 0xbb, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xe7, 0x00, 0x9d, 0x02, 0x01, 0x00, 0xe8, 
	0x00, 0x8e, 0x04, 0x01, 0x02, 0x01, 0x00, 0xcb, 0x00, 0xbc, 0x00, 0x9e, 0x00, 0xf1, 0x02, 0x01, 0x00, 0x1f, 0x02, 0x01, 0x00, 0x0f, 0x00, 0x2f, 
	0x42, 0x01, 0x38, 0x01, 0x02, 0x01, 0x00, 0xf2, 0x34, 0x01, 0x32, 0x01, 0x14, 0x01, 0x08, 0x01, 0x02, 0x01, 0x00, 0xbd, 0x02, 0x01, 0x00, 0x5e, 
	0x02, 0x01, 0x00, 0x7d, 0x00, 0xc9, 0x06, 0x01, 0x02, 0x01, 0x00, 0xca, 0x02, 0x01, 0x00, 0xac, 0x00, 0x7e, 0x04, 0x01, 0x02, 0x01, 0x00, 0xda, 
	0x00, 0xad, 0x00, 0xcc, 0x0a, 0x01, 0x06, 0x01, 0x02, 0x01, 0x00, 0xae, 0x02, 0x01, 0x00, 0xdb, 0x00, 0xdc, 0x02, 0x01, 0x00, 0xcd, 0x00, 0xbe, 
	0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xeb, 0x00, 0xed, 0x00, 0xee, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xd9, 0x00, 0xea, 0x00, 0xe9, 
	0x02, 0x01, 0x00, 0xde, 0x04, 0x01, 0x02, 0x01, 0x00, 0xdd, 0x00, 0xec, 0x00, 0xce, 0x00, 0x3f, 0x00, 0xf0, 0x04, 0x01, 0x02, 0x01, 0x00, 0xf3, 
	0x00, 0xf4, 0x02, 0x01, 0x00, 0x4f, 0x02, 0x01, 0x00, 0xf5, 0x00, 0x5f, 0x0a, 0x01, 0x02, 0x01, 0x00, 0xff, 0x04, 0x01, 0x02, 0x01, 0x00, 0xf6, 
	0x00, 0x6f, 0x02, 0x01, 0x00, 0xf7, 0x00, 0x7f, 0x0c, 0x01, 0x06, 0x01, 0x02, 0x01, 0x00, 0x8f, 0x02, 0x01, 0x00, 0xf8, 0x00, 0xf9, 0x04, 0x01, 
	0x02, 0x01, 0x00, 0x9f, 0x00, 0xfa, 0x00, 0xaf, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xfb, 0x00, 0xbf, 0x02, 0x01, 0x00, 0xfc, 0x00, 0xcf, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0xfd, 0x00, 0xdf, 0x02, 0x01, 0x00, 0xfe, 0x00, 0xef, 
};

const byte hufftbl_24[][2]={
	0x3c, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x10, 0x02, 0x01, 0x00, 0x01, 0x00, 0x11, 0x0e, 0x01, 0x06, 0x01, 0x04, 0x01, 
	0x02, 0x01, 0x00, 0x20, 0x00, 0x02, 0x00, 0x21, 0x02, 0x01, 0x00, 0x12, 0x02, 0x01, 0x00, 0x22, 0x02, 0x01, 0x00, 0x30, 0x00, 0x03, 0x0e, 0x01, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0x31, 0x00, 0x13, 0x04, 0x01, 0x02, 0x01, 0x00, 0x32, 0x00, 0x23, 0x04, 0x01, 0x02, 0x01, 0x00, 0x40, 0x00, 0x04, 
	0x00, 0x41, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x14, 0x00, 0x33, 0x02, 0x01, 0x00, 0x42, 0x00, 0x24, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 
	0x00, 0x43, 0x00, 0x34, 0x00, 0x51, 0x06, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x50, 0x00, 0x05, 0x00, 0x15, 0x02, 0x01, 0x00, 0x52, 0x00, 0x25, 
	0xfa, 0x01, 0x62, 0x01, 0x22, 0x01, 0x12, 0x01, 0x0a, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x44, 0x00, 0x53, 0x02, 0x01, 0x00, 0x35, 0x02, 0x01, 
	0x00, 0x60, 0x00, 0x06, 0x04, 0x01, 0x02, 0x01, 0x00, 0x61, 0x00, 0x16, 0x02, 0x01, 0x00, 0x62, 0x00, 0x26, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 
	0x00, 0x54, 0x00, 0x45, 0x02, 0x01, 0x00, 0x63, 0x00, 0x36, 0x04, 0x01, 0x02, 0x01, 0x00, 0x71, 0x00, 0x55, 0x02, 0x01, 0x00, 0x64, 0x00, 0x46, 
	0x20, 0x01, 0x0e, 0x01, 0x06, 0x01, 0x02, 0x01, 0x00, 0x72, 0x02, 0x01, 0x00, 0x27, 0x00, 0x37, 0x02, 0x01, 0x00, 0x73, 0x04, 0x01, 0x02, 0x01, 
	0x00, 0x70, 0x00, 0x07, 0x00, 0x17, 0x0a, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x65, 0x00, 0x56, 0x04, 0x01, 0x02, 0x01, 0x00, 0x80, 0x00, 0x08, 
	0x00, 0x81, 0x04, 0x01, 0x02, 0x01, 0x00, 0x74, 0x00, 0x47, 0x02, 0x01, 0x00, 0x18, 0x00, 0x82, 0x10, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 
	0x00, 0x28, 0x00, 0x66, 0x02, 0x01, 0x00, 0x83, 0x00, 0x38, 0x04, 0x01, 0x02, 0x01, 0x00, 0x75, 0x00, 0x57, 0x02, 0x01, 0x00, 0x84, 0x00, 0x48, 
	0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x91, 0x00, 0x19, 0x02, 0x01, 0x00, 0x92, 0x00, 0x76, 0x04, 0x01, 0x02, 0x01, 0x00, 0x67, 0x00, 0x29, 
	0x02, 0x01, 0x00, 0x85, 0x00, 0x58, 0x5c, 0x01, 0x22, 0x01, 0x10, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x93, 0x00, 0x39, 0x02, 0x01, 
	0x00, 0x94, 0x00, 0x49, 0x04, 0x01, 0x02, 0x01, 0x00, 0x77, 0x00, 0x86, 0x02, 0x01, 0x00, 0x68, 0x00, 0xa1, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 
	0x00, 0xa2, 0x00, 0x2a, 0x02, 0x01, 0x00, 0x95, 0x00, 0x59, 0x04, 0x01, 0x02, 0x01, 0x00, 0xa3, 0x00, 0x3a, 0x02, 0x01, 0x00, 0x87, 0x02, 0x01, 
	0x00, 0x78, 0x00, 0x4a, 0x16, 0x01, 0x0c, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xa4, 0x00, 0x96, 0x04, 0x01, 0x02, 0x01, 0x00, 0x69, 0x00, 0xb1, 
	0x02, 0x01, 0x00, 0x1b, 0x00, 0xa5, 0x06, 0x01, 0x02, 0x01, 0x00, 0xb2, 0x02, 0x01, 0x00, 0x5a, 0x00, 0x2b, 0x02, 0x01, 0x00, 0x88, 0x00, 0xb3, 
	0x10, 0x01, 0x0a, 0x01, 0x06, 0x01, 0x02, 0x01, 0x00, 0x90, 0x02, 0x01, 0x00, 0x09, 0x00, 0xa0, 0x02, 0x01, 0x00, 0x97, 0x00, 0x79, 0x04, 0x01, 
	0x02, 0x01, 0x00, 0xa6, 0x00, 0x6a, 0x00, 0xb4, 0x0c, 0x01, 0x06, 0x01, 0x02, 0x01, 0x00, 0x1a, 0x02, 0x01, 0x00, 0x0a, 0x00, 0xb0, 0x02, 0x01, 
	0x00, 0x3b, 0x02, 0x01, 0x00, 0x0b, 0x00, 0xc0, 0x04, 0x01, 0x02, 0x01, 0x00, 0x4b, 0x00, 0xc1, 0x02, 0x01, 0x00, 0x98, 0x00, 0x89, 0x43, 0x01, 
	0x22, 0x01, 0x10, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x1c, 0x00, 0xb5, 0x02, 0x01, 0x00, 0x5b, 0x00, 0xc2, 0x04, 0x01, 0x02, 0x01, 
	0x00, 0x2c, 0x00, 0xa7, 0x02, 0x01, 0x00, 0x7a, 0x00, 0xc3, 0x0a, 0x01, 0x06, 0x01, 0x02, 0x01, 0x00, 0x3c, 0x02, 0x01, 0x00, 0x0c, 0x00, 0xd0, 
	0x02, 0x01, 0x00, 0xb6, 0x00, 0x6b, 0x04, 0x01, 0x02, 0x01, 0x00, 0xc4, 0x00, 0x4c, 0x02, 0x01, 0x00, 0x99, 0x00, 0xa8, 0x10, 0x01, 0x08, 0x01, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0x8a, 0x00, 0xc5, 0x02, 0x01, 0x00, 0x5c, 0x00, 0xd1, 0x04, 0x01, 0x02, 0x01, 0x00, 0xb7, 0x00, 0x7b, 0x02, 0x01, 
	0x00, 0x1d, 0x00, 0xd2, 0x09, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x2d, 0x00, 0xd3, 0x02, 0x01, 0x00, 0x3d, 0x00, 0xc6, 0x55, 0xfa, 0x04, 0x01, 
	0x02, 0x01, 0x00, 0x6c, 0x00, 0xa9, 0x02, 0x01, 0x00, 0x9a, 0x00, 0xd4, 0x20, 0x01, 0x10, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xb8, 
	0x00, 0x8b, 0x02, 0x01, 0x00, 0x4d, 0x00, 0xc7, 0x04, 0x01, 0x02, 0x01, 0x00, 0x7c, 0x00, 0xd5, 0x02, 0x01, 0x00, 0x5d, 0x00, 0xe1, 0x08, 0x01, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0x1e, 0x00, 0xe2, 0x02, 0x01, 0x00, 0xaa, 0x00, 0xb9, 0x04, 0x01, 0x02, 0x01, 0x00, 0x9b, 0x00, 0xe3, 0x02, 0x01, 
	0x00, 0xd6, 0x00, 0x6d, 0x14, 0x01, 0x0a, 0x01, 0x06, 0x01, 0x02, 0x01, 0x00, 0x3e, 0x02, 0x01, 0x00, 0x2e, 0x00, 0x4e, 0x02, 0x01, 0x00, 0xc8, 
	0x00, 0x8c, 0x04, 0x01, 0x02, 0x01, 0x00, 0xe4, 0x00, 0xd7, 0x04, 0x01, 0x02, 0x01, 0x00, 0x7d, 0x00, 0xab, 0x00, 0xe5, 0x0a, 0x01, 0x04, 0x01, 
	0x02, 0x01, 0x00, 0xba, 0x00, 0x5e, 0x02, 0x01, 0x00, 0xc9, 0x02, 0x01, 0x00, 0x9c, 0x00, 0x6e, 0x08, 0x01, 0x02, 0x01, 0x00, 0xe6, 0x02, 0x01, 
	0x00, 0x0d, 0x02, 0x01, 0x00, 0xe0, 0x00, 0x0e, 0x04, 0x01, 0x02, 0x01, 0x00, 0xd8, 0x00, 0x8d, 0x02, 0x01, 0x00, 0xbb, 0x00, 0xca, 0x4a, 0x01, 
	0x02, 0x01, 0x00, 0xff, 0x40, 0x01, 0x3a, 0x01, 0x20, 0x01, 0x10, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xac, 0x00, 0xe7, 0x02, 0x01, 
	0x00, 0x7e, 0x00, 0xd9, 0x04, 0x01, 0x02, 0x01, 0x00, 0x9d, 0x00, 0xe8, 0x02, 0x01, 0x00, 0x8e, 0x00, 0xcb, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 
	0x00, 0xbc, 0x00, 0xda, 0x02, 0x01, 0x00, 0xad, 0x00, 0xe9, 0x04, 0x01, 0x02, 0x01, 0x00, 0x9e, 0x00, 0xcc, 0x02, 0x01, 0x00, 0xdb, 0x00, 0xbd, 
	0x10, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xea, 0x00, 0xae, 0x02, 0x01, 0x00, 0xdc, 0x00, 0xcd, 0x04, 0x01, 0x02, 0x01, 0x00, 0xeb, 
	0x00, 0xbe, 0x02, 0x01, 0x00, 0xdd, 0x00, 0xec, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xce, 0x00, 0xed, 0x02, 0x01, 0x00, 0xde, 0x00, 0xee, 
	0x00, 0x0f, 0x04, 0x01, 0x02, 0x01, 0x00, 0xf0, 0x00, 0x1f, 0x00, 0xf1, 0x04, 0x01, 0x02, 0x01, 0x00, 0xf2, 0x00, 0x2f, 0x02, 0x01, 0x00, 0xf3, 
	0x00, 0x3f, 0x12, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xf4, 0x00, 0x4f, 0x02, 0x01, 0x00, 0xf5, 0x00, 0x5f, 0x04, 0x01, 0x02, 0x01, 
	0x00, 0xf6, 0x00, 0x6f, 0x02, 0x01, 0x00, 0xf7, 0x02, 0x01, 0x00, 0x7f, 0x00, 0x8f, 0x0a, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xf8, 0x00, 0xf9, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0x9f, 0x00, 0xaf, 0x00, 0xfa, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0xfb, 0x00, 0xbf, 0x02, 0x01, 0x00, 0xfc, 
	0x00, 0xcf, 0x04, 0x01, 0x02, 0x01, 0x00, 0xfd, 0x00, 0xdf, 0x02, 0x01, 0x00, 0xfe, 0x00, 0xef,


};

static const int hufftbl_24_shortcut[16]={
	487, 470, 398, 397,
	251, 160, 96, 63,
	37, 24, 16, 11,
	8, 7, 5, 4
};

/*
const byte hufftbl_32[][2]={
	0x02, 0x01, 0x00, 0x00, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x08, 0x00, 0x04, 0x02, 0x01, 0x00, 0x01, 0x00, 0x02, 0x08, 0x01, 0x04, 0x01, 
	0x02, 0x01, 0x00, 0x0c, 0x00, 0x0a, 0x02, 0x01, 0x00, 0x03, 0x00, 0x06, 0x06, 0x01, 0x02, 0x01, 0x00, 0x09, 0x02, 0x01, 0x00, 0x05, 0x00, 0x07, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0x0e, 0x00, 0x0d, 0x02, 0x01, 0x00, 0x0f, 0x00, 0x0b, 
};

const byte hufftbl_33[][2]={
	0x10, 0x01, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x00, 0x00, 0x01, 0x02, 0x01, 0x00, 0x02, 0x00, 0x03, 0x04, 0x01, 0x02, 0x01, 0x00, 0x04, 
	0x00, 0x05, 0x02, 0x01, 0x00, 0x06, 0x00, 0x07, 0x08, 0x01, 0x04, 0x01, 0x02, 0x01, 0x00, 0x08, 0x00, 0x09, 0x02, 0x01, 0x00, 0x0a, 0x00, 0x0b, 
	0x04, 0x01, 0x02, 0x01, 0x00, 0x0c, 0x00, 0x0d, 0x02, 0x01, 0x00, 0x0e, 0x00, 0x0f, 
};
*/

// These are for count1 decoding; they're value/bit instead of tree form

const byte hufftbl_32[64][2]={
	11,6,							// 000000 -> 11
	15,6,							// 000001 -> 15
	13,6,							// 000010 -> 13
	14,6,							// 000011 -> 14
	7, 6,							// 000100 -> 7
	6, 6,							// 000101 -> 5

	9, 5,	9, 5,					// 00011 -> 9
	6, 5,	6, 5,					// 00100 -> 6
	3, 5,	3, 5,					// 00101 -> 3
	10,5,	10,5,					// 00110 -> 10
	12,5,	12,5,					// 00111 -> 12

	2, 4,	2, 4,	2, 4,	2, 4,	// 0100 -> 2
	1, 4,	1, 4,	1, 4,	1, 4,	// 0101 -> 1
	4, 4,	4, 4,	4, 4,	4, 4,	// 0110 -> 4
	8, 4,	8, 4,	8, 4,	8, 4,	// 0111 -> 8

	0, 1,	0, 1,	0, 1,	0, 1,	// 1 -> 0
	0, 1,	0, 1,	0, 1,	0, 1,
	0, 1,	0, 1,	0, 1,	0, 1,
	0, 1,	0, 1,	0, 1,	0, 1,
	0, 1,	0, 1,	0, 1,	0, 1,
	0, 1,	0, 1,	0, 1,	0, 1,
	0, 1,	0, 1,	0, 1,	0, 1,
	0, 1,	0, 1,	0, 1,	0, 1,
};

const signed char hufftbl_33[256][4] = {
	{  1,  1,  1,  1 }, {  1,  1,  1, -1 }, {  1,  1, -1,  1 }, {  1,  1, -1, -1 },
	{  1, -1,  1,  1 }, {  1, -1,  1, -1 }, {  1, -1, -1,  1 }, {  1, -1, -1, -1 },
	{ -1,  1,  1,  1 }, { -1,  1,  1, -1 }, { -1,  1, -1,  1 }, { -1,  1, -1, -1 },
	{ -1, -1,  1,  1 }, { -1, -1,  1, -1 }, { -1, -1, -1,  1 }, { -1, -1, -1, -1 },
	{  1,  1,  1,  0 }, {  1,  1,  1,  0 }, {  1,  1, -1,  0 }, {  1,  1, -1,  0 },
	{  1, -1,  1,  0 }, {  1, -1,  1,  0 }, {  1, -1, -1,  0 }, {  1, -1, -1,  0 },
	{ -1,  1,  1,  0 }, { -1,  1,  1,  0 }, { -1,  1, -1,  0 }, { -1,  1, -1,  0 },
	{ -1, -1,  1,  0 }, { -1, -1,  1,  0 }, { -1, -1, -1,  0 }, { -1, -1, -1,  0 },
	{  1,  1,  0,  1 }, {  1,  1,  0,  1 }, {  1,  1,  0, -1 }, {  1,  1,  0, -1 },
	{  1, -1,  0,  1 }, {  1, -1,  0,  1 }, {  1, -1,  0, -1 }, {  1, -1,  0, -1 },
	{ -1,  1,  0,  1 }, { -1,  1,  0,  1 }, { -1,  1,  0, -1 }, { -1,  1,  0, -1 },
	{ -1, -1,  0,  1 }, { -1, -1,  0,  1 }, { -1, -1,  0, -1 }, { -1, -1,  0, -1 },
	{  1,  1,  0,  0 }, {  1,  1,  0,  0 }, {  1,  1,  0,  0 }, {  1,  1,  0,  0 },
	{  1, -1,  0,  0 }, {  1, -1,  0,  0 }, {  1, -1,  0,  0 }, {  1, -1,  0,  0 },
	{ -1,  1,  0,  0 }, { -1,  1,  0,  0 }, { -1,  1,  0,  0 }, { -1,  1,  0,  0 },
	{ -1, -1,  0,  0 }, { -1, -1,  0,  0 }, { -1, -1,  0,  0 }, { -1, -1,  0,  0 },
	{  1,  0,  1,  1 }, {  1,  0,  1,  1 }, {  1,  0,  1, -1 }, {  1,  0,  1, -1 },
	{  1,  0, -1,  1 }, {  1,  0, -1,  1 }, {  1,  0, -1, -1 }, {  1,  0, -1, -1 },
	{ -1,  0,  1,  1 }, { -1,  0,  1,  1 }, { -1,  0,  1, -1 }, { -1,  0,  1, -1 },
	{ -1,  0, -1,  1 }, { -1,  0, -1,  1 }, { -1,  0, -1, -1 }, { -1,  0, -1, -1 },
	{  1,  0,  1,  0 }, {  1,  0,  1,  0 }, {  1,  0,  1,  0 }, {  1,  0,  1,  0 },
	{  1,  0, -1,  0 }, {  1,  0, -1,  0 }, {  1,  0, -1,  0 }, {  1,  0, -1,  0 },
	{ -1,  0,  1,  0 }, { -1,  0,  1,  0 }, { -1,  0,  1,  0 }, { -1,  0,  1,  0 },
	{ -1,  0, -1,  0 }, { -1,  0, -1,  0 }, { -1,  0, -1,  0 }, { -1,  0, -1,  0 },
	{  1,  0,  0,  1 }, {  1,  0,  0,  1 }, {  1,  0,  0,  1 }, {  1,  0,  0,  1 },
	{  1,  0,  0, -1 }, {  1,  0,  0, -1 }, {  1,  0,  0, -1 }, {  1,  0,  0, -1 },
	{ -1,  0,  0,  1 }, { -1,  0,  0,  1 }, { -1,  0,  0,  1 }, { -1,  0,  0,  1 },
	{ -1,  0,  0, -1 }, { -1,  0,  0, -1 }, { -1,  0,  0, -1 }, { -1,  0,  0, -1 },
	{  1,  0,  0,  0 }, {  1,  0,  0,  0 }, {  1,  0,  0,  0 }, {  1,  0,  0,  0 },
	{  1,  0,  0,  0 }, {  1,  0,  0,  0 }, {  1,  0,  0,  0 }, {  1,  0,  0,  0 },
	{ -1,  0,  0,  0 }, { -1,  0,  0,  0 }, { -1,  0,  0,  0 }, { -1,  0,  0,  0 },
	{ -1,  0,  0,  0 }, { -1,  0,  0,  0 }, { -1,  0,  0,  0 }, { -1,  0,  0,  0 },
	{  0,  1,  1,  1 }, {  0,  1,  1,  1 }, {  0,  1,  1, -1 }, {  0,  1,  1, -1 },
	{  0,  1, -1,  1 }, {  0,  1, -1,  1 }, {  0,  1, -1, -1 }, {  0,  1, -1, -1 },
	{  0, -1,  1,  1 }, {  0, -1,  1,  1 }, {  0, -1,  1, -1 }, {  0, -1,  1, -1 },
	{  0, -1, -1,  1 }, {  0, -1, -1,  1 }, {  0, -1, -1, -1 }, {  0, -1, -1, -1 },
	{  0,  1,  1,  0 }, {  0,  1,  1,  0 }, {  0,  1,  1,  0 }, {  0,  1,  1,  0 },
	{  0,  1, -1,  0 }, {  0,  1, -1,  0 }, {  0,  1, -1,  0 }, {  0,  1, -1,  0 },
	{  0, -1,  1,  0 }, {  0, -1,  1,  0 }, {  0, -1,  1,  0 }, {  0, -1,  1,  0 },
	{  0, -1, -1,  0 }, {  0, -1, -1,  0 }, {  0, -1, -1,  0 }, {  0, -1, -1,  0 },
	{  0,  1,  0,  1 }, {  0,  1,  0,  1 }, {  0,  1,  0,  1 }, {  0,  1,  0,  1 },
	{  0,  1,  0, -1 }, {  0,  1,  0, -1 }, {  0,  1,  0, -1 }, {  0,  1,  0, -1 },
	{  0, -1,  0,  1 }, {  0, -1,  0,  1 }, {  0, -1,  0,  1 }, {  0, -1,  0,  1 },
	{  0, -1,  0, -1 }, {  0, -1,  0, -1 }, {  0, -1,  0, -1 }, {  0, -1,  0, -1 },
	{  0,  1,  0,  0 }, {  0,  1,  0,  0 }, {  0,  1,  0,  0 }, {  0,  1,  0,  0 },
	{  0,  1,  0,  0 }, {  0,  1,  0,  0 }, {  0,  1,  0,  0 }, {  0,  1,  0,  0 },
	{  0, -1,  0,  0 }, {  0, -1,  0,  0 }, {  0, -1,  0,  0 }, {  0, -1,  0,  0 },
	{  0, -1,  0,  0 }, {  0, -1,  0,  0 }, {  0, -1,  0,  0 }, {  0, -1,  0,  0 },
	{  0,  0,  1,  1 }, {  0,  0,  1,  1 }, {  0,  0,  1,  1 }, {  0,  0,  1,  1 },
	{  0,  0,  1, -1 }, {  0,  0,  1, -1 }, {  0,  0,  1, -1 }, {  0,  0,  1, -1 },
	{  0,  0, -1,  1 }, {  0,  0, -1,  1 }, {  0,  0, -1,  1 }, {  0,  0, -1,  1 },
	{  0,  0, -1, -1 }, {  0,  0, -1, -1 }, {  0,  0, -1, -1 }, {  0,  0, -1, -1 },
	{  0,  0,  1,  0 }, {  0,  0,  1,  0 }, {  0,  0,  1,  0 }, {  0,  0,  1,  0 },
	{  0,  0,  1,  0 }, {  0,  0,  1,  0 }, {  0,  0,  1,  0 }, {  0,  0,  1,  0 },
	{  0,  0, -1,  0 }, {  0,  0, -1,  0 }, {  0,  0, -1,  0 }, {  0,  0, -1,  0 },
	{  0,  0, -1,  0 }, {  0,  0, -1,  0 }, {  0,  0, -1,  0 }, {  0,  0, -1,  0 },
	{  0,  0,  0,  1 }, {  0,  0,  0,  1 }, {  0,  0,  0,  1 }, {  0,  0,  0,  1 },
	{  0,  0,  0,  1 }, {  0,  0,  0,  1 }, {  0,  0,  0,  1 }, {  0,  0,  0,  1 },
	{  0,  0,  0, -1 }, {  0,  0,  0, -1 }, {  0,  0,  0, -1 }, {  0,  0,  0, -1 },
	{  0,  0,  0, -1 }, {  0,  0,  0, -1 }, {  0,  0,  0, -1 }, {  0,  0,  0, -1 },
	{  0,  0,  0,  0 }, {  0,  0,  0,  0 }, {  0,  0,  0,  0 }, {  0,  0,  0,  0 },
	{  0,  0,  0,  0 }, {  0,  0,  0,  0 }, {  0,  0,  0,  0 }, {  0,  0,  0,  0 },
	{  0,  0,  0,  0 }, {  0,  0,  0,  0 }, {  0,  0,  0,  0 }, {  0,  0,  0,  0 },
	{  0,  0,  0,  0 }, {  0,  0,  0,  0 }, {  0,  0,  0,  0 }, {  0,  0,  0,  0 },
};

static const struct hufftab_t {
	int treelen;
	int xlen, ylen;
	int linbits;
	const byte (*val)[2];
} tables[]={
	{   7,  2,  2,  0, hufftbl_1 },
	{  17,  3,  3,  0, hufftbl_2 },
	{  17,  3,  3,  0, hufftbl_3 },
	{   0,  0,  0,  0, NULL },
	{  31,  4,  4,  0, hufftbl_5 },
	{  31,  4,  4,  0, hufftbl_6 },
	{  71,  6,  6,  0, hufftbl_7 },
	{  71,  6,  6,  0, hufftbl_8 },
	{  71,  6,  6,  0, hufftbl_9 },
	{ 127,  8,  8,  0, hufftbl_10 },
	{ 127,  8,  8,  0, hufftbl_11 },
	{ 127,  8,  8,  0, hufftbl_12 },
	{ 511, 16, 16,  0, hufftbl_13 },
	{   0,  0,  0,  0, NULL },
	{ 511, 16, 16,  0, hufftbl_15 },
	{ 511, 16, 16,  1, hufftbl_16 },
	{ 511, 16, 16,  2, hufftbl_16 },
	{ 511, 16, 16,  3, hufftbl_16 },
	{ 511, 16, 16,  4, hufftbl_16 },
	{ 511, 16, 16,  6, hufftbl_16 },
	{ 511, 16, 16,  8, hufftbl_16 },
	{ 511, 16, 16, 10, hufftbl_16 },
	{ 511, 16, 16, 13, hufftbl_16 },
	{ 512, 16, 16,  4, hufftbl_24 },
	{ 512, 16, 16,  5, hufftbl_24 },
	{ 512, 16, 16,  6, hufftbl_24 },
	{ 512, 16, 16,  7, hufftbl_24 },
	{ 512, 16, 16,  8, hufftbl_24 },
	{ 512, 16, 16,  9, hufftbl_24 },
	{ 512, 16, 16, 11, hufftbl_24 },
	{ 512, 16, 16, 13, hufftbl_24 },
};

#define MXOFF (250)

//unsigned long dmask = 1 << (4*8-1);

static const byte bitcnts[16]={ 8, 7, 7, 6, 7, 6, 6, 5, 7, 6, 6, 5, 6, 5, 5, 4 };
static const byte bitcnts2[16]={ 0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4 };

int AMPDecoder::L3_GetHuffmanCount1_32(long *is, int i, int bit_threshold) {

	int point;
	int y;

	/* Lookup in Huffman table. */

	while(i<=18*32-4 && tellbits() > bit_threshold) {
		point = peekbits2(6);

		if (point >= 32) {
			is[0] = is[1] = is[2] = is[3] = 0;
			skipbit();
		} else if (point >= 16) {
			static int tbl[8]={ 0, 0, 0, 0, 3, 2, 0, 1 };

			y = 1;
			if (point & 2)
				y = -1;

			skipbits(5);

			is[0] = is[1] = is[2] = is[3] = 0;
			is[tbl[point>>2]] = y;

		} else {
			y = hufftbl_32[point][0];
			skipbits(hufftbl_32[point][1]);

			is[0] = is[1] = is[2] = is[3] = 0;

			if (y&8) {
				is[0] = 1;
				if (getflag())
					is[0] = -1;
			}
			if (y&4) {
				is[1] = 1;
				if (getflag())
					is[1] = -1;
			}
			if (y&2) {
				is[2] = 1;
				if (getflag())
					is[2] = -1;
			}
			if (y&1) {
				is[3] = 1;
				if (getflag())
					is[3] = -1;
			}
		}

		is += 4;
		i += 4;
	}

	return i;
}

int AMPDecoder::L3_GetHuffmanCount1_33(long *is, int i, int bit_threshold) {
	int y;

	while(i<=18*32-4 && tellbits() > bit_threshold) {
		const signed char *tblptr;

		y = peekbits(8);
		skipbits(bitcnts[y>>4]);

		tblptr = &hufftbl_33[y][0];

		is[0] = tblptr[0];
		is[1] = tblptr[1];
		is[2] = tblptr[2];
		is[3] = tblptr[3];

		is += 4;
		i += 4;
	}

	return i;
}

void AMPDecoder::L3_GetHuffmanBig(int table_id, long *is, int count) {

	const struct hufftab_t *h = &tables[table_id - 1];
	int point;
	int error;
	int i;
	int delta;

	if (h->val == NULL)
		return;
	
	// Extract all huffman codes.

	_RPT2(0,"Decoding %ld values: table %d\n", count, table_id);

	if (table_id == 1) {
		for(; count>0; count-=2) {
			int v;

			v = peekbits(5);
			skipbits(hufftbl_1_fast[v].bits);

			is[0] = hufftbl_1_fast[v].x;
			is[1] = hufftbl_1_fast[v].y;
			is+=2;
		}
	} else if (table_id == 2) {
		for(; count>0; count-=2) {
			int v;

			v = peekbits(5);
			if (v < 4) {
				v = peekbits(8);
				skipbits(hufftbl_2_3_hi[v].bits);

				is[0] = hufftbl_2_3_hi[v].x;
				is[1] = hufftbl_2_3_hi[v].y;
			} else {
				skipbits(hufftbl_2_lo[v-4].bits);

				is[0] = hufftbl_2_lo[v-4].x;
				is[1] = hufftbl_2_lo[v-4].y;
			}
			is+=2;
		}
	} else if (table_id == 3) {
		for(; count>0; count-=2) {
			int v;

			v = peekbits(5);
			if (v < 4) {
				v = peekbits(8);
				skipbits(hufftbl_2_3_hi[v].bits);

				is[0] = hufftbl_2_3_hi[v].x;
				is[1] = hufftbl_2_3_hi[v].y;
			} else {
				skipbits(hufftbl_3_lo[v-4].bits);

				is[0] = hufftbl_3_lo[v-4].x;
				is[1] = hufftbl_3_lo[v-4].y;
			}
			is+=2;
		}
	} else if (table_id < 24)
		for(; count>0; count-=2) {

			/* Lookup in Huffman table. */

			point = 0;
			error = 1;
			do {
				if (h->val[point][0]==0) {   /*end of tree*/
					is[0] = h->val[point][1] >> 4;
					is[1] = h->val[point][1] & 0xf;
					
					error = 0;
					break;
				} 
				if (getflag())
					point += h->val[point][1];
				else
					point += h->val[point][0];
			} while (point < h->treelen);

			/* Check for error. */
			
			if (error) { /* set x and y to a medium value as a simple concealment */
		//		printf("Illegal Huffman code in data.\n");
				is[0] = (h->xlen-1 << 1);
				is[1] = (h->ylen-1 << 1);
			}
					
			/* x and y are reversed in the test bitstream.
				Reverse x and y here to make test bitstream work. */
				
			if (h->linbits)
				if ((h->xlen-1) == is[0]) 
					is[0] += getbits(h->linbits);

			if (is[0])
				if (getflag()) is[0] = -is[0];

			if (h->linbits)	  
				if ((h->ylen-1) == is[1])
					is[1] += getbits(h->linbits);

			if (is[1])
				if (getflag()) is[1] = -is[1];

			is += 2;
		}
	else
		for(; count>0; count-=2) {

			// Lookup in Huffman table.
			//
			// Table 24 has some chained jumps (distance MXOFF).

			point = hufftbl_24_shortcut[getbits(4)];
			for(;;) {
				if (h->val[point][0]==0) {   /*end of tree*/
					is[0] = h->val[point][1] >> 4;
					is[1] = h->val[point][1] & 0xf;
					break;
				} 
				if (getflag())
					point += delta = h->val[point][1];
				else
					point += delta = h->val[point][0];
			}
								
			/* x and y are reversed in the test bitstream.
				Reverse x and y here to make test bitstream work. */
				
			if (h->linbits)
				if (15 == is[0]) 
					is[0] += getbits(h->linbits);

			if (is[0])
				if (getflag()) is[0] = -is[0];

			if (h->linbits)	  
				if (15 == is[1])
					is[1] += getbits(h->linbits);

			if (is[1])
				if (getflag()) is[1] = -is[1];

			is += 2;
		}
}

