/* 
 *  MPEGDec.h  -  MPEG audio decoding
 *
 *	Copyright (C) Alberto Vigata - January 2000 - ultraflask@yahoo.com
 *
 *  This file is part of FlasKMPEG, a free MPEG to MPEG/AVI converter
 *	
 *  FlasKMPEG is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  FlasKMPEG is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#if !defined(AFX_MPEGDEC_H__A7F0FAE4_ECB5_11D3_A73C_00000100CF13__INCLUDED_)
#define AFX_MPEGDEC_H__A7F0FAE4_ECB5_11D3_A73C_00000100CF13__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "IAMPDecoder.h"
#include "..\..\flasktypes.h"

#define FRAME_SAMPLES 1152
class CMPEGDec : public IAMPBitsource
{

public:
	int read(void *buffer, int bytes);

	int decodeFrame( ui8 *pcm_samples, ui8 *frame_data, ui32 frame_size);
	int Stop();
	int Start();
	CMPEGDec();
	virtual ~CMPEGDec();
private:
	short       temp_buffer[FRAME_SAMPLES*2];
	int         in_ptr;
	int         frame_size;
	ui8        *frame_data;
	IAMPDecoder *decoder;

};

#endif // !defined(AFX_MPEGDEC_H__A7F0FAE4_ECB5_11D3_A73C_00000100CF13__INCLUDED_)
